/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.commands.support;

import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.fabric8.api.Container;
import io.fabric8.api.FabricService;
import io.fabric8.api.RuntimeProperties;
import io.fabric8.api.commands.JMXResult;
import io.fabric8.commands.support.CommandUtils;
import io.fabric8.commands.support.ContainerGlobSupport;
import io.fabric8.commands.support.JMXCommandActionSupport;
import io.fabric8.utils.FabricValidations;
import io.fabric8.zookeeper.ZkPath;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.queue.PublicStringSerializer;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Option;

public abstract class JMXCommandContainerActionSupport
extends JMXCommandActionSupport {
    @Option(name="-a", aliases={"--all"}, description="Send command to all containers", required=false, multiValued=false)
    protected boolean allContainers = false;
    @Option(name="-t", aliases={"--timeout"}, description="Timeout used when waiting for response(s)", required=false, multiValued=false)
    protected long timeout = 5000L;
    @Argument(index=0, name="container", description="The container names", required=false, multiValued=true)
    protected List<String> containers = null;

    public JMXCommandContainerActionSupport(FabricService fabricService, CuratorFramework curator, RuntimeProperties runtimeProperties) {
        super(fabricService, curator, runtimeProperties);
    }

    @Override
    protected Object doExecute() throws Exception {
        LinkedList<String> names = new LinkedList<String>();
        if (this.allContainers) {
            Container[] all;
            if (this.containers != null && this.containers.size() > 0) {
                System.out.println("Container names are ignored when using \"--all\" option.");
            }
            for (Container c : all = CommandUtils.sortContainers(this.fabricService.getContainers())) {
                names.add(c.getId());
            }
        } else {
            names.addAll(ContainerGlobSupport.expandGlobNames(this.fabricService, this.containers));
        }
        LinkedList<String> validContainerNames = new LinkedList<String>();
        for (String name : names) {
            try {
                FabricValidations.validateContainerName(name);
            }
            catch (IllegalArgumentException e) {
                System.err.println("Skipping illegal container name \"" + name + "\"");
                continue;
            }
            validContainerNames.add(name);
        }
        this.beforeEachContainer(validContainerNames);
        for (String name : validContainerNames) {
            String path = ZkPath.COMMANDS_REQUESTS_QUEUE.getPath(new String[]{name});
            this.performContainerAction(path, name);
        }
        this.afterEachContainer(validContainerNames);
        this.cleanResponses();
        return null;
    }

    protected void beforeEachContainer(Collection<String> names) throws Exception {
    }

    protected abstract void performContainerAction(String var1, String var2) throws Exception;

    protected void afterEachContainer(Collection<String> names) throws Exception {
    }

    protected List<JMXResult> asResults(String path, List<String> responses, Class<?> resultClass) throws Exception {
        ObjectMapper mapper = this.getObjectMapper();
        LinkedList<JMXResult> results = new LinkedList<JMXResult>();
        for (String responsePath : responses) {
            byte[] bytes = (byte[])this.curator.getData().forPath(path + "/" + responsePath);
            String response = PublicStringSerializer.deserialize((byte[])bytes);
            JMXResult result = (JMXResult)mapper.readValue(response, JMXResult.class);
            if (result.getResponse() instanceof String) {
                try {
                    result.setResponse(mapper.readValue((String)result.getResponse(), resultClass));
                }
                catch (JsonMappingException | IllegalArgumentException ignore) {
                    continue;
                }
            }
            results.add(result);
        }
        mapper.getTypeFactory().clearCache();
        return results;
    }
}

