/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.commands;

import io.fabric8.api.FabricService;
import io.fabric8.api.Profile;
import io.fabric8.api.ProfileService;
import io.fabric8.api.Profiles;
import io.fabric8.api.Version;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.karaf.shell.console.AbstractAction;

@Command(name="profile-refresh", scope="fabric", description="Performs a change to the profile, that triggers the deployment agent (It's intended to be used for scanning for snapshot changes)")
public class ProfileRefreshAction
extends AbstractAction {
    @Argument(index=0, name="profile", description="The target profile to edit", required=true, multiValued=false)
    private String profileName;
    @Argument(index=1, name="version", description="The version of the profile to edit. Defaults to the current default version.", required=false, multiValued=false)
    private String versionId;
    private final FabricService fabricService;

    ProfileRefreshAction(FabricService fabricService) {
        this.fabricService = fabricService;
    }

    protected Object doExecute() throws Exception {
        ProfileService profileService = (ProfileService)this.fabricService.adapt(ProfileService.class);
        Version version = this.versionId != null ? profileService.getRequiredVersion(this.versionId) : this.fabricService.getRequiredDefaultVersion();
        Profile profile = version.getProfile(this.profileName);
        if (profile == null) {
            System.out.println("Profile " + this.profileName + " not found.");
            return 1;
        }
        Profiles.refreshProfile((FabricService)this.fabricService, (Profile)profile);
        return null;
    }
}

