/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.commands;

import io.fabric8.api.FabricService;
import io.fabric8.api.RuntimeProperties;
import io.fabric8.api.commands.GitGcResult;
import io.fabric8.api.commands.JMXRequest;
import io.fabric8.api.commands.JMXResult;
import io.fabric8.commands.support.JMXCommandContainerActionSupport;
import io.fabric8.zookeeper.ZkPath;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.framework.recipes.queue.PublicStringSerializer;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.apache.zookeeper.CreateMode;

@Command(name="git-gc", scope="fabric", description="Invokes \"git gc\" command on selected containers")
public class FabricGitGcAction
extends JMXCommandContainerActionSupport {
    @Option(name="--aggressive", description="Set \"--aggressive\" option for \"git gc\"", required=false, multiValued=false)
    protected boolean aggressive = false;
    private Map<String, JMXRequest> requests = new TreeMap<String, JMXRequest>();
    private Map<String, JMXResult> results = new TreeMap<String, JMXResult>();

    public FabricGitGcAction(FabricService fabricService, CuratorFramework curator, RuntimeProperties runtimeProperties) {
        super(fabricService, curator, runtimeProperties);
        this.timeout = 10000L;
    }

    @Override
    protected void performContainerAction(String queuePath, String containerName) throws Exception {
        JMXRequest containerRequest = new JMXRequest().withObjectName("io.fabric8:type=Fabric").withMethod("gitGc").withParam(Boolean.class, (Object)this.aggressive);
        this.requests.put(containerName, containerRequest);
        String command = this.map(containerRequest);
        ((ACLBackgroundPathAndBytesable)this.curator.create().withMode(CreateMode.PERSISTENT_SEQUENTIAL)).forPath(queuePath, PublicStringSerializer.serialize((String)command));
    }

    @Override
    protected void afterEachContainer(Collection<String> names) {
        System.out.printf("Scheduled git-gc command to %d containers. Awaiting response(s).\n", names.size());
        final CountDownLatch latch = new CountDownLatch(this.requests.size());
        Thread waiter = null;
        try {
            waiter = new Thread(new Runnable(){

                @Override
                public void run() {
                    while (true) {
                        String currentContainer = null;
                        try {
                            block6: for (Map.Entry req : FabricGitGcAction.this.requests.entrySet()) {
                                currentContainer = (String)req.getKey();
                                List containerResults = FabricGitGcAction.this.fetchResponses(currentContainer);
                                for (JMXResult result : containerResults) {
                                    if (!result.getCorrelationId().equals(((JMXRequest)req.getValue()).getId())) continue;
                                    FabricGitGcAction.this.results.put(currentContainer, result);
                                    latch.countDown();
                                    continue block6;
                                }
                            }
                            if (FabricGitGcAction.this.results.size() == FabricGitGcAction.this.requests.size()) break;
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                            break;
                        }
                        catch (Exception e) {
                            System.err.println("Problem occurred while fetching response from " + currentContainer + " container: " + e.getMessage());
                            try {
                                Thread.sleep(1000L);
                            }
                            catch (InterruptedException e1) {
                                Thread.currentThread().interrupt();
                                break;
                            }
                        }
                    }
                }
            });
            waiter.start();
            boolean finished = latch.await(this.timeout, TimeUnit.MILLISECONDS);
            if (!finished) {
                waiter.interrupt();
                System.out.println("Timeout waiting for git-gc response");
                return;
            }
            System.out.println();
            for (String containerName : this.results.keySet()) {
                GitGcResult response = (GitGcResult)this.results.get(containerName).getResponse();
                System.out.println("=== \"git gc\" result for container " + containerName + " ===");
                System.out.println("    Time elapsed: " + response.getTime() + "ms");
                if (!"".equals(response.getError())) {
                    System.out.println("    Error: " + response.getError());
                } else {
                    System.out.println("    Result: OK");
                }
                System.out.println();
            }
            System.out.flush();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            waiter.interrupt();
            System.out.println("Interrupted waiting for git-gc response");
        }
    }

    private List<JMXResult> fetchResponses(String containerName) throws Exception {
        String path = ZkPath.COMMANDS_RESPONSES.getPath(new String[]{containerName});
        List responses = (List)this.curator.getChildren().forPath(path);
        return this.asResults(path, responses, GitGcResult.class);
    }
}

