/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.commands;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.fabric8.api.FabricService;
import io.fabric8.utils.TablePrinter;
import io.fabric8.zookeeper.utils.ZooKeeperUtils;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.WatchPathable;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.apache.karaf.shell.console.AbstractAction;
import org.apache.zookeeper.data.Stat;

@Command(name="cluster-list", scope="fabric", description="Lists all cluster groups in the fabric")
public class ClusterListAction
extends AbstractAction {
    protected static String CLUSTER_PREFIX = "/fabric/registry/clusters";
    @Option(name="-v", aliases={"--verbose"}, description="Verbose output", required=false, multiValued=false)
    boolean verbose = false;
    @Argument(required=false, description="Path of the fabric registry node (Zookeeper registry node) to list. Relative paths are evaluated relative to the base node, /fabric/registry/clusters. If not specified, all clusters are listed.")
    String path = "";
    private final FabricService fabricService;
    private final CuratorFramework curator;

    ClusterListAction(FabricService fabricService, CuratorFramework curator) {
        this.fabricService = fabricService;
        this.curator = curator;
    }

    public CuratorFramework getCurator() {
        return this.curator;
    }

    protected Object doExecute() throws Exception {
        String realPath = this.path;
        if (!realPath.startsWith("/")) {
            realPath = CLUSTER_PREFIX;
            if (this.path.length() > 0) {
                realPath = realPath + "/" + this.path;
            }
        }
        if (this.verbose) {
            this.printClusterV(realPath, System.out);
        } else {
            this.printCluster(realPath, System.out);
        }
        return null;
    }

    protected void printCluster(String dir, PrintStream out) throws Exception {
        if (ZooKeeperUtils.exists((CuratorFramework)this.getCurator(), (String)dir) == null) {
            return;
        }
        List children = ZooKeeperUtils.getAllChildren((CuratorFramework)this.getCurator(), (String)dir);
        TreeMap clusters = new TreeMap();
        for (String child : children) {
            String text;
            byte[] data = (byte[])this.getCurator().getData().forPath(child);
            if (data == null || data.length <= 0 || (text = new String(data).trim()).isEmpty()) continue;
            String clusterName = this.getClusterName(dir, child);
            TreeMap<String, ClusterNode> cluster = (TreeMap<String, ClusterNode>)clusters.get(clusterName);
            if (cluster == null) {
                cluster = new TreeMap<String, ClusterNode>();
                clusters.put(clusterName, cluster);
            }
            ObjectMapper mapper = new ObjectMapper();
            Map map = null;
            try {
                map = (Map)mapper.readValue(data, HashMap.class);
            }
            catch (JsonParseException e) {
                this.log.error("Error parsing JSON string: {}", (Object)text);
                throw e;
            }
            ClusterNode node = null;
            Object id = this.value(map, "id", "container");
            if (id == null) continue;
            Object oagent = this.value(map, "container", "agent");
            String agent = oagent == null ? "" : oagent.toString();
            List services = (List)this.value(map, "services");
            node = (ClusterNode)cluster.get(id.toString());
            if (node == null) {
                node = new ClusterNode();
                cluster.put(id.toString(), node);
            }
            if (services != null) {
                if (!services.isEmpty()) {
                    for (Object service : services) {
                        node.services.add(ZooKeeperUtils.getSubstitutedData((CuratorFramework)this.getCurator(), (String)service.toString()));
                    }
                    node.masters.add(agent);
                    continue;
                }
                node.slaves.add(agent);
                continue;
            }
            Object started = this.value(map, "started");
            if (started == Boolean.TRUE) {
                node.masters.add(agent);
                continue;
            }
            node.slaves.add(agent);
        }
        TablePrinter table = new TablePrinter();
        table.columns("cluster", "masters", "slaves", "services");
        for (String clusterName : clusters.keySet()) {
            Map nodes = (Map)clusters.get(clusterName);
            table.row(clusterName, "", "", "", "");
            for (String nodeName : nodes.keySet()) {
                ClusterNode node = (ClusterNode)nodes.get(nodeName);
                table.row("   " + nodeName, this.printList(node.masters), this.printList(node.slaves), this.printList(node.services));
            }
        }
        table.print();
    }

    protected void printClusterV(String dir, PrintStream out) throws Exception {
        Stat stat = ZooKeeperUtils.exists((CuratorFramework)this.getCurator(), (String)dir);
        if (stat == null) {
            out.println("No cluster information for path " + dir);
            return;
        }
        List children = ZooKeeperUtils.getAllChildren((CuratorFramework)this.getCurator(), (String)dir);
        TreeMap clusters = new TreeMap();
        for (String child : children) {
            Object oready;
            String ready;
            String text;
            stat = new Stat();
            byte[] data = (byte[])((WatchPathable)this.getCurator().getData().storingStatIn(stat)).forPath(child);
            if (data == null || data.length <= 0 || (text = new String(data).trim()).isEmpty()) continue;
            String clusterName = this.getClusterName(dir, child);
            String lastPathSegment = child.substring(child.lastIndexOf(47) + 1);
            TreeMap<String, ClusterNode> cluster = (TreeMap<String, ClusterNode>)clusters.get(clusterName);
            if (cluster == null) {
                cluster = new TreeMap<String, ClusterNode>();
                clusters.put(clusterName, cluster);
            }
            ObjectMapper mapper = new ObjectMapper();
            Map map = null;
            try {
                map = (Map)mapper.readValue(data, HashMap.class);
            }
            catch (JsonParseException e) {
                this.log.error("Error parsing JSON string: {}", (Object)text);
                throw e;
            }
            ClusterNode node = null;
            Object id = this.value(map, "id", "container");
            if (id == null) continue;
            Object oagent = this.value(map, "container", "agent");
            String agent = oagent == null ? null : oagent.toString();
            List services = (List)this.value(map, "services");
            node = (ClusterNode)cluster.get(id.toString());
            if (node == null) {
                node = new ClusterNode();
                cluster.put(id.toString(), node);
            }
            String string = ready = (oready = this.value(map, "ready")) == null ? null : Boolean.valueOf(oready.toString()).toString();
            if (services != null) {
                if (!services.isEmpty()) {
                    boolean first = true;
                    for (Object service : services) {
                        node.combined.add(new String[]{agent, null, ZooKeeperUtils.getSubstitutedData((CuratorFramework)this.getCurator(), (String)service.toString()), lastPathSegment, ready});
                    }
                    continue;
                }
                node.combined.add(new String[]{null, agent, null, lastPathSegment, ready});
                continue;
            }
            Object started = this.value(map, "started");
            if (started == Boolean.TRUE) {
                node.combined.add(new String[]{agent, null, null, lastPathSegment, ready});
                continue;
            }
            node.combined.add(new String[]{null, agent, null, lastPathSegment, ready});
        }
        TablePrinter table = new TablePrinter();
        table.columns("cluster", "masters", "slaves", "services", "zk path", "ready");
        for (String clusterName : clusters.keySet()) {
            Map nodes = (Map)clusters.get(clusterName);
            table.row(clusterName, "", "", "", "", "");
            for (String nodeName : nodes.keySet()) {
                ClusterNode node = (ClusterNode)nodes.get(nodeName);
                this.sortClusterInformation(node.combined);
                boolean first = true;
                String previousMaster = null;
                String previousSlave = null;
                for (String[] row : node.combined) {
                    String ready;
                    String master = row[0] == null ? "-" : row[0];
                    String slave = row[1] == null ? "-" : row[1];
                    String service = row[2] == null ? "-" : row[2];
                    String path = row[3] == null ? "-" : row[3];
                    String string = ready = row[4] == null ? "" : row[4];
                    if (row[4] == null) {
                        path = "";
                    }
                    if (!"-".equals(master) && master.equals(previousMaster)) {
                        master = "";
                        slave = "";
                    } else {
                        previousMaster = master;
                    }
                    if (!"-".equals(slave) && slave.equals(previousSlave)) {
                        master = "";
                        slave = "";
                    } else {
                        previousSlave = slave;
                    }
                    if (first) {
                        table.row("   " + nodeName, master, slave, service, path, ready);
                        first = false;
                        continue;
                    }
                    table.row("", master, slave, service, path, ready);
                }
            }
        }
        table.print();
    }

    private void sortClusterInformation(List<String[]> combined) {
        Collections.sort(combined, new Comparator<String[]>(){

            @Override
            public int compare(String[] o1, String[] o2) {
                for (int i = 0; i < 3; ++i) {
                    if (o1[i] == null && o2[i] == null) continue;
                    if (o1[i] != null) {
                        if (o1[i].equals(o2[i])) continue;
                        if (o2[i] == null) {
                            return -1;
                        }
                        return o1[i].compareTo(o2[i]);
                    }
                    return 1;
                }
                return 0;
            }
        });
    }

    protected String printList(List list) {
        if (list.isEmpty()) {
            return "-";
        }
        String text = list.toString();
        return text.substring(1, text.length() - 1);
    }

    protected Object value(Map<String, Object> map, String ... keys) {
        for (String key : keys) {
            Object value = map.get(key);
            if (value == null) continue;
            return value;
        }
        return null;
    }

    protected String getClusterName(String rootDir, String dir) {
        String clusterName = dir;
        if ((clusterName = clusterName.substring(0, clusterName.lastIndexOf("/"))).startsWith(rootDir)) {
            clusterName = clusterName.substring(rootDir.length());
        }
        if (clusterName.startsWith("/")) {
            clusterName = clusterName.substring(1);
        }
        if (clusterName.length() == 0) {
            clusterName = ".";
        }
        return clusterName;
    }

    protected static class ClusterNode {
        public List<String> masters = new ArrayList<String>();
        public List<String> paths = new ArrayList<String>();
        public List<Boolean> ready = new ArrayList<Boolean>();
        public List<String> services = new ArrayList<String>();
        public List<String> slaves = new ArrayList<String>();
        public List<String[]> combined = new ArrayList<String[]>();

        protected ClusterNode() {
        }

        public String toString() {
            return this.masters + " " + this.services + " " + this.slaves;
        }
    }
}

