/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.commands;

import io.fabric8.api.Container;
import io.fabric8.api.FabricService;
import io.fabric8.api.ProfileService;
import io.fabric8.api.Version;
import io.fabric8.boot.commands.support.FabricCommand;
import io.fabric8.commands.support.ContainerUpgradeSupport;
import io.fabric8.utils.FabricValidations;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.apache.karaf.shell.console.AbstractAction;

@Command(name="container-rollback", scope="fabric", description="Roll back the specified containers to an older version", detailedDescription="classpath:containerUpgrade.txt")
public final class ContainerRollbackAction
extends AbstractAction {
    @Option(name="--all", description="Roll back all containers")
    private boolean all;
    @Argument(index=0, name="version", description="The version to roll back to.", required=true)
    private String version;
    @Argument(index=1, name="container", description="The list of containers to roll back. An empty list implies the current container.", required=false, multiValued=true)
    private List<String> containerIds;
    private final FabricService fabricService;
    private final ProfileService profileService;

    ContainerRollbackAction(FabricService fabricService) {
        this.fabricService = fabricService;
        this.profileService = (ProfileService)fabricService.adapt(ProfileService.class);
    }

    protected Object doExecute() throws Exception {
        FabricValidations.validateContainerNames(this.containerIds);
        Version version = this.profileService.getRequiredVersion(this.version);
        if (this.containerIds == null || this.containerIds.isEmpty()) {
            if (this.all) {
                this.containerIds = new ArrayList<String>();
                for (Container container : this.fabricService.getContainers()) {
                    this.containerIds.add(container.getId());
                }
            } else {
                this.containerIds = Arrays.asList(this.fabricService.getCurrentContainer().getId());
            }
        } else if (this.all) {
            throw new IllegalArgumentException("Can not use --all with a list of containers simultaneously");
        }
        ArrayList<Container> toRollback = new ArrayList<Container>();
        ArrayList<Container> same = new ArrayList<Container>();
        for (String containerName : this.containerIds) {
            Container container = FabricCommand.getContainer((FabricService)this.fabricService, (String)containerName);
            int num = ContainerUpgradeSupport.canRollback(version, container);
            if (num < 0) {
                throw new IllegalArgumentException("Container " + container.getId() + " has already lower version " + container.getVersionId() + " than the requested version " + version.getId() + " to rollback.");
            }
            if (num == 0) {
                same.add(container);
                continue;
            }
            toRollback.add(container);
        }
        for (Container container : same) {
            System.out.println("Container " + container.getId() + " is already version " + version.getId());
        }
        for (Container container : toRollback) {
            Version oldVersion = container.getVersion();
            container.setVersion(version);
            this.log.info("Rolled back container {} from {} to {}", new Object[]{container.getId(), oldVersion.getId(), version.getId()});
            System.out.println("Rolled back container " + container.getId() + " from version " + oldVersion.getId() + " to " + version.getId());
        }
        if (this.all) {
            this.fabricService.setDefaultVersionId(version.getId());
            System.out.println("Changed default version to " + version.getId());
        }
        return null;
    }
}

