/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.commands;

import io.fabric8.api.FabricService;
import io.fabric8.api.ProfileService;
import io.fabric8.api.Profiles;
import io.fabric8.api.Version;
import io.fabric8.utils.FabricValidations;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.CompleterValues;
import org.apache.felix.gogo.commands.Option;
import org.apache.karaf.shell.console.AbstractAction;

@Command(name="profile-rename", scope="fabric", description="Rename the specified version of the source profile")
public class ProfileRenameAction
extends AbstractAction {
    @Option(name="--version", description="The profile version to rename. Defaults to the current default version.")
    private String versionId;
    @Option(name="-f", aliases={"--force"}, description="Flag to allow replacing the target profile (if exists).")
    private boolean force;
    @Argument(index=0, required=true, name="profile name", description="Name of the profile.")
    @CompleterValues(index=0)
    private String profileName;
    @Argument(index=1, required=true, name="new profile name", description="New name of the profile.")
    @CompleterValues(index=1)
    private String newName;
    private final ProfileService profileService;
    private final FabricService fabricService;

    ProfileRenameAction(FabricService fabricService) {
        this.profileService = (ProfileService)fabricService.adapt(ProfileService.class);
        this.fabricService = fabricService;
    }

    protected Object doExecute() throws Exception {
        Version version;
        try {
            FabricValidations.validateProfileName(this.newName);
        }
        catch (IllegalArgumentException e) {
            System.out.println(e.getMessage());
            return 1;
        }
        Version version2 = version = this.versionId != null ? this.profileService.getRequiredVersion(this.versionId) : this.fabricService.getRequiredDefaultVersion();
        if (!version.hasProfile(this.profileName)) {
            System.out.println("Profile " + this.profileName + " not found.");
            return 1;
        }
        if (version.hasProfile(this.newName) && !this.force) {
            System.out.println("New name " + this.newName + " already exists. Use --force if you want to overwrite.");
            return null;
        }
        Profiles.renameProfile((FabricService)this.fabricService, (String)version.getId(), (String)this.profileName, (String)this.newName, (boolean)this.force);
        return null;
    }
}

