/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.commands;

import io.fabric8.api.Container;
import io.fabric8.api.FabricService;
import io.fabric8.api.RuntimeProperties;
import io.fabric8.api.commands.JMXRequest;
import io.fabric8.boot.commands.support.FabricCommand;
import io.fabric8.commands.support.JMXCommandActionSupport;
import io.fabric8.utils.shell.ShellUtils;
import io.fabric8.zookeeper.ZkPath;
import io.fabric8.zookeeper.curator.CuratorFrameworkLocator;
import java.util.LinkedList;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.framework.recipes.queue.PublicStringSerializer;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.apache.zookeeper.CreateMode;

@Command(name="leave", scope="fabric", description="Disconnects container from an existing fabric, cleaning all related data")
final class LeaveAction
extends JMXCommandActionSupport {
    @Option(name="-f", aliases={"--force"}, multiValued=false, required=false, description="Force the execution of the command regardless of the known state of the container")
    protected boolean force = false;
    @Argument(required=false, index=0, multiValued=false, description="Container name to disconnect. By default, current container leaves fabric.")
    private String containerName;

    LeaveAction(RuntimeProperties runtimeProperties, FabricService fabricService) {
        super(fabricService, CuratorFrameworkLocator.getCuratorFramework(), runtimeProperties);
    }

    @Override
    protected Object doExecute() throws Exception {
        if (this.containerName == null || "".equals(this.containerName)) {
            this.containerName = this.runtimeProperties.getRuntimeIdentity();
        }
        if (!this.containerExists(this.containerName)) {
            System.out.println("Container " + this.containerName + " does not exist.");
            return null;
        }
        if (FabricCommand.isPartOfEnsemble((FabricService)this.fabricService, (String)this.containerName)) {
            System.out.println("Container is part of the ensemble. It can't be disconnected from fabric.");
            return null;
        }
        Container c = this.fabricService.getContainer(this.containerName);
        boolean alive = c.isAlive();
        if (!alive) {
            if (!this.force) {
                System.out.println("Container is not running. If you want to force disconnect it, use --force option.");
                return null;
            }
            System.out.println("Container is not running. It'll be disconnected anyway without cleaning its configuration, but should never be started again to not break current ensemble.");
        }
        if (c.getMetadata() != null) {
            System.out.println("Container was created using Fabric. Please use fabric:container-delete command instead.");
            return null;
        }
        LinkedList<String> dependent = new LinkedList<String>();
        for (Container container : this.fabricService.getContainers()) {
            while (container.getParent() != null) {
                if (this.containerName.equals(container.getParent().getId())) {
                    dependent.add(container.getId());
                }
                container = container.getParent();
            }
        }
        if (dependent.size() > 0) {
            System.out.printf("Container %s has dependent containers (%s). Can't disconnect it. Please remove its child containers first.\n", this.containerName, dependent);
            return null;
        }
        String response = ShellUtils.readLine(this.session, "Container " + this.containerName + " will be disconnected from Fabric. This operation is not reversible.\n" + "Do you want to proceed? (yes/no): ", false);
        if (!"yes".equalsIgnoreCase(response)) {
            return null;
        }
        String path = ZkPath.COMMANDS_REQUESTS_QUEUE.getPath(new String[]{this.containerName});
        JMXRequest containerRequest = new JMXRequest().withObjectName("io.fabric8:type=Fabric").withMethod("leave");
        String command = this.map(containerRequest);
        ((ACLBackgroundPathAndBytesable)this.curator.create().withMode(CreateMode.PERSISTENT_SEQUENTIAL)).forPath(path, PublicStringSerializer.serialize((String)command));
        System.out.printf("Container %s will leave Fabric and restart - cleanup will be done asynchronously.\n", this.containerName);
        return null;
    }

    private boolean containerExists(String containerName) {
        Container[] containers;
        for (Container c : containers = this.fabricService.getContainers()) {
            if (!containerName.equals(c.getId())) continue;
            return true;
        }
        return false;
    }
}

