/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.commands;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.fabric8.api.Container;
import io.fabric8.api.FabricService;
import io.fabric8.api.RuntimeProperties;
import io.fabric8.api.commands.JMXRequest;
import io.fabric8.api.commands.JMXResult;
import io.fabric8.commands.support.JMXCommandActionSupport;
import io.fabric8.zookeeper.ZkPath;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.utils.ZKPaths;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.zookeeper.KeeperException;

@Command(name="git-master", scope="fabric", description="Checks or changes current Git master in fabric environment")
public class FabricGitMasterAction
extends JMXCommandActionSupport {
    @Argument(index=0, name="container", description="New Git master container", required=false, multiValued=false)
    protected String container = null;
    private Map<String, JMXRequest> requests = new TreeMap<String, JMXRequest>();
    private Map<String, JMXResult> results = new TreeMap<String, JMXResult>();

    public FabricGitMasterAction(FabricService fabricService, CuratorFramework curator, RuntimeProperties runtimeProperties) {
        super(fabricService, curator, runtimeProperties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object doExecute() throws Exception {
        if (this.container == null || "".equals(this.container.trim())) {
            String master = this.fabricService.getGitMaster();
            if (master == null) {
                System.out.println("Can't find container which is current Git master");
                return null;
            }
            System.out.println("Current Git master is: " + master);
            return null;
        }
        if (!this.containerExists(this.container)) {
            System.out.println("Container " + this.container + " does not exist.");
            return null;
        }
        String master = this.fabricService.getGitMaster();
        ObjectMapper mapper = new ObjectMapper().disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        try {
            List children = (List)this.curator.getChildren().forPath(ZkPath.GIT.getPath(new String[0]));
            Collections.sort(children, new Comparator<String>(){

                @Override
                public int compare(String left, String right) {
                    return right.compareTo(left);
                }
            });
            LinkedList<String> toRemove = new LinkedList<String>();
            JsonNode newMaster = null;
            for (String path : children) {
                String fullPath = ZKPaths.makePath((String)ZkPath.GIT.getPath(new String[0]), (String)path);
                byte[] data = (byte[])this.curator.getData().forPath(fullPath);
                JsonNode tree = mapper.readTree(data);
                if (tree == null || tree.get("container") == null) continue;
                String c = tree.get("container").asText();
                if (!c.equals(this.container)) {
                    toRemove.add(fullPath);
                    continue;
                }
                newMaster = tree;
                if (!c.equals(master)) continue;
                System.out.println("Container " + this.container + " is already a Git master.");
                Object var12_15 = null;
                return var12_15;
            }
            if (newMaster == null) {
                System.out.println("Container \"" + this.container + "\" didn't register Git cluster member.");
                Iterator i$ = null;
                return i$;
            }
            System.out.println("Changing Git master to new cluster member: " + newMaster.get("container").asText());
            if (toRemove.size() > 0) {
                for (String fullPath : toRemove) {
                    try {
                        this.curator.delete().forPath(fullPath);
                    }
                    catch (KeeperException.NoNodeException noNodeException) {}
                }
            }
        }
        catch (Exception e) {
            System.err.println("Problem occurred when choosing new Git master: " + e.getMessage());
            this.log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            mapper.getTypeFactory().clearCache();
        }
        return null;
    }

    private boolean containerExists(String containerName) {
        Container[] containers;
        for (Container c : containers = this.fabricService.getContainers()) {
            if (!containerName.equals(c.getId())) continue;
            return true;
        }
        return false;
    }
}

