/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.commands;

import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.fabric8.api.Container;
import io.fabric8.api.CreateChildContainerOptions;
import io.fabric8.api.CreateContainerMetadata;
import io.fabric8.api.FabricException;
import io.fabric8.api.FabricService;
import io.fabric8.api.RuntimeProperties;
import io.fabric8.api.commands.GitVersions;
import io.fabric8.api.commands.JMXRequest;
import io.fabric8.api.commands.JMXResult;
import io.fabric8.api.commands.LocationInformation;
import io.fabric8.commands.support.JMXCommandActionSupport;
import io.fabric8.service.child.ChildContainerProvider;
import io.fabric8.utils.shell.ShellUtils;
import io.fabric8.zookeeper.ZkPath;
import io.fabric8.zookeeper.utils.ZooKeeperUtils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.StringWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.framework.recipes.queue.PublicStringSerializer;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;

@Command(name="instances", scope="fabric", description="Allows to recreate instance.properties configuration from Zookeeper registry")
final class InstancesAction
extends JMXCommandActionSupport {
    private static DateFormat DF = new SimpleDateFormat("yyyyMMddHHmmss");
    @Option(name="-W", multiValued=false, required=false, description="Recreate FUSE_HOME/instances/instance.properties")
    protected boolean originalFile = false;
    @Option(name="--force", multiValued=false, required=false, description="Do not ask for confirmation")
    protected boolean force = false;
    @Option(name="--container", multiValued=false, required=false, description="Recreate instance.properties for specific container")
    protected String container;
    @Argument(required=false, index=0, multiValued=false, description="Target filename to write generated instance.properties")
    private String fileName;

    InstancesAction(RuntimeProperties runtimeProperties, FabricService fabricService, CuratorFramework curatorFramework) {
        super(fabricService, curatorFramework, runtimeProperties);
    }

    @Override
    protected Object doExecute() throws Exception {
        ContainerData rootData = null;
        LinkedHashMap<String, ContainerData> containerData = new LinkedHashMap<String, ContainerData>();
        String toCheck = this.container;
        if (toCheck == null || "".equals(toCheck.trim())) {
            toCheck = this.runtimeProperties.getRuntimeIdentity();
        }
        Container checked = null;
        try {
            checked = this.fabricService.getContainer(toCheck);
        }
        catch (FabricException e) {
            System.err.println("Can't find container named \"" + toCheck + "\"");
            return null;
        }
        String home = null;
        String instances = null;
        if (checked.isRoot()) {
            if (this.runtimeProperties.getRuntimeIdentity().equals(checked.getId())) {
                home = this.runtimeProperties.getProperty("karaf.home");
                instances = this.runtimeProperties.getProperty("karaf.instances");
            } else {
                try {
                    Container current = this.fabricService.getCurrentContainer();
                    while (!current.isRoot()) {
                        current = current.getParent();
                    }
                    if (current.getId().equals(checked.getId())) {
                        home = this.runtimeProperties.getProperty("karaf.home");
                        instances = this.runtimeProperties.getProperty("karaf.instances");
                    }
                }
                catch (FabricException current) {}
            }
        } else if (this.runtimeProperties.getRuntimeIdentity().equals(checked.getId())) {
            home = this.runtimeProperties.getProperty("karaf.home");
            instances = this.runtimeProperties.getProperty("karaf.instances");
        } else {
            Container _c = checked;
            while (!_c.isRoot()) {
                _c = _c.getParent();
            }
            if (this.runtimeProperties.getRuntimeIdentity().equals(_c.getId())) {
                home = this.runtimeProperties.getProperty("karaf.home");
                instances = this.runtimeProperties.getProperty("karaf.instances");
            }
        }
        if (checked.isRoot()) {
            if (this.container == null) {
                System.out.println("Generating instance.properties for current container");
            } else {
                System.out.println("Generating instance.properties for container \"" + this.container + "\"");
            }
        } else {
            while (!checked.isRoot()) {
                checked = checked.getParent();
            }
            if (this.container == null) {
                System.out.println("Generating instance.properties for current container's root container \"" + checked.getId() + "\"");
            } else {
                System.out.println("Generating instance.properties for \"" + this.container + "\" container's root container \"" + checked.getId() + "\"");
            }
        }
        File instancesDir = null;
        if (home != null && instances != null) {
            instancesDir = new File(instances);
        } else {
            System.out.println("Getting location information for container \"" + checked.getId() + "\"");
            Thread waiter = null;
            try {
                final String containerName = checked.getId();
                String path = ZkPath.COMMANDS_REQUESTS_QUEUE.getPath(new String[]{containerName});
                final JMXRequest containerRequest = new JMXRequest().withObjectName("io.fabric8:type=Fabric").withMethod("karafLocations");
                final JMXResult[] containerResult = new JMXResult[1];
                String command = this.map(containerRequest);
                ((ACLBackgroundPathAndBytesable)this.curator.create().withMode(CreateMode.PERSISTENT_SEQUENTIAL)).forPath(path, PublicStringSerializer.serialize((String)command));
                final CountDownLatch latch = new CountDownLatch(1);
                waiter = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        block5: while (true) {
                            try {
                                while (true) {
                                    if (containerResult[0] == null) {
                                        String path = ZkPath.COMMANDS_RESPONSES.getPath(new String[]{containerName});
                                        List responses = (List)InstancesAction.this.curator.getChildren().forPath(path);
                                        containerResult[0] = InstancesAction.this.asResult(containerRequest.getId(), path, responses, GitVersions.class);
                                    }
                                    if (containerResult[0] != null) {
                                        latch.countDown();
                                        break block5;
                                    }
                                    Thread.sleep(1000L);
                                }
                            }
                            catch (InterruptedException e) {
                                Thread.currentThread().interrupt();
                                break;
                            }
                            catch (Exception e) {
                                System.err.println("Problem occurred while fetching response from " + containerName + " container: " + e.getMessage());
                                try {
                                    Thread.sleep(1000L);
                                }
                                catch (InterruptedException e1) {
                                    Thread.currentThread().interrupt();
                                    break;
                                }
                            }
                        }
                    }
                });
                waiter.start();
                boolean finished = latch.await(5000L, TimeUnit.MILLISECONDS);
                if (!finished) {
                    waiter.interrupt();
                    System.out.println("Timeout waiting for location information about remote container \"" + containerName + "\". Please run this command on the container, where instance.properties are to be generated.");
                    return null;
                }
                if (containerResult[0] != null) {
                    home = ((LocationInformation)containerResult[0].getResponse()).getHome();
                    instances = ((LocationInformation)containerResult[0].getResponse()).getInstances();
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                if (waiter != null) {
                    waiter.interrupt();
                }
                System.err.println(e.getMessage());
                System.err.println("Can't get location information about remote container \"" + checked.getId() + "\". Please run this command on the container, where instance.properties are to be generated.");
                return null;
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
                System.err.println("Can't get location information about remote container \"" + checked.getId() + "\". Please run this command on the container, where instance.properties are to be generated.");
                return null;
            }
        }
        try {
            String path = ZkPath.COMMANDS_RESPONSES.getPath(new String[]{checked.getId()});
            List responses = (List)this.curator.getChildren().forPath(path);
            for (String r : responses) {
                this.curator.delete().forPath(path + "/" + r);
            }
        }
        catch (Exception path) {
            // empty catch block
        }
        if (home == null) {
            System.err.println("Can't get location information about remote container \"" + checked.getId() + "\". Please run this command on the container, where instance.properties are to be generated.");
            return null;
        }
        Container[] containers = this.fabricService.getContainers();
        Container[] arr$ = this.fabricService.getContainers();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Container container;
            Container _c = container = arr$[i$];
            while (!_c.isRoot()) {
                _c = _c.getParent();
            }
            if (!checked.getId().equals(_c.getId())) continue;
            ContainerData cd = new ContainerData();
            String id = container.getId();
            if (container.isRoot()) {
                rootData = cd;
            } else {
                containerData.put(id, cd);
            }
            cd.name = container.getId();
            cd.root = container.isRoot();
            cd.pid = container.getProcessId();
            if (cd.pid == null) {
                cd.pid = 0L;
            }
            if (container.isRoot()) {
                String sshPortPath = ZkPath.PORTS_CONTAINER_PID_KEY.getPath(new String[]{container.getId(), "org.apache.karaf.shell", "sshPort"});
                String rmiRegistryPortPath = ZkPath.PORTS_CONTAINER_PID_KEY.getPath(new String[]{container.getId(), "org.apache.karaf.management", "rmiRegistryPort"});
                String rmiServerPortPath = ZkPath.PORTS_CONTAINER_PID_KEY.getPath(new String[]{container.getId(), "org.apache.karaf.management", "rmiServerPort"});
                String sshPort = null;
                try {
                    sshPort = ZooKeeperUtils.getStringData((CuratorFramework)this.curator, (String)sshPortPath);
                }
                catch (KeeperException.NoNodeException ignored) {
                    sshPort = "-1";
                }
                String rmiRegistryPort = null;
                try {
                    rmiRegistryPort = ZooKeeperUtils.getStringData((CuratorFramework)this.curator, (String)rmiRegistryPortPath);
                }
                catch (KeeperException.NoNodeException ignored) {
                    rmiRegistryPort = "-1";
                }
                String rmiServerPort = null;
                try {
                    rmiServerPort = ZooKeeperUtils.getStringData((CuratorFramework)this.curator, (String)rmiServerPortPath);
                }
                catch (KeeperException.NoNodeException ignored) {
                    rmiServerPort = "-1";
                }
                try {
                    if (sshPort != null) {
                        cd.sshPort = Integer.parseInt(sshPort);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                try {
                    if (sshPort != null) {
                        cd.rmiRegistryPort = Integer.parseInt(rmiRegistryPort);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                try {
                    if (sshPort != null) {
                        cd.rmiServerPort = Integer.parseInt(rmiServerPort);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                cd.opts = "";
                cd.loc = home;
                continue;
            }
            cd.loc = String.format("%s/%s", instances, container.getId());
            CreateContainerMetadata metadata = container.getMetadata();
            StringBuilder jvmOpts = ChildContainerProvider.buildJvmOpts((CreateChildContainerOptions)((CreateChildContainerOptions)metadata.getCreateOptions()), (FabricService)this.fabricService);
            cd.opts = InstancesAction.extractZookeeperCredentials(jvmOpts.toString(), new ArrayList<String>());
        }
        StringWriter sw = new StringWriter();
        sw.write(String.format("count = %d%n", containerData.size() + (rootData == null ? 0 : 1)));
        int count = 0;
        if (rootData != null) {
            sw.write(String.format("item.0.name = %s%n", rootData.name));
            sw.write(String.format("item.0.loc = %s%n", rootData.loc));
            sw.write(String.format("item.0.pid = %d%n", rootData.pid));
            sw.write(String.format("item.0.root = true%n", new Object[0]));
            if (rootData.sshPort != -1) {
                sw.write(String.format("ssh.port = %d%n", rootData.sshPort));
            }
            if (rootData.rmiRegistryPort != -1) {
                sw.write(String.format("rmi.registry.port = %d%n", rootData.rmiRegistryPort));
            }
            if (rootData.rmiServerPort != -1) {
                sw.write(String.format("rmi.server.port = %d%n", rootData.rmiServerPort));
            }
            sw.write(String.format("item.0.opts = %n", new Object[0]));
            ++count;
        }
        for (ContainerData cd : containerData.values()) {
            sw.write(String.format("item.%d.name = %s%n", count, cd.name));
            sw.write(String.format("item.%d.root = false%n", count));
            sw.write(String.format("item.%d.loc = %s%n", count, cd.loc));
            sw.write(String.format("item.%d.pid = %d%n", count, cd.pid));
            sw.write(String.format("item.%d.opts = %s%n", count, cd.opts));
            ++count;
        }
        if (this.originalFile) {
            if (instancesDir == null) {
                System.out.println("Can't write instance.properties that should be stored on remote container. Please copy the output to proper location at \"" + checked.getId() + "\" container.");
            } else {
                String response;
                File instancesFile = new File(instancesDir, "instance.properties");
                if (!this.force && "yes".equalsIgnoreCase(response = ShellUtils.readLine(this.session, "Overwrite " + instancesFile + "? (yes/no): ", false))) {
                    this.force = true;
                }
                if (this.force) {
                    if (instancesFile.exists()) {
                        instancesFile.renameTo(new File(instancesDir, "instance.properties-" + DF.format(new Date())));
                    }
                    try (BufferedWriter w = new BufferedWriter(new FileWriter(instancesFile));){
                        w.write(sw.toString());
                    }
                }
                return null;
            }
        }
        System.out.println("Resulting instance.properties file:");
        System.out.println(sw.toString());
        return null;
    }

    private JMXResult asResult(String id, String path, List<String> responses, Class<GitVersions> gitVersionsClass) throws Exception {
        ObjectMapper mapper = this.getObjectMapper();
        JMXResult result = null;
        for (String responsePath : responses) {
            byte[] bytes = (byte[])this.curator.getData().forPath(path + "/" + responsePath);
            String response = PublicStringSerializer.deserialize((byte[])bytes);
            result = (JMXResult)mapper.readValue(response, JMXResult.class);
            if (!result.getCorrelationId().equals(id) || !(result.getResponse() instanceof String)) continue;
            try {
                result.setResponse(mapper.readValue((String)result.getResponse(), LocationInformation.class));
            }
            catch (JsonMappingException | IllegalArgumentException throwable) {}
        }
        mapper.getTypeFactory().clearCache();
        return result;
    }

    static String extractZookeeperCredentials(String javaOpts, List<String> zookeeperCredentials) {
        zookeeperCredentials.clear();
        javaOpts = InstancesAction.extract(javaOpts, "zookeeper.url", zookeeperCredentials);
        javaOpts = InstancesAction.extract(javaOpts, "zookeeper.password.encode", zookeeperCredentials);
        javaOpts = InstancesAction.extract(javaOpts, "zookeeper.password", zookeeperCredentials);
        return javaOpts;
    }

    private static String extract(String javaOpts, String property, List<String> zookeeperCredentials) {
        if (javaOpts != null && javaOpts.contains(property)) {
            StringBuilder sb = new StringBuilder();
            int id = javaOpts.indexOf("-D" + property);
            if (id > 0) {
                int state = 0;
                char delim = '\u0000';
                int pbegin = id;
                int pend = -1;
                int vbegin = -1;
                int vend = -1;
                block5: for (int from = id + new StringBuilder().append("-D").append(property).toString().length(); state < 3 && from < javaOpts.length(); ++from) {
                    char c = javaOpts.charAt(from);
                    switch (state) {
                        case 0: {
                            if (c == ' ' || c == '\t' || c != '=') continue block5;
                            state = 1;
                            continue block5;
                        }
                        case 1: {
                            if (c == ' ' || c == '\t') continue block5;
                            vbegin = from;
                            if (c == '\'' || c == '\"') {
                                delim = c;
                                ++vbegin;
                            }
                            state = 2;
                            continue block5;
                        }
                        case 2: {
                            if (delim != '\u0000' && c == delim && javaOpts.charAt(from - 1) != '\\') {
                                pend = from + 1;
                                vend = from;
                                state = 3;
                                continue block5;
                            }
                            if (delim != '\u0000' || c != ' ') continue block5;
                            pend = from;
                            vend = from;
                            state = 3;
                        }
                    }
                }
                if (pend == -1) {
                    pend = javaOpts.length();
                    vend = javaOpts.length();
                }
                if (pend > pbegin) {
                    String a = javaOpts.substring(0, pbegin);
                    String b = javaOpts.substring(pend);
                    String value = javaOpts.substring(vbegin, vend);
                    zookeeperCredentials.add(value);
                    javaOpts = a.trim() + " " + b.trim();
                }
            }
        }
        return javaOpts;
    }

    private class ContainerData {
        String name;
        String opts;
        boolean root;
        public String loc;
        int sshPort = -1;
        int rmiRegistryPort = -1;
        int rmiServerPort = -1;
        public Long pid;

        private ContainerData() {
        }
    }
}

