/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.commands;

import io.fabric8.api.FabricService;
import io.fabric8.api.RuntimeProperties;
import io.fabric8.api.scr.ValidatingReference;
import io.fabric8.boot.commands.service.JoinAvailable;
import io.fabric8.boot.commands.support.AbstractCommandComponent;
import io.fabric8.boot.commands.support.ContainerCompleter;
import io.fabric8.commands.InstancesAction;
import org.apache.curator.framework.CuratorFramework;
import org.apache.felix.gogo.commands.Action;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.basic.AbstractCommand;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.felix.service.command.Function;
import org.apache.karaf.shell.console.Completer;
import org.osgi.framework.BundleContext;

@Command(name="instances", scope="fabric", description="Creates a new fabric ensemble (ZooKeeper ensemble) and imports fabric profiles")
@Component(immediate=true)
@Service(value={Function.class, AbstractCommand.class, JoinAvailable.class})
@Properties(value={@Property(name="osgi.command.scope", value={"fabric"}), @Property(name="osgi.command.function", value={"instances"})})
public class Instances
extends AbstractCommandComponent
implements JoinAvailable {
    public static final String SCOPE_VALUE = "fabric";
    public static final String FUNCTION_VALUE = "instances";
    public static final String DESCRIPTION = "Allows to recreate instance.properties configuration from Zookeeper registry";
    @Reference(referenceInterface=RuntimeProperties.class, bind="bindRuntimeProperties", unbind="unbindRuntimeProperties")
    private final ValidatingReference<RuntimeProperties> runtimeProperties = new ValidatingReference();
    @Reference(referenceInterface=FabricService.class)
    private final ValidatingReference<FabricService> fabricService = new ValidatingReference();
    @Reference(referenceInterface=CuratorFramework.class)
    private final ValidatingReference<CuratorFramework> curator = new ValidatingReference();
    @Reference(referenceInterface=ContainerCompleter.class, bind="bindContainerCompleter", unbind="unbindContainerCompleter")
    private ContainerCompleter containerCompleter;

    @Activate
    void activate(BundleContext bundleContext) {
        this.activateComponent();
    }

    @Deactivate
    void deactivate() {
        this.deactivateComponent();
    }

    public Action createNewAction() {
        this.assertValid();
        return new InstancesAction((RuntimeProperties)this.runtimeProperties.get(), (FabricService)this.fabricService.get(), (CuratorFramework)this.curator.get());
    }

    void bindRuntimeProperties(RuntimeProperties service) {
        this.runtimeProperties.bind((Object)service);
    }

    void unbindRuntimeProperties(RuntimeProperties service) {
        this.runtimeProperties.unbind((Object)service);
    }

    void bindFabricService(FabricService fabricService) {
        this.fabricService.bind((Object)fabricService);
    }

    void unbindFabricService(FabricService fabricService) {
        this.fabricService.unbind((Object)fabricService);
    }

    void bindCurator(CuratorFramework curator) {
        this.curator.bind((Object)curator);
    }

    void unbindCurator(CuratorFramework curator) {
        this.curator.unbind((Object)curator);
    }

    void bindContainerCompleter(ContainerCompleter completer) {
        this.bindOptionalCompleter("--container", (Completer)completer);
    }

    void unbindContainerCompleter(ContainerCompleter completer) {
        this.unbindOptionalCompleter("--container");
    }
}

