/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.service.jclouds.commands;

import io.fabric8.api.CreateContainerMetadata;
import io.fabric8.api.CreateContainerOptions;
import io.fabric8.api.CreationStateListener;
import io.fabric8.api.FabricService;
import io.fabric8.api.ZooKeeperClusterService;
import io.fabric8.boot.commands.support.AbstractContainerCreateAction;
import io.fabric8.internal.PrintStreamCreationStateListener;
import io.fabric8.service.jclouds.CreateJCloudsContainerMetadata;
import io.fabric8.service.jclouds.CreateJCloudsContainerOptions;
import io.fabric8.service.jclouds.JCloudsInstanceType;
import io.fabric8.service.jclouds.internal.CloudUtils;
import io.fabric8.utils.FabricValidations;
import io.fabric8.utils.shell.ShellUtils;
import java.net.URI;
import java.util.List;
import java.util.Set;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;

@Command(name="container-create-cloud", scope="fabric", description="Creates one or more new containers on the cloud")
public class ContainerCreateCloud
extends AbstractContainerCreateAction {
    static final String DISPLAY_FORMAT = "%22s %-30s %-30s %-30s ";
    static final String[] OUTPUT_HEADERS = new String[]{"[id]", "[container]", "[public addresses]", "[status]"};
    static final String ENSEMBLE_SERVER_DISPLAY_FORMAT = "%22s %-30s %-16s %-30s %-30s ";
    static final String[] ENSEMBLE_SERVER_OUTPUT_HEADERS = new String[]{"[id]", "[container]", "[registry password]", "[public addresses]", "[status]"};
    @Option(name="--path", description="Path on the remote filesystem where the container is to be installed.")
    private String path;
    @Option(name="--env", required=false, multiValued=true, description="Adds an environmental variable. Can be used multiple times")
    private List<String> environmentalVariables;
    @Option(name="--name", required=true, description="The context name. Used to distinct between multiple services of the same provider/api.")
    protected String contextName;
    @Option(name="--provider", required=false, description="The cloud provider name")
    private String providerName;
    @Option(name="--api", required=false, description="The cloud api name")
    private String apiName;
    @Option(name="--os-family", multiValued=false, required=false, description="OS Family")
    private String osFamily = "ubuntu";
    @Option(name="--os-version", multiValued=false, required=false, description="OS Version")
    private String osVersion;
    @Option(name="--identity", required=false, description="The identity used to access the cloud provider")
    private String identity;
    @Option(name="--credential", required=false, description="The credential used The identity used to access the cloud provider")
    private String credential;
    @Option(name="--hardwareId", required=false, description="The kind of hardware to use")
    private String hardwareId;
    @Option(name="--instanceType", required=false, description="The kind of instance required")
    private JCloudsInstanceType instanceType;
    @Option(name="--imageId", required=false, description="The image ID to use for the new node(s)")
    private String imageId;
    @Option(name="--locationId", required=false, description="The location to use to create the new node(s)")
    private String locationId;
    @Option(name="--user", required=false, description="The user account to use on the new node(s)")
    private String user;
    @Option(name="--password", required=false, description="The user password to use on the new node(s)")
    private String password;
    @Option(name="--no-admin-access", required=false, description="Disables admin access as it might no be feasible on all images.")
    private boolean disableAdminAccess;
    @Option(name="--public-key-file", required=false, description="Path to the public key file to use for authenticating to the container")
    private String publicKeyFile;
    @Option(name="--owner", description="Optional owner of images; only really used for EC2 and deprecated going forward")
    private String owner;
    @Option(name="--add-option", required=false, multiValued=true, description="Node specific properties. These options are provider specific. Example: --option withSubnetId=someAwsSubnetId.")
    private String[] options;
    @Option(name="--group", description="The group tag to use on the new node(s)")
    private String group = "fabric";
    @Option(name="--proxy-uri", description="The Maven proxy URL to use")
    private URI proxyUri;
    @Option(name="--min-port", multiValued=false, description="The minimum port of the allowed port range")
    private int minimumPort = 0;
    @Option(name="--max-port", multiValued=false, description="The maximum port of the allowed port range")
    private int maximumPort = 65535;
    @Option(name="--new-user", multiValued=false, description="The username of a new user. The option refers to karaf user (ssh, http, jmx).")
    private String newUser = "admin";
    @Option(name="--new-user-password", multiValued=false, description="The password of the new user. The option refers to karaf user (ssh, http, jmx).")
    private String newUserPassword;
    @Option(name="--new-user-role", multiValued=false, description="The role of the new user. The option refers to karaf user (ssh, http, jmx).")
    private String newUserRole = "admin";
    @Option(name="--disable-distribution-upload", multiValued=false, description="Flag to disable uploading the distribution. When used distribution will be downloaded via maven")
    private Boolean distributionUploadDisable = false;
    @Argument(index=0, required=true, description="The name of the container to be created. When creating multiple containers it serves as a prefix")
    protected String name;
    @Argument(index=1, required=false, description="The number of containers that should be created")
    protected int number = 0;

    public ContainerCreateCloud(FabricService fabricService, ZooKeeperClusterService clusterService) {
        super(fabricService, clusterService);
    }

    protected Object doExecute() throws Exception {
        this.preCreateContainer(this.name);
        FabricValidations.validateProfileNames(this.profiles);
        if (this.isEnsembleServer.booleanValue() && this.newUserPassword == null) {
            this.newUserPassword = this.zookeeperPassword != null ? this.zookeeperPassword : this.fabricService.getZookeeperPassword();
        }
        CreateJCloudsContainerOptions.Builder builder = ((CreateJCloudsContainerOptions.Builder)((CreateJCloudsContainerOptions.Builder)((CreateJCloudsContainerOptions.Builder)((CreateJCloudsContainerOptions.Builder)((CreateJCloudsContainerOptions.Builder)((CreateJCloudsContainerOptions.Builder)((CreateJCloudsContainerOptions.Builder)((CreateJCloudsContainerOptions.Builder)((CreateJCloudsContainerOptions.Builder)((CreateJCloudsContainerOptions.Builder)((CreateJCloudsContainerOptions.Builder)((CreateJCloudsContainerOptions.Builder)((CreateJCloudsContainerOptions.Builder)((CreateJCloudsContainerOptions.Builder)((CreateJCloudsContainerOptions.Builder)CreateJCloudsContainerOptions.builder().name(this.name)).bindAddress(this.bindAddress)).resolver(this.resolver)).manualIp(this.manualIp)).ensembleServer(this.isEnsembleServer)).credential(this.credential).group(this.group).hardwareId(this.hardwareId).identity(this.identity).osFamily(this.osFamily).osVersion(this.osVersion).imageId(this.imageId).instanceType(this.instanceType).locationId(this.locationId).number(this.number)).nodeOptions(CloudUtils.parseProviderOptions(this.options)).owner(this.owner).adminAccess(!this.disableAdminAccess)).publicKeyFile(this.publicKeyFile).contextName(this.contextName).providerName(this.providerName).apiName(this.apiName).user(this.user).password(this.password).proxyUri(this.proxyUri != null ? this.proxyUri : this.fabricService.getMavenRepoURI())).zookeeperUrl(this.fabricService.getZookeeperUrl())).zookeeperPassword(this.isEnsembleServer != false && this.zookeeperPassword != null ? this.zookeeperPassword : this.fabricService.getZookeeperPassword())).jvmOpts(this.jvmOpts)).environmentalVariable(this.environmentalVariables).version(this.version)).withUser(this.newUser, this.newUserPassword, this.newUserRole)).profiles(this.getProfileNames())).dataStoreProperties(this.getDataStoreProperties())).uploadDistribution(this.distributionUploadDisable == false);
        if (this.path != null && !this.path.isEmpty()) {
            builder.path(this.path);
        }
        CreateContainerMetadata[] metadatas = this.fabricService.createContainers((CreateContainerOptions)builder.build(), (CreationStateListener)new PrintStreamCreationStateListener(System.out));
        if (this.isEnsembleServer.booleanValue() && metadatas != null && metadatas.length > 0 && metadatas[0].isSuccess()) {
            ShellUtils.storeZookeeperPassword(this.session, metadatas[0].getCreateOptions().getZookeeperPassword());
        }
        this.displayContainers(metadatas);
        return null;
    }

    @Override
    protected void displayContainers(CreateContainerMetadata[] metadatas) {
        if (this.isEnsembleServer.booleanValue()) {
            System.out.println(String.format(ENSEMBLE_SERVER_DISPLAY_FORMAT, ENSEMBLE_SERVER_OUTPUT_HEADERS));
        } else {
            System.out.println(String.format(DISPLAY_FORMAT, OUTPUT_HEADERS));
        }
        if (metadatas != null && metadatas.length > 0) {
            for (CreateContainerMetadata ccm : metadatas) {
                String status = "success";
                if (ccm.getFailure() != null) {
                    status = ccm.getFailure().getMessage();
                }
                String containerName = ccm.getContainerName() != null ? ccm.getContainerName() : "";
                String nodeId = "";
                Set<String> publicAddresses = null;
                if (ccm instanceof CreateJCloudsContainerMetadata) {
                    CreateJCloudsContainerMetadata metadata = (CreateJCloudsContainerMetadata)ccm;
                    nodeId = metadata.getNodeId() != null ? metadata.getNodeId() : "";
                    publicAddresses = metadata.getPublicAddresses();
                }
                if (this.isEnsembleServer.booleanValue()) {
                    System.out.println(String.format(ENSEMBLE_SERVER_DISPLAY_FORMAT, nodeId, containerName, ccm.getCreateOptions().getZookeeperPassword(), publicAddresses, status));
                    continue;
                }
                System.out.println(String.format(DISPLAY_FORMAT, nodeId, containerName, publicAddresses, status));
            }
        }
    }

    @Override
    protected void preCreateContainer(String name) {
        super.preCreateContainer(name);
        if (this.number < 0 || this.number > 999) {
            throw new IllegalArgumentException("The number of containers must be between 1 and 999.");
        }
        if (this.isEnsembleServer.booleanValue() && this.number > 1) {
            throw new IllegalArgumentException("Can not create a new ZooKeeper ensemble on multiple containers.  Create the containers and then use the fabric:create command instead.");
        }
    }
}

