/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.service.jclouds.firewall;

import io.fabric8.service.jclouds.firewall.ApiFirewallSupport;
import io.fabric8.service.jclouds.firewall.Rule;
import java.io.IOException;
import java.util.Set;
import org.jclouds.compute.ComputeService;

public class FirewallManager {
    private final ComputeService computeService;
    private final ApiFirewallSupport firewallSupport;

    public FirewallManager(ComputeService computeService, ApiFirewallSupport firewallSupport) {
        this.computeService = computeService;
        this.firewallSupport = firewallSupport;
    }

    public void addRules(Rule ... rules) throws IOException {
        for (Rule rule : rules) {
            this.addRule(rule);
        }
    }

    public void addRules(Set<Rule> rules) throws IOException {
        for (Rule rule : rules) {
            this.addRule(rule);
        }
    }

    public void addRule(Rule rule) throws IOException {
        switch (rule.getType()) {
            case FLUSH: {
                this.firewallSupport.flush(this.computeService, rule.getDestination());
                break;
            }
            case AUTHORIZE: {
                this.firewallSupport.authorize(this.computeService, rule.getDestination(), rule.getSource(), rule.getPorts());
                break;
            }
            case REVOKE: {
                this.firewallSupport.revoke(this.computeService, rule.getDestination(), rule.getSource(), rule.getPorts());
                break;
            }
        }
    }

    public boolean isSupported() {
        return this.firewallSupport != null;
    }
}

