/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.service.jclouds.firewall.internal;

import io.fabric8.api.jcip.GuardedBy;
import io.fabric8.api.jcip.ThreadSafe;
import io.fabric8.api.scr.AbstractComponent;
import io.fabric8.api.visibility.VisibleForExternal;
import io.fabric8.service.jclouds.firewall.ApiFirewallSupport;
import io.fabric8.service.jclouds.firewall.FirewallManager;
import io.fabric8.service.jclouds.firewall.FirewallManagerFactory;
import io.fabric8.service.jclouds.firewall.FirewallNotSupportedOnProviderException;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.Service;
import org.jclouds.compute.ComputeService;

@ThreadSafe
@Component(name="io.fabric8.jclouds.firewall.manager.factory", label="Fabric8 Firewall Manager", immediate=true, metatype=false)
@Service(value={FirewallManagerFactory.class})
public final class FirewallManagerFactoryImpl
extends AbstractComponent
implements FirewallManagerFactory {
    @GuardedBy(value="CopyOnWriteArraySet")
    @Reference(referenceInterface=ApiFirewallSupport.class, bind="bindFirewallSupport", unbind="unbindFirewallSupport", cardinality=ReferenceCardinality.OPTIONAL_MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    private final Set<ApiFirewallSupport> firewallSupport = new CopyOnWriteArraySet<ApiFirewallSupport>();

    @Activate
    void activate() {
        this.activateComponent();
    }

    @Deactivate
    void deactivate() {
        this.deactivateComponent();
    }

    @Override
    public FirewallManager getFirewallManager(ComputeService computeService) throws FirewallNotSupportedOnProviderException {
        this.assertValid();
        ApiFirewallSupport firewallSupport = this.findApiFirewallSupport(computeService);
        if (firewallSupport == null) {
            throw new FirewallNotSupportedOnProviderException("Service is currently not supported for firewall operations");
        }
        FirewallManager firewallManager = new FirewallManager(computeService, firewallSupport);
        return firewallManager;
    }

    private ApiFirewallSupport findApiFirewallSupport(ComputeService computeService) {
        for (ApiFirewallSupport s : this.firewallSupport) {
            if (!s.supports(computeService)) continue;
            return s;
        }
        return null;
    }

    @VisibleForExternal
    public void bindFirewallSupport(ApiFirewallSupport providerSupport) {
        this.firewallSupport.add(providerSupport);
    }

    @VisibleForExternal
    public void unbindFirewallSupport(ApiFirewallSupport providerSupport) {
        this.firewallSupport.remove(providerSupport);
    }
}

