/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.service.jclouds.firewall.internal;

import io.fabric8.api.jcip.ThreadSafe;
import io.fabric8.api.scr.AbstractComponent;
import io.fabric8.service.jclouds.firewall.ApiFirewallSupport;
import java.util.Set;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Service;
import org.jclouds.aws.util.AWSUtils;
import org.jclouds.compute.ComputeService;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.ec2.EC2Api;
import org.jclouds.ec2.compute.EC2ComputeService;
import org.jclouds.ec2.domain.SecurityGroup;
import org.jclouds.ec2.features.SecurityGroupApi;
import org.jclouds.net.domain.IpPermission;
import org.jclouds.net.domain.IpProtocol;

@ThreadSafe
@Component(name="io.fabric8.jclouds.firewall.ec2", label="Fabric8 Firewall Support for EC2", immediate=true, metatype=false)
@Service(value={ApiFirewallSupport.class})
public final class Ec2FirewallSupport
extends AbstractComponent
implements ApiFirewallSupport {
    private final ApiFirewallSupport delegate = new Ec2SupportDelegate();

    @Activate
    void activate() {
        this.activateComponent();
    }

    @Deactivate
    void deactivate() {
        this.deactivateComponent();
    }

    @Override
    public void authorize(ComputeService service, NodeMetadata node, String source, int ... ports) {
        this.assertValid();
        try {
            this.delegate.authorize(service, node, source, ports);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
    }

    @Override
    public void revoke(ComputeService service, NodeMetadata node, String source, int ... ports) {
        this.assertValid();
        try {
            this.delegate.revoke(service, node, source, ports);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
    }

    @Override
    public void flush(ComputeService service, NodeMetadata node) {
        this.assertValid();
        this.delegate.flush(service, node);
    }

    @Override
    public boolean supports(ComputeService computeService) {
        this.assertValid();
        try {
            return this.delegate.supports(computeService);
        }
        catch (NoClassDefFoundError ex) {
            return false;
        }
    }

    private static final class Ec2SupportDelegate
    implements ApiFirewallSupport {
        private Ec2SupportDelegate() {
        }

        @Override
        public void authorize(ComputeService service, NodeMetadata node, String source, int ... ports) {
            String region = AWSUtils.parseHandle(node.getId())[0];
            EC2Api ec2Api = (EC2Api)service.getContext().unwrapApi(EC2Api.class);
            String groupName = "jclouds#" + node.getGroup();
            for (int port : ports) {
                try {
                    ((SecurityGroupApi)ec2Api.getSecurityGroupApi().get()).authorizeSecurityGroupIngressInRegion(region, groupName, IpProtocol.TCP, port, port, source);
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
            }
        }

        @Override
        public void revoke(ComputeService service, NodeMetadata node, String source, int ... ports) {
            String region = AWSUtils.parseHandle(node.getId())[0];
            EC2Api ec2Api = (EC2Api)service.getContext().unwrapApi(EC2Api.class);
            String groupName = "jclouds#" + node.getGroup() + "#" + region;
            for (int port : ports) {
                try {
                    ((SecurityGroupApi)ec2Api.getSecurityGroupApi().get()).revokeSecurityGroupIngressInRegion(region, groupName, IpProtocol.TCP, port, port, source);
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
            }
        }

        @Override
        public void flush(ComputeService service, NodeMetadata node) {
            String region = AWSUtils.parseHandle(node.getId())[0];
            EC2Api ec2Api = (EC2Api)service.getContext().unwrapApi(EC2Api.class);
            String groupName = "jclouds#" + node.getGroup() + "#" + region;
            Set matchedSecurityGroups = ((SecurityGroupApi)ec2Api.getSecurityGroupApi().get()).describeSecurityGroupsInRegion(region, new String[]{groupName});
            for (SecurityGroup securityGroup : matchedSecurityGroups) {
                for (IpPermission ipPermission : securityGroup) {
                    for (String cdr : ipPermission.getCidrBlocks()) {
                        ((SecurityGroupApi)ec2Api.getSecurityGroupApi().get()).revokeSecurityGroupIngressInRegion(region, groupName, IpProtocol.TCP, ipPermission.getFromPort(), ipPermission.getToPort(), cdr);
                    }
                }
            }
            this.authorize(service, node, "0.0.0.0/0", 22);
        }

        @Override
        public boolean supports(ComputeService computeService) {
            return EC2ComputeService.class.isInstance(computeService);
        }
    }
}

