/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.service.jclouds.firewall.internal;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import io.fabric8.api.jcip.ThreadSafe;
import io.fabric8.api.scr.AbstractComponent;
import io.fabric8.service.jclouds.firewall.ApiFirewallSupport;
import java.util.ArrayList;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Service;
import org.jclouds.aws.util.AWSUtils;
import org.jclouds.compute.ComputeService;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.net.domain.IpProtocol;
import org.jclouds.openstack.nova.v2_0.NovaApi;
import org.jclouds.openstack.nova.v2_0.domain.Ingress;
import org.jclouds.openstack.nova.v2_0.domain.SecurityGroup;
import org.jclouds.openstack.nova.v2_0.domain.SecurityGroupRule;
import org.jclouds.openstack.nova.v2_0.extensions.SecurityGroupApi;

@ThreadSafe
@Component(name="io.fabric8.jclouds.firewall.nova", label="Fabric8 Firewall Support for Openstack Nova", immediate=true, metatype=false)
@Service(value={ApiFirewallSupport.class})
public final class NovaFirewallSupport
extends AbstractComponent
implements ApiFirewallSupport {
    private final ApiFirewallSupport delegate = new Ec2SupportDelegate();

    @Activate
    void activate() {
        this.activateComponent();
    }

    @Deactivate
    void deactivate() {
        this.deactivateComponent();
    }

    @Override
    public void authorize(ComputeService service, NodeMetadata node, String source, int ... ports) {
        this.assertValid();
        try {
            this.delegate.authorize(service, node, source, ports);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
    }

    @Override
    public void revoke(ComputeService service, NodeMetadata node, String source, int ... ports) {
        this.assertValid();
        try {
            this.delegate.revoke(service, node, source, ports);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
    }

    @Override
    public void flush(ComputeService service, NodeMetadata node) {
        this.assertValid();
        this.delegate.flush(service, node);
    }

    @Override
    public boolean supports(ComputeService computeService) {
        this.assertValid();
        try {
            return this.delegate.supports(computeService);
        }
        catch (NoClassDefFoundError ex) {
            return false;
        }
    }

    private static final class Ec2SupportDelegate
    implements ApiFirewallSupport {
        private Ec2SupportDelegate() {
        }

        @Override
        public void authorize(ComputeService service, NodeMetadata node, String source, int ... ports) {
            String region = AWSUtils.parseHandle(node.getId())[0];
            Optional<? extends SecurityGroupApi> securityGroupApi = Ec2SupportDelegate.getSecurityGroup(service, region);
            if (securityGroupApi.isPresent()) {
                String groupName = "jclouds-" + node.getGroup();
                Optional<? extends SecurityGroup> securityGroup = Ec2SupportDelegate.getSecurityGroupForGroup((SecurityGroupApi)securityGroupApi.get(), groupName);
                if (securityGroup.isPresent()) {
                    for (int port : ports) {
                        try {
                            ((SecurityGroupApi)securityGroupApi.get()).createRuleAllowingCidrBlock(((SecurityGroup)securityGroup.get()).getId(), Ingress.builder().ipProtocol(IpProtocol.TCP).fromPort(port).toPort(port).build(), source);
                        }
                        catch (IllegalStateException illegalStateException) {
                            // empty catch block
                        }
                    }
                }
            }
        }

        @Override
        public void revoke(ComputeService service, NodeMetadata node, String source, int ... ports) {
            String region = AWSUtils.parseHandle(node.getId())[0];
            Optional<? extends SecurityGroupApi> securityGroupApi = Ec2SupportDelegate.getSecurityGroup(service, region);
            if (securityGroupApi.isPresent()) {
                String groupName = "jclouds-" + node.getGroup();
                Optional<? extends SecurityGroup> securityGroup = Ec2SupportDelegate.getSecurityGroupForGroup((SecurityGroupApi)securityGroupApi.get(), groupName);
                if (securityGroup.isPresent()) {
                    try {
                        for (SecurityGroupRule rule : Ec2SupportDelegate.getAllRuleMatching((SecurityGroup)securityGroup.get(), source, ports)) {
                            ((SecurityGroupApi)securityGroupApi.get()).deleteRule(rule.getId());
                        }
                    }
                    catch (IllegalStateException illegalStateException) {
                        // empty catch block
                    }
                }
            }
        }

        @Override
        public void flush(ComputeService service, NodeMetadata node) {
            String region = AWSUtils.parseHandle(node.getId())[0];
            Optional<? extends SecurityGroupApi> securityGroupApi = Ec2SupportDelegate.getSecurityGroup(service, region);
            if (securityGroupApi.isPresent()) {
                String groupName = "jclouds-" + node.getGroup();
                Optional<? extends SecurityGroup> securityGroup = Ec2SupportDelegate.getSecurityGroupForGroup((SecurityGroupApi)securityGroupApi.get(), groupName);
                if (securityGroup.isPresent()) {
                    try {
                        for (SecurityGroupRule rule : ((SecurityGroup)securityGroup.get()).getRules()) {
                            ((SecurityGroupApi)securityGroupApi.get()).deleteRule(rule.getId());
                        }
                    }
                    catch (IllegalStateException illegalStateException) {
                        // empty catch block
                    }
                }
            }
            this.authorize(service, node, "0.0.0.0", 22);
        }

        @Override
        public boolean supports(ComputeService computeService) {
            try {
                computeService.getContext().unwrapApi(NovaApi.class);
                return true;
            }
            catch (IllegalArgumentException e) {
                return false;
            }
        }

        private static Optional<? extends SecurityGroupApi> getSecurityGroup(ComputeService computeService, String location) {
            return ((NovaApi)computeService.getContext().unwrapApi(NovaApi.class)).getSecurityGroupExtensionForZone(location);
        }

        private static Optional<? extends SecurityGroup> getSecurityGroupForGroup(SecurityGroupApi securityGroupApi, final String group) {
            return securityGroupApi.list().firstMatch((Predicate)new Predicate<SecurityGroup>(){

                public boolean apply(SecurityGroup secGrp) {
                    return secGrp.getName().equals(group);
                }
            });
        }

        private static Iterable<SecurityGroupRule> getAllRuleMatching(SecurityGroup securityGroup, final String source, final int ... ports) {
            return Iterables.filter((Iterable)securityGroup.getRules(), (Predicate)new Predicate<SecurityGroupRule>(){

                public boolean apply(@Nullable SecurityGroupRule input) {
                    if (!Ec2SupportDelegate.rangeFulfilled(input.getFromPort(), input.getToPort(), ports)) {
                        return false;
                    }
                    return input.getIpRange().equals(source);
                }
            });
        }

        private static boolean rangeFulfilled(int from, int to, int ... ports) {
            boolean matches = true;
            ArrayList<Integer> targetPorts = new ArrayList<Integer>();
            for (int port : ports) {
                targetPorts.add(port);
            }
            for (int port = from; port <= to; ++port) {
                matches &= targetPorts.contains(port);
            }
            return matches;
        }
    }
}

