/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.service.jclouds.functions;

import com.google.common.base.Optional;
import com.google.common.base.Strings;
import io.fabric8.service.jclouds.CreateJCloudsContainerOptions;
import io.fabric8.service.jclouds.functions.ToAdminAccess;
import java.lang.reflect.Field;
import java.util.Map;
import org.jclouds.compute.ComputeService;
import org.jclouds.compute.domain.OsFamily;
import org.jclouds.compute.domain.Template;
import org.jclouds.compute.domain.TemplateBuilder;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.scriptbuilder.domain.Statement;
import org.jclouds.scriptbuilder.statements.login.AdminAccess;

public class ToTemplate {
    public static Template apply(CreateJCloudsContainerOptions options) {
        ComputeService service = options.getComputeService();
        TemplateOptions templateOptions = service.templateOptions();
        TemplateBuilder builder = service.templateBuilder().any();
        ToTemplate.applyInstanceType(builder, options);
        ToTemplate.applyImageType(builder, options);
        ToTemplate.applyLocation(builder, options);
        ToTemplate.applyProviderSpecificOptions(templateOptions, options);
        Optional<AdminAccess> adminAccess = ToAdminAccess.apply(options);
        if (adminAccess.isPresent()) {
            templateOptions.runScript((Statement)adminAccess.get());
        }
        builder = builder.options(templateOptions);
        return builder.build();
    }

    private static void applyProviderSpecificOptions(TemplateOptions templateOptions, CreateJCloudsContainerOptions options) {
        if (options != null && templateOptions != null) {
            for (Map.Entry<String, String> entry : options.getNodeOptions().entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                try {
                    Field field = templateOptions.getClass().getDeclaredField(key);
                    if (field == null) continue;
                    field.setAccessible(true);
                    field.set(templateOptions, value);
                }
                catch (Exception exception) {}
            }
        }
    }

    private static void applyInstanceType(TemplateBuilder builder, CreateJCloudsContainerOptions options) {
        if (options.getInstanceType() == null && Strings.isNullOrEmpty((String)options.getHardwareId())) {
            builder.minRam(1024);
        } else if (!Strings.isNullOrEmpty((String)options.getHardwareId())) {
            builder.hardwareId(options.getHardwareId());
        } else if (options.getInstanceType() != null) {
            switch (options.getInstanceType()) {
                case Smallest: {
                    builder.smallest();
                    break;
                }
                case Biggest: {
                    builder.biggest();
                    break;
                }
                case Fastest: {
                    builder.fastest();
                    break;
                }
                default: {
                    builder.fastest();
                }
            }
        }
    }

    private static void applyImageType(TemplateBuilder builder, CreateJCloudsContainerOptions options) {
        if (!Strings.isNullOrEmpty((String)options.getImageId())) {
            builder.imageId(options.getImageId());
        } else if (!Strings.isNullOrEmpty((String)options.getOsFamily())) {
            builder.osFamily(OsFamily.fromValue((String)options.getOsFamily()));
            if (!Strings.isNullOrEmpty((String)options.getOsVersion())) {
                builder.osVersionMatches(options.getOsVersion());
            }
        } else {
            throw new IllegalArgumentException("Required Image id or Operation System and version predicates.");
        }
    }

    private static void applyLocation(TemplateBuilder builder, CreateJCloudsContainerOptions options) {
        if (!Strings.isNullOrEmpty((String)options.getLocationId())) {
            builder.locationId(options.getLocationId());
        }
    }
}

