/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.cxf.maven;

import io.fabric8.cxf.maven.AnnotationVisitor;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.DirectoryScanner;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.TextEdit;

public class AddSwaggerAnnotationMojo
extends AbstractMojo {
    private MavenProject project;
    private String[] includes = new String[]{"**/*.java"};
    private String[] excludes;

    public void execute() throws MojoExecutionException {
        this.scan(this.project.getCompileSourceRoots());
    }

    private void scan(List<String> roots) throws MojoExecutionException {
        for (String root : roots) {
            this.scan(new File(root));
        }
    }

    private void scan(File root) throws MojoExecutionException {
        if (!root.exists()) {
            return;
        }
        DirectoryScanner directoryScanner = new DirectoryScanner();
        directoryScanner.setIncludes(this.includes);
        directoryScanner.setExcludes(this.excludes);
        directoryScanner.setBasedir(root);
        directoryScanner.scan();
        for (String fileName : directoryScanner.getIncludedFiles()) {
            File file = new File(root, fileName);
            try {
                this.processJavaFile(file);
            }
            catch (Exception e) {
                throw new MojoExecutionException("io error while rewriting source file", e);
            }
        }
    }

    public void processJavaFile(File file) throws IOException, MalformedTreeException, BadLocationException, JavaModelException, IllegalArgumentException {
        String source = FileUtils.readFileToString((File)file);
        Document document = new Document(source);
        ASTParser parser = ASTParser.newParser((int)3);
        parser.setResolveBindings(true);
        parser.setSource(document.get().toCharArray());
        CompilationUnit unit = (CompilationUnit)parser.createAST(null);
        AnnotationVisitor visitor = new AnnotationVisitor();
        unit.accept((ASTVisitor)visitor);
        if (visitor.hasPath() && !visitor.hasApi()) {
            this.addSwaggerApiAnnotation(unit, visitor, file, document);
        }
    }

    private void addSwaggerApiAnnotation(CompilationUnit unit, AnnotationVisitor visitor, File file, Document document) throws JavaModelException, IllegalArgumentException, MalformedTreeException, BadLocationException, IOException {
        AST ast = unit.getAST();
        ASTRewrite rewriter = ASTRewrite.create((AST)ast);
        ListRewrite listRewrite = rewriter.getListRewrite((ASTNode)unit, CompilationUnit.TYPES_PROPERTY);
        NormalAnnotation normalAnnotation = rewriter.getAST().newNormalAnnotation();
        Name name = ast.newName("com.wordnik.swagger.annotations.Api");
        normalAnnotation.setTypeName(name);
        MemberValuePair memberValuePair = ast.newMemberValuePair();
        memberValuePair.setName(ast.newSimpleName("value"));
        StringLiteral stringLiteral = ast.newStringLiteral();
        String rootPath = visitor.getRootPath();
        rootPath = rootPath.substring(1, rootPath.length() - 1);
        if (rootPath.endsWith("/")) {
            rootPath = rootPath.substring(0, rootPath.length() - 1);
        }
        stringLiteral.setLiteralValue(rootPath);
        memberValuePair.setValue((Expression)stringLiteral);
        normalAnnotation.values().add(memberValuePair);
        memberValuePair = ast.newMemberValuePair();
        memberValuePair.setName(ast.newSimpleName("description"));
        stringLiteral = ast.newStringLiteral();
        stringLiteral.setLiteralValue("Operations about " + visitor.getRestServiceClass());
        memberValuePair.setValue((Expression)stringLiteral);
        normalAnnotation.values().add(memberValuePair);
        listRewrite.insertAt((ASTNode)normalAnnotation, 0, null);
        for (MethodDeclaration method : visitor.getRestMethod()) {
            listRewrite = rewriter.getListRewrite((ASTNode)method, MethodDeclaration.MODIFIERS2_PROPERTY);
            normalAnnotation = rewriter.getAST().newNormalAnnotation();
            name = ast.newName("com.wordnik.swagger.annotations.ApiOperation");
            normalAnnotation.setTypeName(name);
            memberValuePair = ast.newMemberValuePair();
            memberValuePair.setName(ast.newSimpleName("value"));
            stringLiteral = ast.newStringLiteral();
            stringLiteral.setLiteralValue(method.getName().toString());
            memberValuePair.setValue((Expression)stringLiteral);
            normalAnnotation.values().add(memberValuePair);
            Javadoc doc = method.getJavadoc();
            String comment = null;
            if (doc != null) {
                comment = method.getJavadoc().toString();
            }
            if (comment != null && comment.length() > 0) {
                memberValuePair = ast.newMemberValuePair();
                memberValuePair.setName(ast.newSimpleName("notes"));
                stringLiteral = ast.newStringLiteral();
                stringLiteral.setLiteralValue(comment);
                memberValuePair.setValue((Expression)stringLiteral);
                normalAnnotation.values().add(memberValuePair);
            }
            listRewrite.insertAt((ASTNode)normalAnnotation, 0, null);
            listRewrite = rewriter.getListRewrite((ASTNode)((List)method.getStructuralProperty((StructuralPropertyDescriptor)MethodDeclaration.PARAMETERS_PROPERTY)).get(0), SingleVariableDeclaration.MODIFIERS2_PROPERTY);
            normalAnnotation = rewriter.getAST().newNormalAnnotation();
            name = ast.newName("com.wordnik.swagger.annotations.ApiParam");
            normalAnnotation.setTypeName(name);
            ((VariableDeclaration)((List)method.getStructuralProperty((StructuralPropertyDescriptor)MethodDeclaration.PARAMETERS_PROPERTY)).get(0)).getName();
            memberValuePair = ast.newMemberValuePair();
            memberValuePair.setName(ast.newSimpleName("value"));
            stringLiteral = ast.newStringLiteral();
            stringLiteral.setLiteralValue(((VariableDeclaration)((List)method.getStructuralProperty((StructuralPropertyDescriptor)MethodDeclaration.PARAMETERS_PROPERTY)).get(0)).getName().toString());
            memberValuePair.setValue((Expression)stringLiteral);
            normalAnnotation.values().add(memberValuePair);
            listRewrite.insertAt((ASTNode)normalAnnotation, 0, null);
        }
        TextEdit edits = rewriter.rewriteAST((IDocument)document, null);
        edits.apply((IDocument)document);
        FileUtils.writeStringToFile((File)file, (String)document.get());
    }
}

