/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.jaxb.dynamic.profile;

import com.google.common.base.Throwables;
import io.fabric8.api.Container;
import io.fabric8.api.Containers;
import io.fabric8.api.DataStore;
import io.fabric8.api.FabricService;
import io.fabric8.api.Profiles;
import io.fabric8.jaxb.dynamic.CompileResults;
import io.fabric8.jaxb.dynamic.CompileResultsHandler;
import io.fabric8.jaxb.dynamic.DynamicCompiler;
import io.fabric8.jaxb.dynamic.DynamicXJC;
import io.hawt.introspect.Introspector;
import io.hawt.util.introspect.ClassLoaderProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.aries.util.AriesFrameworkUtil;
import org.apache.curator.framework.recipes.cache.PathChildrenCache;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.fusesource.common.util.Maps;
import org.fusesource.common.util.Strings;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(name="io.fabric8.profile.jaxb.compiler", label="Fabric8 Profile JAXB Compiler", policy=ConfigurationPolicy.OPTIONAL, immediate=true, metatype=true)
@Service(value={DynamicCompiler.class})
public class ProfileDynamicJaxbCompiler
implements DynamicCompiler {
    public static final String PROPERTY_SCHEMA_PATH = "schemaPath";
    private static final transient Logger LOG = LoggerFactory.getLogger(ProfileDynamicJaxbCompiler.class);
    private BundleContext bundleContext;
    @Reference(referenceInterface=FabricService.class)
    private FabricService fabricService;
    @Reference(referenceInterface=Introspector.class, cardinality=ReferenceCardinality.OPTIONAL_UNARY)
    private Introspector introspector;
    private String schemaPath;
    private Timer timer = new Timer();
    private AtomicBoolean startedFlag = new AtomicBoolean(false);
    private ExecutorService executorService = Executors.newFixedThreadPool(2);
    private final ConcurrentMap<String, PathChildrenCache> pathCacheMap = new ConcurrentHashMap<String, PathChildrenCache>();
    private long timerDelay = 1000L;
    private CompileResults compileResults;
    private CompileResultsHandler handler;
    private Runnable changeRunnable = new Runnable(){

        @Override
        public void run() {
            ProfileDynamicJaxbCompiler.this.asyncRecompile();
        }
    };
    private Introspector localIntrospector;

    @Activate
    void activate(BundleContext bundleContext, Map<String, String> configuration) {
        try {
            this.bundleContext = bundleContext;
            this.schemaPath = Maps.stringValue(configuration, (String)PROPERTY_SCHEMA_PATH, (String)"schemas");
            this.getDataStore().trackConfiguration(this.changeRunnable);
            if (this.introspector == null) {
                this.localIntrospector = new Introspector();
                this.localIntrospector.init();
                this.introspector = this.localIntrospector;
            }
            this.asyncRecompile();
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Deactivate
    void deactivate() throws Exception {
        this.getDataStore().untrackConfiguration(this.changeRunnable);
        this.executorService.shutdown();
        this.timer.cancel();
        if (this.localIntrospector != null) {
            this.localIntrospector.destroy();
        }
    }

    public void setHandler(CompileResultsHandler handler) throws Exception {
        this.handler = handler;
        if (handler != null && this.compileResults != null) {
            handler.onCompileResults(this.compileResults);
        }
    }

    public CompileResults getCompileResults() {
        return this.compileResults;
    }

    public FabricService getFabricService() {
        return this.fabricService;
    }

    public DataStore getDataStore() {
        return this.getFabricService().getDataStore();
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public String getSchemaPath() {
        return this.schemaPath;
    }

    public void setSchemaPath(String schemaPath) {
        this.schemaPath = schemaPath;
    }

    public Timer getTimer() {
        return this.timer;
    }

    public void setTimer(Timer timer) {
        this.timer = timer;
    }

    public long getTimerDelay() {
        return this.timerDelay;
    }

    public void setTimerDelay(long timerDelay) {
        this.timerDelay = timerDelay;
    }

    protected void asyncRecompile() {
        if (this.startedFlag.compareAndSet(false, true)) {
            this.timer.schedule((TimerTask)new RecompileTask(), this.timerDelay);
        }
    }

    protected void recompile() {
        LOG.debug("Looking for XSDs to recompile");
        TreeSet<String> urls = new TreeSet<String>();
        FabricService fabric = this.getFabricService();
        Container container = fabric.getCurrentContainer();
        String version = container.getVersion().getId();
        List profiles = Containers.overlayProfiles((Container)container);
        List profileIds = Profiles.profileIds((Iterable)profiles);
        Collection names = fabric.getDataStore().listFiles(version, (Iterable)profileIds, this.schemaPath);
        for (String name : names) {
            if (!name.endsWith(".xsd")) continue;
            String prefix = this.schemaPath;
            if (Strings.isNotBlank((String)prefix)) {
                prefix = prefix + "/";
            }
            urls.add("profile:" + prefix + name);
        }
        LOG.info("Recompiling XSDs at URLs: " + urls);
        this.startedFlag.set(false);
        ClassLoader classLoader = AriesFrameworkUtil.getClassLoader((Bundle)this.bundleContext.getBundle());
        if (classLoader == null) {
            classLoader = this.getClass().getClassLoader();
        }
        DynamicXJC xjc = new DynamicXJC(classLoader);
        xjc.setSchemaUrls(new ArrayList(urls));
        this.compileResults = xjc.compileSchemas();
        if (this.handler != null) {
            this.handler.onCompileResults(this.compileResults);
        }
        if (this.introspector != null) {
            this.introspector.setClassLoaderProvider("dynamic.jaxb", new ClassLoaderProvider(){

                public ClassLoader getClassLoader() {
                    return ProfileDynamicJaxbCompiler.this.compileResults.getClassLoader();
                }
            });
        }
    }

    protected void bindFabricService(FabricService fabricService) {
        this.fabricService = fabricService;
    }

    protected void unbindFabricService(FabricService fabricService) {
        if (this.fabricService == fabricService) {
            this.fabricService = null;
        }
    }

    protected void bindIntrospector(Introspector introspector) {
        this.introspector = introspector;
    }

    protected void unbindIntrospector(Introspector introspector) {
        if (this.introspector == introspector) {
            this.introspector = null;
        }
    }

    private class RecompileTask
    extends TimerTask {
        private RecompileTask() {
        }

        @Override
        public void run() {
            ProfileDynamicJaxbCompiler.this.recompile();
        }
    }
}

