/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.git.internal;

import io.fabric8.api.Profiles;
import io.fabric8.api.gravia.IllegalStateAssertion;
import io.fabric8.common.util.Strings;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.regex.Pattern;
import org.eclipse.jgit.api.CheckoutCommand;
import org.eclipse.jgit.api.CheckoutResult;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.NoHeadException;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.revwalk.RevCommit;
import org.gitective.core.CommitUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitHelpers {
    private static final Logger LOGGER = LoggerFactory.getLogger(GitHelpers.class);
    static final String CONFIGS = "fabric";
    static final String CONFIGS_PROFILES = "fabric" + File.separator + "profiles";
    static final String VERSION_ATTRIBUTES = "version.attributes";
    static final String REMOTE_ORIGIN = "origin";
    static final String MASTER_BRANCH = "master";
    static final String ROOT_TAG = "root";
    static final Pattern ENSEMBLE_PROFILE_PATTERN = Pattern.compile("fabric-ensemble-[0-9]+|fabric-ensemble-[0-9]+-[0-9]+");

    public static File getRootGitDirectory(Git git) {
        return git.getRepository().getDirectory().getParentFile();
    }

    public static File getProfilesDirectory(Git git) {
        return new File(GitHelpers.getRootGitDirectory(git), CONFIGS_PROFILES);
    }

    public static File getProfileDirectory(Git git, String profileId) {
        File profilesDirectory = GitHelpers.getProfilesDirectory(git);
        String path = GitHelpers.convertProfileIdToDirectory(profileId);
        return new File(profilesDirectory, path);
    }

    public static String convertProfileIdToDirectory(String profileId) {
        return Profiles.convertProfileIdToPath((String)profileId);
    }

    public static RevCommit getVersionLastCommit(Git git, String branch) {
        return GitHelpers.getLastCommit(git, branch, CONFIGS_PROFILES);
    }

    public static RevCommit getProfileLastCommit(Git git, String branch, String profilePath) {
        return GitHelpers.getLastCommit(git, branch, CONFIGS_PROFILES + "/" + profilePath);
    }

    private static RevCommit getLastCommit(Git git, String branch, String path) {
        RevCommit profileRef = null;
        try {
            Ref versionRef = git.getRepository().getRefDatabase().getRef(branch);
            if (versionRef != null) {
                String revision = versionRef.getObjectId().getName();
                profileRef = CommitUtils.getLastCommit(git.getRepository(), revision, path != null ? path : ".");
            }
        }
        catch (IOException ex) {
            // empty catch block
        }
        return profileRef;
    }

    public static boolean localBranchExists(Git git, String branch) throws GitAPIException {
        Object list = git.branchList().call();
        String fullName = "refs/heads/" + branch;
        boolean localBranchExists = false;
        Iterator i$ = list.iterator();
        while (i$.hasNext()) {
            Ref ref = (Ref)i$.next();
            String name = ref.getName();
            if (!GitHelpers.equals(name, fullName)) continue;
            localBranchExists = true;
            break;
        }
        return localBranchExists;
    }

    public static String currentBranch(Git git) {
        String branch = null;
        Exception gitException = null;
        try {
            branch = git.getRepository().getBranch();
        }
        catch (Exception ex) {
            gitException = ex;
        }
        if (branch == null || gitException != null) {
            throw new IllegalStateException("Failed to get the current branch", gitException);
        }
        return branch;
    }

    public static boolean hasGitHead(Git git) throws GitAPIException, IOException {
        boolean hasHead = true;
        try {
            git.log().all().call();
            hasHead = git.getRepository().getAllRefs().containsKey("HEAD");
        }
        catch (NoHeadException e) {
            hasHead = false;
        }
        return hasHead;
    }

    public static void createOrCheckoutBranch(Git git, String branch, String remote) throws GitAPIException {
        Ref ref = null;
        String current = GitHelpers.currentBranch(git);
        if (!GitHelpers.equals(current, branch) && !GitHelpers.localBranchExists(git, branch)) {
            ref = git.checkout().setName(branch).setForce(true).setCreateBranch(true).call();
            if (remote != null) {
                GitHelpers.configureBranch(git, branch, remote);
            }
        } else {
            ref = git.checkout().setName(branch).setForce(true).call();
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Checked out branch " + branch + " with results " + ref.getName());
        }
    }

    public static boolean checkoutBranch(Git git, String branch) throws GitAPIException {
        String current = GitHelpers.currentBranch(git);
        if (GitHelpers.equals(current, branch)) {
            return true;
        }
        if (GitHelpers.localBranchExists(git, branch)) {
            CheckoutCommand checkoutCommand = git.checkout().setName(branch).setForce(true);
            Ref ref = checkoutCommand.call();
            CheckoutResult result = checkoutCommand.getResult();
            LOGGER.debug("Checked out branch {} with results: {}", (Object)branch, (Object)result.getStatus());
            return true;
        }
        LOGGER.debug("Branch {} not found!", (Object)branch);
        return false;
    }

    public static boolean checkoutTag(Git git, String tagName) throws GitAPIException {
        git.checkout().setName(tagName).setForce(true).call();
        LOGGER.debug("Checked out tag: {}", (Object)tagName);
        return true;
    }

    public static boolean removeBranch(Git git, String branch) throws GitAPIException {
        IllegalStateAssertion.assertFalse((Boolean)MASTER_BRANCH.equals(branch), (String)"Cannot remove master branch");
        if (GitHelpers.localBranchExists(git, branch)) {
            String current = GitHelpers.currentBranch(git);
            if (GitHelpers.equals(current, branch)) {
                GitHelpers.checkoutBranch(git, MASTER_BRANCH);
            }
            Object list = git.branchDelete().setBranchNames(branch).setForce(true).call();
            LOGGER.debug("Deleted branch {} with results: {}", (Object)branch, list);
            return true;
        }
        LOGGER.debug("Branch {} not found!", (Object)branch);
        return true;
    }

    protected static void configureBranch(Git git, String branch, String remote) {
        StoredConfig config;
        if (Strings.isNotBlank((String)branch) && (Strings.isNullOrBlank((String)(config = git.getRepository().getConfig()).getString("branch", branch, "remote")) || Strings.isNullOrBlank((String)config.getString("branch", branch, "merge")))) {
            config.setString("branch", branch, "remote", remote);
            config.setString("branch", branch, "merge", "refs/heads/" + branch);
            try {
                config.save();
            }
            catch (IOException e) {
                LOGGER.error("Failed to configure the branch configuration to " + GitHelpers.getRootGitDirectory(git) + " with branch " + branch + " on remote repo: " + remote + ". " + e, (Throwable)e);
            }
        }
    }

    static boolean equals(Object a, Object b) {
        return a == b || a != null && a.equals(b);
    }

    public static String getProfileBranch(String versionId, String profileId) {
        if (profileId != null && ENSEMBLE_PROFILE_PATTERN.matcher(profileId).matches()) {
            return MASTER_BRANCH;
        }
        return versionId;
    }
}

