/*
 * Decompiled with CFR 0.152.
 */
package org.gitective.core.filter.commit;

import java.util.Collection;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.diff.Edit;
import org.eclipse.jgit.lib.AbbreviatedObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.revwalk.filter.RevFilter;
import org.gitective.core.BlobUtils;
import org.gitective.core.filter.commit.CommitDiffEditFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiffLineSizeFilter
extends CommitDiffEditFilter {
    private final int total;
    private int count;

    public DiffLineSizeFilter(boolean detectRenames, int diffTotal) {
        super(detectRenames);
        this.total = diffTotal;
    }

    public DiffLineSizeFilter(int diffTotal) {
        this(false, diffTotal);
    }

    public int getTotal() {
        return this.total;
    }

    @Override
    public boolean include(RevWalk walker, RevCommit commit, Collection<DiffEntry> diffs) {
        this.count = 0;
        ObjectReader reader = walker.getObjectReader();
        for (DiffEntry diff : diffs) {
            AbbreviatedObjectId oldId;
            if (!this.isFileDiff(diff) || (oldId = diff.getOldId()) == null) continue;
            this.include(commit, diff, BlobUtils.diff(reader, oldId.toObjectId(), diff.getNewId().toObjectId()));
            if (this.count < this.total) continue;
            break;
        }
        return this.count >= this.total ? true : this.include(false);
    }

    @Override
    protected boolean include(RevCommit commit, DiffEntry diff, Collection<Edit> edits) {
        for (Edit edit : edits) {
            this.include(commit, diff, edit);
            if (this.count < this.total) continue;
            break;
        }
        return true;
    }

    @Override
    protected boolean include(RevCommit commit, DiffEntry diff, Edit edit) {
        switch (edit.getType()) {
            case DELETE: {
                this.count += edit.getLengthA();
                break;
            }
            case INSERT: 
            case REPLACE: {
                this.count += edit.getLengthB();
            }
        }
        return true;
    }

    @Override
    public RevFilter clone() {
        return new DiffLineSizeFilter(this.detectRenames, this.total);
    }
}

