/*
 * Decompiled with CFR 0.152.
 */
package org.gitective.core.filter.commit;

import java.io.IOException;
import java.util.Date;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.gitective.core.Assert;
import org.gitective.core.filter.commit.CommitFilter;

public abstract class DateFilter
extends CommitFilter {
    protected final long time;

    public DateFilter(long time) {
        this.time = time;
    }

    public DateFilter(Date date) {
        if (date == null) {
            throw new IllegalArgumentException(Assert.formatNotNull("Date"));
        }
        this.time = date.getTime();
    }

    public boolean include(RevWalk walker, RevCommit commit) throws IOException {
        Date date = this.getDate(commit);
        if (date == null) {
            return this.include(false);
        }
        if (date.getTime() < this.time) {
            return this.include(false);
        }
        return true;
    }

    protected Date getWhen(PersonIdent person) {
        return person != null ? person.getWhen() : null;
    }

    protected abstract Date getDate(RevCommit var1);
}

