/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.git;

import io.fabric8.api.GitContext;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.PushResult;
import org.eclipse.jgit.transport.RemoteRefUpdate;

public interface PullPushPolicy {
    public PullPolicyResult doPull(GitContext var1, CredentialsProvider var2, boolean var3);

    public PullPolicyResult doPull(GitContext var1, CredentialsProvider var2, boolean var3, boolean var4);

    public PushPolicyResult doPush(GitContext var1, CredentialsProvider var2);

    public static class RemoteBranchChange
    extends BranchChange {
        private final RemoteRefUpdate remoteRefUpdate;

        public RemoteBranchChange(String branch, RemoteRefUpdate remoteRefUpdate) {
            super(branch);
            this.remoteRefUpdate = remoteRefUpdate;
        }

        @Override
        public RemoteBranchChange updated(ObjectId previousRef, ObjectId newRef, String how) {
            return (RemoteBranchChange)super.updated(previousRef, newRef, how);
        }

        public RemoteBranchChange rejected(ObjectId previousRef, ObjectId newRef, String why) {
            this.change = BranchChange.Change.REJECTED;
            this.ref1 = previousRef;
            this.ref2 = newRef;
            this.updateStatus = why;
            return this;
        }

        public RemoteRefUpdate getRemoteRefUpdate() {
            return this.remoteRefUpdate;
        }

        @Override
        public String toString() {
            if (this.change == BranchChange.Change.REJECTED) {
                return String.format("%s%s", this.branch, String.format(this.change.description, this.updateStatus, this.ref1 == null ? "?" : this.ref1.getName(), this.ref2 == null ? "?" : this.ref2.getName()));
            }
            return super.toString();
        }
    }

    public static class BranchChange {
        protected String branch;
        protected Change change = Change.UP_TO_DATE;
        protected ObjectId ref1;
        protected ObjectId ref2;
        protected String updateStatus;

        public BranchChange(String branch) {
            this.branch = branch;
        }

        public BranchChange created() {
            this.change = Change.CREATED;
            return this;
        }

        public BranchChange removed() {
            this.change = Change.REMOVED;
            return this;
        }

        public BranchChange updated(ObjectId previousRef, ObjectId newRef, String how) {
            this.change = Change.UPDATED;
            this.ref1 = previousRef;
            this.ref2 = newRef;
            this.updateStatus = how;
            return this;
        }

        public String toString() {
            if (this.change == Change.UPDATED) {
                return String.format("%s%s", this.branch, String.format(this.change.description, this.updateStatus, this.ref1 == null ? "?" : this.ref1.getName(), this.ref2 == null ? "?" : this.ref2.getName()));
            }
            return String.format("%s%s", this.branch, this.change.description);
        }

        static enum Change {
            CREATED("(new branch)"),
            REMOVED("(deleted)"),
            UPDATED("(updated by %s: %s..%s)"),
            REJECTED("(rejected due to %s: %s..%s)"),
            UP_TO_DATE("(no change)");

            private String description;

            private Change(String description) {
                this.description = description;
            }
        }
    }

    public static interface PushPolicyResult {
        public List<PushResult> getPushResults();

        public Map<String, RemoteBranchChange> getAcceptedUpdates();

        public Map<String, RemoteBranchChange> getRejectedUpdates();

        public Exception getLastException();
    }

    public static interface PullPolicyResult {
        public Map<String, BranchChange> localUpdateVersions();

        public boolean remoteUpdateRequired();

        public Set<String> getVersions();

        public Exception getLastException();
    }
}

