/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.git.internal;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.List;

class ProfilesVisitor<T>
extends SimpleFileVisitor<T> {
    private List<File> profiles = new ArrayList<File>();
    private PathMatcher pathMatcher;

    public ProfilesVisitor(File rootDirectory, String pattern) {
        String globPrefix = rootDirectory.toString();
        if (File.separatorChar == '\\') {
            globPrefix = globPrefix.replace("\\", "\\\\");
        }
        this.pathMatcher = FileSystems.getDefault().getPathMatcher("glob:" + globPrefix + "**" + pattern + "**.profile");
    }

    @Override
    public FileVisitResult preVisitDirectory(T dir, BasicFileAttributes attrs) throws IOException {
        Path p = (Path)dir;
        if (this.pathMatcher.matches(p)) {
            this.profiles.add(p.toFile());
        }
        return FileVisitResult.CONTINUE;
    }

    public List<File> getProfiles() {
        return this.profiles;
    }
}

