/*
 * Decompiled with CFR 0.152.
 */
package org.gitective.core;

import java.util.ArrayList;
import org.eclipse.jgit.treewalk.filter.AndTreeFilter;
import org.eclipse.jgit.treewalk.filter.OrTreeFilter;
import org.eclipse.jgit.treewalk.filter.PathFilter;
import org.eclipse.jgit.treewalk.filter.PathFilterGroup;
import org.eclipse.jgit.treewalk.filter.PathSuffixFilter;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.gitective.core.Assert;

public abstract class PathFilterUtils {
    private static TreeFilter[] paths(String ... paths) {
        int length = paths.length;
        TreeFilter[] filters = new TreeFilter[length];
        for (int i = 0; i < length; ++i) {
            filters[i] = PathFilter.create(paths[i]);
        }
        return filters;
    }

    private static TreeFilter[] suffix(String ... paths) {
        int length = paths.length;
        TreeFilter[] filters = new TreeFilter[length];
        for (int i = 0; i < length; ++i) {
            filters[i] = PathSuffixFilter.create(paths[i]);
        }
        return filters;
    }

    private static TreeFilter group(String ... paths) {
        int length = paths.length;
        ArrayList<PathFilter> filters = new ArrayList<PathFilter>(length);
        for (int i = 0; i < length; ++i) {
            filters.add(PathFilter.create(paths[i]));
        }
        return PathFilterGroup.create(filters);
    }

    private static TreeFilter andDiff(TreeFilter[] filters) {
        TreeFilter filter = filters.length > 1 ? AndTreeFilter.create(filters) : filters[0];
        return AndTreeFilter.create(filter, TreeFilter.ANY_DIFF);
    }

    private static TreeFilter orDiff(TreeFilter[] filters) {
        TreeFilter filter = filters.length > 1 ? OrTreeFilter.create(filters) : filters[0];
        return AndTreeFilter.create(filter, TreeFilter.ANY_DIFF);
    }

    public static TreeFilter and(String ... paths) {
        if (paths == null) {
            throw new IllegalArgumentException(Assert.formatNotNull("Paths"));
        }
        if (paths.length == 0) {
            throw new IllegalArgumentException(Assert.formatNotEmpty("Paths"));
        }
        return PathFilterUtils.andDiff(PathFilterUtils.paths(paths));
    }

    public static TreeFilter or(String ... paths) {
        if (paths == null) {
            throw new IllegalArgumentException(Assert.formatNotNull("Paths"));
        }
        if (paths.length == 0) {
            throw new IllegalArgumentException(Assert.formatNotEmpty("Paths"));
        }
        return AndTreeFilter.create(PathFilterUtils.group(paths), TreeFilter.ANY_DIFF);
    }

    public static TreeFilter andSuffix(String ... suffixes) {
        if (suffixes == null) {
            throw new IllegalArgumentException(Assert.formatNotNull("Suffixes"));
        }
        if (suffixes.length == 0) {
            throw new IllegalArgumentException(Assert.formatNotEmpty("Suffixes"));
        }
        return PathFilterUtils.andDiff(PathFilterUtils.suffix(suffixes));
    }

    public static TreeFilter orSuffix(String ... suffixes) {
        if (suffixes == null) {
            throw new IllegalArgumentException(Assert.formatNotNull("Suffixes"));
        }
        if (suffixes.length == 0) {
            throw new IllegalArgumentException(Assert.formatNotEmpty("Suffixes"));
        }
        return PathFilterUtils.orDiff(PathFilterUtils.suffix(suffixes));
    }
}

