/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.git.internal;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import io.fabric8.api.DataStore;
import io.fabric8.api.DataStoreTemplate;
import io.fabric8.api.FabricException;
import io.fabric8.api.GitContext;
import io.fabric8.api.LockHandle;
import io.fabric8.api.Profile;
import io.fabric8.api.ProfileBuilder;
import io.fabric8.api.ProfileBuilders;
import io.fabric8.api.ProfileRegistry;
import io.fabric8.api.Profiles;
import io.fabric8.api.RuntimeProperties;
import io.fabric8.api.Version;
import io.fabric8.api.VersionBuilder;
import io.fabric8.api.VersionSequence;
import io.fabric8.api.commands.GitVersion;
import io.fabric8.api.commands.GitVersions;
import io.fabric8.api.gravia.IllegalArgumentAssertion;
import io.fabric8.api.gravia.IllegalStateAssertion;
import io.fabric8.api.jcip.ThreadSafe;
import io.fabric8.api.scr.AbstractComponent;
import io.fabric8.api.scr.Configurer;
import io.fabric8.api.scr.ValidatingReference;
import io.fabric8.api.visibility.VisibleForExternal;
import io.fabric8.common.util.Files;
import io.fabric8.common.util.Strings;
import io.fabric8.common.util.Zips;
import io.fabric8.git.GitDataStore;
import io.fabric8.git.GitListener;
import io.fabric8.git.GitProxyService;
import io.fabric8.git.GitService;
import io.fabric8.git.PullPushPolicy;
import io.fabric8.git.internal.DefaultPullPushPolicy;
import io.fabric8.git.internal.DummyBatchingProgressMonitor;
import io.fabric8.git.internal.GitHelpers;
import io.fabric8.git.internal.GitOperation;
import io.fabric8.git.internal.ProfilesVisitor;
import io.fabric8.service.EnvPlaceholderResolver;
import io.fabric8.utils.DataStoreUtils;
import io.fabric8.utils.NamedThreadFactory;
import io.fabric8.zookeeper.ZkPath;
import io.fabric8.zookeeper.utils.ZooKeeperUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.shared.SharedCount;
import org.apache.curator.framework.recipes.shared.SharedCountListener;
import org.apache.curator.framework.recipes.shared.SharedCountReader;
import org.apache.curator.framework.state.ConnectionState;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.zookeeper.KeeperException;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.PushCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.internal.storage.file.LockFile;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.PushResult;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;
import org.gitective.core.RepositoryUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
@Component(name="io.fabric8.datastore", label="Fabric8 Git DataStore", description="Configuration of the git based configuration data store for Fabric8", policy=ConfigurationPolicy.OPTIONAL, immediate=true, metatype=true)
@Service(value={GitDataStore.class, ProfileRegistry.class})
public final class GitDataStoreImpl
extends AbstractComponent
implements GitDataStore,
ProfileRegistry {
    private static final transient Logger LOGGER = LoggerFactory.getLogger(GitDataStoreImpl.class);
    private static final String HISTORY_BRANCH = "container-history";
    private static final String ADMIN_HISTORY_BRANCH = "admin-container-history";
    private static final String GIT_REMOTE_USER = "gitRemoteUser";
    private static final String GIT_REMOTE_PASSWORD = "gitRemotePassword";
    private static final String GIT_GC_ON_LOAD = "gitGcOnLoad";
    private static final int GIT_COMMIT_SHORT_LENGTH = 7;
    private static final int MAX_COMMITS_WITHOUT_GC = 40;
    private static final long AQUIRE_LOCK_TIMEOUT = 25000L;
    @Reference(referenceInterface=CuratorFramework.class)
    private final ValidatingReference<CuratorFramework> curator = new ValidatingReference();
    @Reference(referenceInterface=GitService.class)
    private final ValidatingReference<GitService> gitService = new ValidatingReference();
    @Reference(referenceInterface=GitProxyService.class)
    private final ValidatingReference<GitProxyService> gitProxyService = new ValidatingReference();
    @Reference(referenceInterface=DataStore.class)
    private final ValidatingReference<DataStore> dataStore = new ValidatingReference();
    @Reference(referenceInterface=ProfileBuilders.class)
    private final ValidatingReference<ProfileBuilders> profileBuilders = new ValidatingReference();
    @Reference(referenceInterface=RuntimeProperties.class)
    private final ValidatingReference<RuntimeProperties> runtimeProperties = new ValidatingReference();
    @Reference
    private Configurer configurer;
    private final ScheduledExecutorService threadPool = Executors.newSingleThreadScheduledExecutor(new NamedThreadFactory("git-ds"));
    private final ImportExportHandler importExportHandler = new ImportExportHandler();
    private final GitDataStoreListener gitListener = new GitDataStoreListener();
    private final ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final boolean strictLockAssert = true;
    private int commitsWithoutGC = 40;
    private Map<String, String> dataStoreProperties;
    private ProxySelector defaultProxySelector;
    private PullPushPolicy pullPushPolicy;
    private boolean notificationRequired;
    private SharedCount counter;
    private String remoteUrl;
    @Property(name="gitRemoteUrl", label="External Git Repository URL", description="The URL to a fixed external git repository")
    private String gitRemoteUrl;
    @Property(name="gitTimeout", label="Timeout", description="Timeout connecting to remote git server (value in seconds)")
    private int gitTimeout = 40;
    @Property(name="importDir", label="Import Directory", description="Directory to import additional profiles", value={"fabric"})
    private String importDir = "fabric";
    @Property(name="gitRemotePollInterval", label="Remote poll Interval", description="The interval between remote repo polling operations")
    private long gitRemotePollInterval = 60000L;
    @Property(name="gitGcOnLoad", label="Run Git GC", description="Whether or not to run Git GC on load of the Git repo", boolValue={false})
    private boolean gitGcOnLoad = false;
    @Property(name="gitAllowRemoteUpdate", label="Allow remote update", description="Whether or not local changes should be pushed to remote repository if local branch/version is newer. Used only when fetching from remote repository.", boolValue={true})
    private boolean gitAllowRemoteUpdate = true;
    @Property(name="gitRandomFetchDelay", label="Fetch delay", description="If greater than 0, container will wait up to given number of seconds before fetching from remote repository.", intValue={0})
    private int gitRandomFetchDelay = 0;
    private final LoadingCache<String, Version> versionCache = CacheBuilder.newBuilder().build((CacheLoader)new VersionCacheLoader());
    private final Set<String> versions = new HashSet<String>();
    private final CountDownLatch initialVersionsAvailable = new CountDownLatch(1);
    private Random RND = new Random(new Date().getTime());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForExternal
    @Activate
    public void activate(Map<String, ?> configuration) throws Exception {
        String publishedUrl;
        if (Boolean.getBoolean("karaf.restart")) {
            LOGGER.info("Ignoring configuration update - container is being restarted");
            return;
        }
        LockFile.unlock(this.getGit().getRepository().getIndexFile());
        this.configurer.configure(configuration, (Object)this, new String[0]);
        HashMap<String, String> properties = new HashMap<String, String>();
        for (Map.Entry<String, ?> entry : configuration.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (!(value instanceof String)) continue;
            properties.put(key, (String)value);
        }
        if (this.gitRemoteUrl == null && ZooKeeperUtils.exists((CuratorFramework)((CuratorFramework)this.curator.get()), (String)ZkPath.CONFIG_GIT_EXTERNAL_URL.getPath(new String[0])) != null && (publishedUrl = ZooKeeperUtils.getStringData((CuratorFramework)((CuratorFramework)this.curator.get()), (String)ZkPath.CONFIG_GIT_EXTERNAL_URL.getPath(new String[0]))) != null && !"".equals(publishedUrl.trim())) {
            String externalUser;
            this.gitRemoteUrl = publishedUrl;
            if (ZooKeeperUtils.exists((CuratorFramework)((CuratorFramework)this.curator.get()), (String)ZkPath.CONFIG_GIT_EXTERNAL_USER.getPath(new String[0])) != null) {
                externalUser = ZooKeeperUtils.getStringData((CuratorFramework)((CuratorFramework)this.curator.get()), (String)ZkPath.CONFIG_GIT_EXTERNAL_USER.getPath(new String[0]));
                properties.put(GIT_REMOTE_USER, externalUser);
            }
            if (ZooKeeperUtils.exists((CuratorFramework)((CuratorFramework)this.curator.get()), (String)ZkPath.CONFIG_GIT_EXTERNAL_PASSWORD.getPath(new String[0])) != null) {
                externalUser = ZooKeeperUtils.getStringData((CuratorFramework)((CuratorFramework)this.curator.get()), (String)ZkPath.CONFIG_GIT_EXTERNAL_PASSWORD.getPath(new String[0]));
                properties.put(GIT_REMOTE_PASSWORD, externalUser);
            }
        }
        this.dataStoreProperties = Collections.unmodifiableMap(properties);
        this.pullPushPolicy = new DefaultPullPushPolicy(this.getGit(), "origin", this.gitTimeout, this.gitAllowRemoteUpdate);
        Thread currentThread = Thread.currentThread();
        ClassLoader backupClassLoader = null;
        try {
            backupClassLoader = currentThread.getContextClassLoader();
            currentThread.setContextClassLoader(this.getClass().getClassLoader());
            new DummyBatchingProgressMonitor();
        }
        finally {
            currentThread.setContextClassLoader(backupClassLoader);
        }
        try {
            this.activateComponent();
            this.activateInternal();
        }
        catch (Exception ex) {
            LOGGER.error(ex.getMessage(), (Throwable)ex);
            this.deactivateComponent();
            this.deactivateInternal();
            throw ex;
        }
    }

    @Deactivate
    void deactivate() {
        this.deactivateComponent();
        this.deactivateInternal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void activateInternal() throws Exception {
        LOGGER.info("Starting up GitDataStore " + this);
        DataStoreTemplate template = (DataStoreTemplate)((RuntimeProperties)this.runtimeProperties.get()).removeRuntimeAttribute(DataStoreTemplate.class);
        if (template != null) {
            Ref rootTag = this.getGit().getRepository().getRef("root");
            if (rootTag == null) {
                this.getGit().commit().setMessage("First Commit").setCommitter("fabric", "user@fabric").call();
                this.getGit().tag().setName("root").setMessage("Tag the root commit").call();
            }
            LOGGER.debug("Running datastore bootstrap template: " + template);
            template.doWith((ProfileRegistry)this, (DataStore)this.dataStore.get());
        }
        GitProxyService proxyService = (GitProxyService)this.gitProxyService.get();
        this.defaultProxySelector = ProxySelector.getDefault();
        FabricGitLocalHostProxySelector fabricProxySelector = new FabricGitLocalHostProxySelector(this.defaultProxySelector, proxyService);
        ProxySelector.setDefault(fabricProxySelector);
        LOGGER.debug("Setting up FabricProxySelector: {}", (Object)fabricProxySelector);
        if (this.gitRemoteUrl != null) {
            this.gitListener.runRemoteUrlChanged(this.gitRemoteUrl);
            this.remoteUrl = this.gitRemoteUrl;
        } else {
            ((GitService)this.gitService.get()).addGitListener(this.gitListener);
            this.remoteUrl = ((GitService)this.gitService.get()).getRemoteUrl();
            if (this.remoteUrl != null) {
                this.gitListener.runRemoteUrlChanged(this.remoteUrl);
            }
        }
        this.getInitialVersions();
        if (this.gitRemoteUrl != null) {
            LOGGER.info("Starting to pull from remote git repository every {} millis", (Object)this.gitRemotePollInterval);
            this.threadPool.scheduleWithFixedDelay(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    LockHandle writeLock = GitDataStoreImpl.this.aquireWriteLock();
                    try {
                        LOGGER.trace("Performing timed pull");
                        GitDataStoreImpl.this.doPullInternal();
                        LOGGER.debug("Performed timed pull from external git repo");
                    }
                    catch (Throwable e) {
                        LOGGER.debug("Error during performed timed pull/push due " + e.getMessage(), e);
                        LOGGER.warn("Error during performed timed pull/push due " + e.getMessage() + ". This exception is ignored.");
                    }
                    finally {
                        writeLock.unlock();
                    }
                }

                public String toString() {
                    return "TimedPushTask";
                }
            }, 1000L, this.gitRemotePollInterval, TimeUnit.MILLISECONDS);
        }
        LOGGER.info("Using ZooKeeper SharedCount to react when master git repo is changed, so we can do a git pull to the local git repo.");
        this.counter = new SharedCount((CuratorFramework)this.curator.get(), ZkPath.GIT_TRIGGER.getPath(new String[0]), 0);
        this.counter.addListener(new SharedCountListener(){

            public void countHasChanged(SharedCountReader sharedCountReader, int value) throws Exception {
                Runnable task = new Runnable(){

                    @Override
                    public void run() {
                        GitDataStoreImpl.this.doPullInternal();
                    }
                };
                if (GitDataStoreImpl.this.gitRandomFetchDelay == 0) {
                    LOGGER.debug("Watch counter updated to " + value + ", scheduling immediate pull");
                    GitDataStoreImpl.this.threadPool.submit(task);
                } else {
                    int delay = GitDataStoreImpl.this.RND.nextInt(GitDataStoreImpl.this.gitRandomFetchDelay) + 1;
                    LOGGER.debug("Watch counter updated to " + value + ", scheduling pull with random delay=" + delay + "s");
                    GitDataStoreImpl.this.threadPool.schedule(task, (long)delay, TimeUnit.SECONDS);
                }
            }

            public void stateChanged(CuratorFramework curatorFramework, ConnectionState connectionState) {
                switch (connectionState) {
                    case SUSPENDED: 
                    case READ_ONLY: 
                    case LOST: {
                        break;
                    }
                    case CONNECTED: 
                    case RECONNECTED: {
                        LOGGER.info("Shared Counter (Re)connected, doing a pull");
                        GitDataStoreImpl.this.doPullInternal();
                    }
                }
            }
        });
        try {
            this.counter.start();
        }
        catch (KeeperException.NotReadOnlyException notReadOnlyException) {
            // empty catch block
        }
        if (this.gitGcOnLoad) {
            LockHandle writeLock = this.aquireWriteLock();
            try {
                GitOperation<Void> gitop = new GitOperation<Void>(){

                    @Override
                    public Void call(Git git, GitContext context) throws Exception {
                        long before = System.currentTimeMillis();
                        try {
                            git.gc().call();
                            LOGGER.debug("git gc took " + (System.currentTimeMillis() - before) + " ms.");
                        }
                        catch (GitAPIException e) {
                            LOGGER.debug("git gc threw an exception!", (Throwable)e);
                        }
                        return null;
                    }
                };
                this.executeInternal(new GitContext(), null, gitop);
            }
            finally {
                writeLock.unlock();
            }
        }
        if (this.readWriteLock.isWriteLockedByCurrentThread() || this.readWriteLock.getWriteHoldCount() == 0) {
            try {
                this.doPullInternal();
            }
            catch (IllegalStateException e) {
                LOGGER.info("Another thread acquired write lock and GitDataStore can't pull from remote repository.");
            }
        } else {
            LOGGER.info("Another thread is keeping git write lock. GitDataStore will continue activation.");
        }
    }

    private void deactivateInternal() {
        ((GitService)this.gitService.get()).removeGitListener(this.gitListener);
        this.threadPool.shutdown();
        try {
            if (!this.threadPool.awaitTermination(5L, TimeUnit.SECONDS)) {
                this.threadPool.shutdownNow();
            }
        }
        catch (InterruptedException ex) {
            this.threadPool.shutdownNow();
            Thread.currentThread().interrupt();
        }
        catch (Exception ex) {
            throw FabricException.launderThrowable((Throwable)ex);
        }
        finally {
            LOGGER.debug("Restoring ProxySelector to original: {}", (Object)this.defaultProxySelector);
            ProxySelector.setDefault(this.defaultProxySelector);
            try {
                if (this.counter != null) {
                    this.counter.close();
                }
            }
            catch (IOException ex) {
                LOGGER.warn("Error closing SharedCount due " + ex.getMessage() + ". This exception is ignored.");
            }
        }
    }

    @Override
    public Git getGit() {
        return ((GitService)this.gitService.get()).getGit();
    }

    public LockHandle aquireWriteLock() {
        boolean success;
        final ReentrantReadWriteLock.WriteLock writeLock = this.readWriteLock.writeLock();
        try {
            success = writeLock.tryLock() || writeLock.tryLock(25000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException ex) {
            success = false;
        }
        IllegalStateAssertion.assertTrue((Boolean)success, (String)"Cannot obtain profile write lock in time");
        return new LockHandle(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void unlock() {
                if (GitDataStoreImpl.this.notificationRequired && GitDataStoreImpl.this.readWriteLock.getWriteHoldCount() == 1) {
                    try {
                        ((DataStore)GitDataStoreImpl.this.dataStore.get()).fireChangeNotifications();
                    }
                    finally {
                        GitDataStoreImpl.this.notificationRequired = false;
                    }
                }
                writeLock.unlock();
            }
        };
    }

    public LockHandle aquireReadLock() {
        boolean success;
        final ReentrantReadWriteLock.ReadLock readLock = this.readWriteLock.readLock();
        try {
            success = readLock.tryLock() || readLock.tryLock(25000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException ex) {
            success = false;
        }
        IllegalStateAssertion.assertTrue((Boolean)success, (String)"Cannot obtain profile read lock in time");
        return new LockHandle(){

            public void unlock() {
                readLock.unlock();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getInitialVersions() {
        LockHandle readLock = this.aquireReadLock();
        try {
            GitOperation<List<String>> gitop = new GitOperation<List<String>>(){

                @Override
                public List<String> call(Git git, GitContext context) throws Exception {
                    Collection<String> branches = RepositoryUtils.getBranches(git.getRepository());
                    ArrayList<String> answer = new ArrayList<String>();
                    for (String branch : branches) {
                        String prefix;
                        String name = branch;
                        if (!name.startsWith(prefix = "refs/heads/") || (name = name.substring(prefix.length())).equals("master") || name.startsWith("patch-") || name.startsWith("patches-") || name.equals(GitDataStoreImpl.HISTORY_BRANCH) || name.equals(GitDataStoreImpl.ADMIN_HISTORY_BRANCH)) continue;
                        answer.add(name);
                    }
                    GitDataStoreImpl.this.versions.clear();
                    GitDataStoreImpl.this.versions.addAll(answer);
                    if (answer.size() > 0) {
                        LOGGER.info("Initial versions cached");
                        GitDataStoreImpl.this.initialVersionsAvailable.countDown();
                    }
                    return answer;
                }
            };
            List<String> list = this.executeRead(gitop);
            return list;
        }
        finally {
            readLock.unlock();
        }
    }

    public Map<String, String> getDataStoreProperties() {
        return Collections.unmodifiableMap(this.dataStoreProperties);
    }

    private Version getVersionFromCache(String versionId, String profileId) {
        Version result = this.getVersionFromCacheRO(versionId, profileId);
        if (result == null) {
            return this.getVersionFromCacheRW(versionId, profileId);
        }
        return result;
    }

    private Version getVersionFromCacheRO(String versionId, String profileId) {
        LockHandle readLock = this.aquireReadLock();
        try {
            this.assertValid();
            String branch = GitHelpers.getProfileBranch(versionId, profileId);
            if (GitHelpers.localBranchExists(this.getGit(), branch)) {
                if (this.versionCache.asMap().containsKey(versionId)) {
                    Version version = (Version)this.versionCache.asMap().get(versionId);
                    return version;
                }
                Version version = null;
                return version;
            }
            Version version = null;
            return version;
        }
        catch (Exception e) {
            throw FabricException.launderThrowable((Throwable)e);
        }
        finally {
            readLock.unlock();
        }
    }

    private Version getVersionFromCacheRW(String versionId, String profileId) {
        try {
            this.initialVersionsAvailable.await(15L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            LOGGER.warn("Waiting for initial versions failed");
        }
        LockHandle writeLock = this.aquireWriteLock();
        try {
            this.assertValid();
            String branch = GitHelpers.getProfileBranch(versionId, profileId);
            if (GitHelpers.localBranchExists(this.getGit(), branch)) {
                Version version = (Version)this.versionCache.get((Object)versionId);
                return version;
            }
            Version version = null;
            return version;
        }
        catch (Exception e) {
            throw FabricException.launderThrowable((Throwable)e);
        }
        finally {
            writeLock.unlock();
        }
    }

    private Profile getProfileFromCache(String versionId, String profileId) {
        Version version = this.getVersionFromCache(versionId, profileId);
        return version != null ? version.getProfile(profileId) : null;
    }

    public String createVersion(String sourceId, String targetId, Map<String, String> attributes) {
        return this.createVersion(this.newGitWriteContext(targetId), sourceId, targetId, attributes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String createVersion(GitContext context, final String sourceId, final String targetId, final Map<String, String> attributes) {
        IllegalStateAssertion.assertNotNull((Object)sourceId, (String)"sourceId");
        IllegalStateAssertion.assertNotNull((Object)targetId, (String)"targetId");
        LockHandle writeLock = this.aquireWriteLock();
        try {
            this.assertValid();
            LOGGER.debug("Create version: {} => {}", (Object)sourceId, (Object)targetId);
            GitOperation<String> gitop = new GitOperation<String>(){

                @Override
                public String call(Git git, GitContext context) throws Exception {
                    IllegalStateAssertion.assertNull((Object)GitDataStoreImpl.this.checkoutProfileBranch(git, context, targetId, null), (String)("Version already exists: " + targetId));
                    GitDataStoreImpl.this.checkoutRequiredProfileBranch(git, context, sourceId, null);
                    GitDataStoreImpl.this.createOrCheckoutVersion(git, targetId);
                    if (attributes != null) {
                        GitDataStoreImpl.this.setVersionAttributes(git, context, targetId, attributes);
                    }
                    context.commitMessage("Create version: " + sourceId + " => " + targetId);
                    return targetId;
                }
            };
            String string = this.executeInternal(context, null, gitop);
            return string;
        }
        finally {
            writeLock.unlock();
        }
    }

    public String createVersion(Version version) {
        return this.createVersion(this.newGitWriteContext(version.getId()), version);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String modifyVersionDescription(final Version version, String description) {
        GitContext context = this.newGitWriteContext(version.getId());
        final Map attributes = version.getAttributes();
        attributes.put("description", description);
        IllegalStateAssertion.assertNotNull((Object)version, (String)"version");
        LockHandle writeLock = this.aquireWriteLock();
        try {
            this.assertValid();
            LOGGER.debug("Updating version: {}", (Object)version);
            GitOperation<String> gitop = new GitOperation<String>(){

                @Override
                public String call(Git git, GitContext context) throws Exception {
                    String versionId = version.getId();
                    GitHelpers.checkoutTag(git, "root");
                    GitDataStoreImpl.this.createOrCheckoutVersion(git, version.getId());
                    GitDataStoreImpl.this.setVersionAttributes(git, context, versionId, attributes);
                    context.commitMessage("Create version: " + version);
                    HashSet alreadyProcessedProfiles = new HashSet();
                    for (Profile profile : version.getProfiles()) {
                        GitDataStoreImpl.this.createOrUpdateProfile(context, null, profile, alreadyProcessedProfiles);
                    }
                    return versionId;
                }
            };
            String string = this.executeInternal(context, null, gitop);
            return string;
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String createVersion(GitContext context, final Version version) {
        IllegalStateAssertion.assertNotNull((Object)version, (String)"version");
        LockHandle writeLock = this.aquireWriteLock();
        try {
            this.assertValid();
            LOGGER.debug("Create version: {}", (Object)version);
            GitOperation<String> gitop = new GitOperation<String>(){

                @Override
                public String call(Git git, GitContext context) throws Exception {
                    String versionId = version.getId();
                    IllegalStateAssertion.assertNull((Object)GitDataStoreImpl.this.checkoutProfileBranch(git, context, versionId, null), (String)("Version already exists: " + versionId));
                    GitHelpers.checkoutTag(git, "root");
                    GitDataStoreImpl.this.createOrCheckoutVersion(git, version.getId());
                    GitDataStoreImpl.this.setVersionAttributes(git, context, versionId, version.getAttributes());
                    context.commitMessage("Create version: " + version);
                    HashSet alreadyProcessedProfiles = new HashSet();
                    for (Profile profile : version.getProfiles()) {
                        GitDataStoreImpl.this.createOrUpdateProfile(context, null, profile, alreadyProcessedProfiles);
                    }
                    return versionId;
                }
            };
            String string = this.executeInternal(context, null, gitop);
            return string;
        }
        finally {
            writeLock.unlock();
        }
    }

    public List<String> getVersionIds() {
        return this.getVersionIds(this.newGitReadContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getVersionIds(GitContext context) {
        LockHandle readLock = this.aquireReadLock();
        try {
            this.assertValid();
            GitOperation<List<String>> gitop = new GitOperation<List<String>>(){

                @Override
                public List<String> call(Git git, GitContext context) throws Exception {
                    ArrayList result = new ArrayList(GitDataStoreImpl.this.versions);
                    if (result.contains("master")) {
                        result.remove("master");
                    }
                    Collections.sort(result, VersionSequence.getComparator());
                    return Collections.unmodifiableList(result);
                }
            };
            List<String> list = this.executeInternal(context, null, gitop);
            return list;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GitVersions gitVersions() {
        LockHandle readLock = this.aquireReadLock();
        try {
            this.assertValid();
            GitOperation<GitVersions> gitop = new GitOperation<GitVersions>(){

                @Override
                public GitVersions call(Git git, GitContext context) throws Exception {
                    List<GitVersion> localVersions = GitHelpers.gitVersions(git);
                    return new GitVersions(localVersions);
                }
            };
            GitVersions gitVersions = this.executeInternal(this.newGitReadContext(), null, gitop);
            return gitVersions;
        }
        finally {
            readLock.unlock();
        }
    }

    public GitVersions gitSynchronize(boolean allowPush) {
        this.doPullInternal(allowPush);
        return this.gitVersions();
    }

    public boolean hasVersion(String versionId) {
        return this.hasVersion(this.newGitReadContext(), versionId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasVersion(GitContext context, final String versionId) {
        IllegalStateAssertion.assertNotNull((Object)versionId, (String)"versionId");
        LockHandle readLock = this.aquireReadLock();
        try {
            this.assertValid();
            GitOperation<Boolean> gitop = new GitOperation<Boolean>(){

                @Override
                public Boolean call(Git git, GitContext context) throws Exception {
                    return GitDataStoreImpl.this.versions.contains(versionId);
                }
            };
            boolean bl = this.executeInternal(context, null, gitop);
            return bl;
        }
        finally {
            readLock.unlock();
        }
    }

    public Version getVersion(String versionId) {
        IllegalStateAssertion.assertNotNull((Object)versionId, (String)"versionId");
        return this.getVersionFromCache(versionId, null);
    }

    public Version getRequiredVersion(String versionId) {
        IllegalStateAssertion.assertNotNull((Object)versionId, (String)"versionId");
        Version version = this.getVersionFromCache(versionId, null);
        IllegalStateAssertion.assertNotNull((Object)version, (String)("Version does not exist: " + versionId));
        return version;
    }

    public void deleteVersion(String versionId) {
        this.deleteVersion(new GitContext(), versionId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteVersion(GitContext context, final String versionId) {
        IllegalStateAssertion.assertNotNull((Object)versionId, (String)"versionId");
        LockHandle writeLock = this.aquireWriteLock();
        try {
            this.assertValid();
            LOGGER.debug("Delete version: " + versionId);
            GitOperation<Void> gitop = new GitOperation<Void>(){

                @Override
                public Void call(Git git, GitContext context) throws Exception {
                    GitDataStoreImpl.this.removeVersionFromCaches(versionId);
                    GitHelpers.removeBranch(git, versionId);
                    ((PushCommand)((PushCommand)git.push().setTimeout(GitDataStoreImpl.this.gitTimeout)).setCredentialsProvider(GitDataStoreImpl.this.getCredentialsProvider())).setRefSpecs(new RefSpec().setSource(null).setDestination("refs/heads/" + versionId)).call();
                    return null;
                }
            };
            this.executeInternal(context, null, gitop);
        }
        finally {
            writeLock.unlock();
        }
    }

    public String createProfile(Profile profile) {
        return this.createProfile(this.newGitWriteContext(profile.getVersion()), profile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String createProfile(GitContext context, final Profile profile) {
        IllegalStateAssertion.assertNotNull((Object)profile, (String)"profile");
        LockHandle writeLock = this.aquireWriteLock();
        try {
            this.assertValid();
            GitOperation<String> gitop = new GitOperation<String>(){

                @Override
                public String call(Git git, GitContext context) throws Exception {
                    String versionId = profile.getVersion();
                    String profileId = profile.getId();
                    Version version = GitDataStoreImpl.this.getRequiredVersion(versionId);
                    IllegalStateAssertion.assertFalse((Boolean)version.hasProfile(profileId), (String)("Profile already exists: " + profileId));
                    GitDataStoreImpl.this.checkoutRequiredProfileBranch(git, context, versionId, profileId);
                    return GitDataStoreImpl.this.createOrUpdateProfile(context, null, profile, new HashSet());
                }
            };
            String string = this.executeInternal(context, null, gitop);
            return string;
        }
        finally {
            writeLock.unlock();
        }
    }

    public String updateProfile(Profile profile) {
        return this.updateProfile(profile, false);
    }

    public String updateProfile(Profile profile, boolean force) {
        return this.updateProfile(this.newGitWriteContext(profile.getVersion()), profile, force);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String updateProfile(GitContext context, final Profile profile, boolean force) {
        IllegalStateAssertion.assertNotNull((Object)profile, (String)"profile");
        LockHandle writeLock = this.aquireWriteLock();
        try {
            this.assertValid();
            final String versionId = profile.getVersion();
            final String profileId = profile.getId();
            final Profile lastProfile = this.getRequiredProfile(versionId, profileId);
            if (force || !lastProfile.equals(profile)) {
                GitOperation<String> gitop = new GitOperation<String>(){

                    @Override
                    public String call(Git git, GitContext context) throws Exception {
                        GitDataStoreImpl.this.checkoutRequiredProfileBranch(git, context, versionId, profileId);
                        return GitDataStoreImpl.this.createOrUpdateProfile(context, lastProfile, profile, new HashSet());
                    }
                };
                String string = this.executeInternal(context, null, gitop);
                return string;
            }
            LOGGER.debug("Skip unchanged profile update for: {}", (Object)profile);
            String string = lastProfile.getId();
            return string;
        }
        finally {
            writeLock.unlock();
        }
    }

    public boolean hasProfile(String versionId, String profileId) {
        IllegalStateAssertion.assertNotNull((Object)versionId, (String)"versionId");
        IllegalStateAssertion.assertNotNull((Object)profileId, (String)"profileId");
        Profile profile = this.getProfileFromCache(versionId, profileId);
        return profile != null;
    }

    public Profile getProfile(String versionId, String profileId) {
        IllegalStateAssertion.assertNotNull((Object)versionId, (String)"versionId");
        IllegalStateAssertion.assertNotNull((Object)profileId, (String)"profileId");
        return this.getProfileFromCache(versionId, profileId);
    }

    public Profile getRequiredProfile(String versionId, String profileId) {
        IllegalStateAssertion.assertNotNull((Object)versionId, (String)"versionId");
        IllegalStateAssertion.assertNotNull((Object)profileId, (String)"profileId");
        Profile profile = this.getProfileFromCache(versionId, profileId);
        IllegalStateAssertion.assertNotNull((Object)profile, (String)("Profile does not exist: " + versionId + "/" + profileId));
        return profile;
    }

    public List<String> getProfiles(String versionId) {
        IllegalStateAssertion.assertNotNull((Object)versionId, (String)"versionId");
        this.assertValid();
        Version version = this.getVersionFromCache(versionId, null);
        List profiles = version != null ? version.getProfileIds() : Collections.emptyList();
        return Collections.unmodifiableList(profiles);
    }

    public void deleteProfile(String versionId, String profileId) {
        this.deleteProfile(this.newGitWriteContext(versionId), versionId, profileId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteProfile(GitContext context, final String versionId, final String profileId) {
        IllegalStateAssertion.assertNotNull((Object)versionId, (String)"versionId");
        IllegalStateAssertion.assertNotNull((Object)profileId, (String)"profileId");
        LockHandle writeLock = this.aquireWriteLock();
        try {
            this.assertValid();
            LOGGER.debug("Delete " + ProfileBuilder.Factory.create((String)versionId, (String)profileId).getProfile());
            GitOperation<Void> gitop = new GitOperation<Void>(){

                @Override
                public Void call(Git git, GitContext context) throws Exception {
                    GitDataStoreImpl.this.checkoutRequiredProfileBranch(git, context, versionId, profileId);
                    File profileDirectory = GitHelpers.getProfileDirectory(git, profileId);
                    GitDataStoreImpl.this.recursiveDeleteAndRemove(git, profileDirectory);
                    context.commitMessage("Removed profile " + profileId);
                    return null;
                }
            };
            this.executeInternal(context, null, gitop);
        }
        finally {
            writeLock.unlock();
        }
    }

    private String createOrUpdateProfile(GitContext context, Profile lastProfile, Profile profile, Set<String> profiles) throws IOException, GitAPIException {
        this.assertWriteLock();
        String versionId = profile.getVersion();
        String profileId = profile.getId();
        if (!profiles.contains(profileId)) {
            for (String parentId : profile.getParentIds()) {
                if (profiles.contains(parentId)) continue;
                Profile parent = this.getProfileFromCache(profile.getVersion(), parentId);
                IllegalStateAssertion.assertNotNull((Object)parent, (String)("Parent profile does not exist: " + parentId));
            }
            if (lastProfile == null) {
                LOGGER.debug("Create {}", (Object)Profiles.getProfileInfo((Profile)profile));
            } else {
                LOGGER.debug("Update {}", (Object)profile);
                LOGGER.debug("Update {}", (Object)Profiles.getProfileDifference((Profile)lastProfile, (Profile)profile));
            }
            if (lastProfile == null) {
                this.createProfileDirectoryAfterCheckout(context, versionId, profileId);
            }
            Map fileConfigurations = profile.getFileConfigurations();
            this.setFileConfigurations(context, versionId, profileId, fileConfigurations);
            if (context.getCommitMessage().length() == 0) {
                context.commitMessage("WARNING - Profile with no content: " + versionId + "/" + profileId);
            }
            profiles.add(profileId);
        }
        return profileId;
    }

    private String createProfileDirectoryAfterCheckout(GitContext context, String versionId, String profileId) throws IOException, GitAPIException {
        this.assertWriteLock();
        File profileDirectory = GitHelpers.getProfileDirectory(this.getGit(), profileId);
        if (!profileDirectory.exists()) {
            context.commitMessage("Create profile: " + profileId);
            return this.doCreateProfile(this.getGit(), context, versionId, profileId);
        }
        return null;
    }

    private void setFileConfigurations(GitContext context, String versionId, String profileId, Map<String, byte[]> fileConfigurations) throws IOException, GitAPIException {
        this.assertWriteLock();
        File profileDir = GitHelpers.getProfileDirectory(this.getGit(), profileId);
        final HashSet filesToDelete = new HashSet();
        if (profileDir.exists()) {
            ArrayList filesList = new ArrayList();
            java.nio.file.Files.walkFileTree(profileDir.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) throws IOException {
                    if (!"io.fabric8.agent.properties".equals(path.getFileName().toString())) {
                        filesToDelete.add(path.toFile());
                    }
                    return super.visitFile(path, attrs);
                }
            });
        }
        for (Map.Entry<String, byte[]> entry : fileConfigurations.entrySet()) {
            String fileName = entry.getKey();
            byte[] newCfg = entry.getValue();
            this.setFileConfiguration(this.getGit(), profileId, fileName, newCfg);
            filesToDelete.remove(new File(profileDir, fileName));
        }
        for (File file : filesToDelete) {
            this.recursiveDeleteAndRemove(this.getGit(), file);
        }
        if (!fileConfigurations.isEmpty() || !filesToDelete.isEmpty()) {
            context.commitMessage("Update configurations for profile: " + profileId);
        }
    }

    private void recursiveDeleteAndRemove(Git git, File file) throws IOException, GitAPIException {
        File rootDir = GitHelpers.getRootGitDirectory(git);
        String relativePath = this.getFilePattern(rootDir, file);
        if (file.exists() && !relativePath.equals(".git")) {
            File[] files;
            if (file.isDirectory() && (files = file.listFiles()) != null) {
                for (File child : files) {
                    this.recursiveDeleteAndRemove(git, child);
                }
            }
            file.delete();
            git.rm().addFilepattern(relativePath).call();
        }
    }

    private void setFileConfigurations(Git git, String profileId, Map<String, byte[]> fileConfigurations) throws IOException, GitAPIException {
        for (Map.Entry<String, byte[]> entry : fileConfigurations.entrySet()) {
            String file = entry.getKey();
            byte[] newCfg = entry.getValue();
            this.setFileConfiguration(git, profileId, file, newCfg);
        }
    }

    private void setFileConfiguration(Git git, String profileId, String fileName, byte[] configuration) throws IOException, GitAPIException {
        File profileDirectory = GitHelpers.getProfileDirectory(git, profileId);
        File file = new File(profileDirectory, fileName);
        if (!file.exists() || !Arrays.equals(Files.readBytes((File)file), configuration)) {
            Files.writeToFile((File)file, (byte[])configuration);
            this.addFiles(git, file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importProfiles(final String versionId, final List<String> profileZipUrls) {
        IllegalStateAssertion.assertNotNull((Object)versionId, (String)"versionId");
        IllegalStateAssertion.assertNotNull(profileZipUrls, (String)"profileZipUrls");
        LockHandle writeLock = this.aquireWriteLock();
        try {
            this.assertValid();
            GitOperation<String> gitop = new GitOperation<String>(){

                @Override
                public String call(Git git, GitContext context) throws Exception {
                    GitDataStoreImpl.this.createOrCheckoutVersion(git, versionId);
                    return GitDataStoreImpl.this.doImportProfiles(git, context, profileZipUrls);
                }
            };
            this.executeWrite(gitop, versionId);
        }
        finally {
            writeLock.unlock();
        }
    }

    public void importFromFileSystem(String importPath) {
        IllegalArgumentAssertion.assertNotNull((Object)importPath, (String)"importPath");
        Path importBase = Paths.get(importPath, new String[0]);
        this.importExportHandler.importFromFileSystem(importBase);
        this.importExportHandler.importZipAndArtifacts(importBase.getParent());
        LOGGER.info("Profiles imported from " + importPath);
        this.initialVersionsAvailable.countDown();
    }

    public void exportProfiles(String versionId, String outputName, String wildcard) {
        IllegalArgumentAssertion.assertNotNull((Object)versionId, (String)"versionId");
        IllegalArgumentAssertion.assertNotNull((Object)outputName, (String)"outputName");
        this.importExportHandler.exportProfiles(versionId, outputName, wildcard);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterable<PushResult> doPush(Git git, GitContext context) throws Exception {
        IllegalArgumentAssertion.assertNotNull((Object)git, (String)"git");
        IllegalArgumentAssertion.assertNotNull((Object)context, (String)"context");
        LockHandle writeLock = this.aquireWriteLock();
        try {
            this.assertValid();
            LOGGER.debug("External call to push");
            PullPushPolicy.PushPolicyResult pushResult = this.doPushInternal(context, this.getCredentialsProvider());
            List<PushResult> list = pushResult.getPushResults();
            return list;
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T gitOperation(GitContext context, GitOperation<T> gitop, PersonIdent personIdent) {
        IllegalArgumentAssertion.assertNotNull(gitop, (String)"gitop");
        IllegalArgumentAssertion.assertNotNull((Object)context, (String)"context");
        LockHandle writeLock = this.aquireWriteLock();
        try {
            this.assertValid();
            LOGGER.debug("External call to execute a git operation: " + gitop);
            T t = this.executeInternal(context, personIdent, gitop);
            return t;
        }
        finally {
            writeLock.unlock();
        }
    }

    private <T> T executeRead(GitOperation<T> operation) {
        return this.executeInternal(this.newGitReadContext(), null, operation);
    }

    private <T> T executeWrite(GitOperation<T> operation, String versionId) {
        return this.executeInternal(this.newGitWriteContext(versionId), null, operation);
    }

    private GitContext newGitReadContext() {
        return new GitContext();
    }

    private GitContext newGitWriteContext(String version) {
        return new GitContext().requireCommit().requirePush().setCacheKey((Object)version);
    }

    private <T> T executeInternal(GitContext context, PersonIdent personIdent, GitOperation<T> operation) {
        if (context.isRequirePull() || context.isRequireCommit()) {
            this.assertWriteLock();
        } else {
            this.assertReadLock();
        }
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        try {
            PullPushPolicy.PushPolicyResult pushResult;
            ClassLoader gitcl = GitDataStoreImpl.class.getClassLoader();
            Thread.currentThread().setContextClassLoader(gitcl);
            LOGGER.trace("Setting ThreadContextClassLoader to {} instead of {}", (Object)gitcl, (Object)tccl);
            Git git = this.getGit();
            Repository repository = git.getRepository();
            if (personIdent == null) {
                personIdent = new PersonIdent(repository);
            }
            if (context.isRequirePull()) {
                this.doPullInternal(context, this.getCredentialsProvider(), false);
            }
            T result = operation.call(git, context);
            if (context.isRequireCommit()) {
                this.doCommit(git, context);
                Object cacheKey = context.getCacheKey();
                if (cacheKey == null || cacheKey.equals("master")) {
                    this.versionCache.invalidateAll();
                } else {
                    this.versionCache.invalidate(cacheKey);
                }
                this.notificationRequired = true;
            }
            if (context.isRequirePush() && !(pushResult = this.doPushInternal(context, this.getCredentialsProvider())).getRejectedUpdates().isEmpty()) {
                Exception gitex = pushResult.getLastException();
                throw new IllegalStateException("Push rejected: " + pushResult.getRejectedUpdates().values(), gitex);
            }
            T t = result;
            return t;
        }
        catch (Exception e) {
            throw FabricException.launderThrowable((Throwable)e);
        }
        finally {
            LOGGER.trace("Restoring ThreadContextClassLoader to {}", (Object)tccl);
            Thread.currentThread().setContextClassLoader(tccl);
        }
    }

    private String doCreateProfile(Git git, GitContext context, String versionId, String profileId) throws IOException, GitAPIException {
        File profileDirectory = GitHelpers.getProfileDirectory(git, profileId);
        File metadataFile = new File(profileDirectory, "io.fabric8.agent.properties");
        IllegalStateAssertion.assertFalse((Boolean)metadataFile.exists(), (String)("Profile metadata file already exists: " + metadataFile));
        profileDirectory.mkdirs();
        Files.writeToFile((File)metadataFile, (String)("#Profile:" + profileId + "\n"), (Charset)Charset.defaultCharset());
        this.addFiles(git, profileDirectory, metadataFile);
        context.commitMessage("Added profile " + profileId);
        return profileId;
    }

    private void doCommit(Git git, GitContext context) {
        try {
            String message = context.getCommitMessage();
            IllegalStateAssertion.assertTrue((Boolean)(message.length() > 0 ? 1 : 0), (String)"Empty commit message");
            git.add().addFilepattern(".").call();
            git.commit().setMessage(message).call();
            if (--this.commitsWithoutGC < 0) {
                this.commitsWithoutGC = 40;
                LOGGER.debug("Performing 'git gc' after {} commits", (Object)40);
                git.gc().call();
            }
        }
        catch (GitAPIException ex) {
            throw FabricException.launderThrowable((Throwable)ex);
        }
    }

    private void doPullInternal() {
        this.doPullInternal(this.gitAllowRemoteUpdate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doPullInternal(boolean allowPush) {
        LockHandle writeLock = this.aquireWriteLock();
        try {
            this.doPullInternal(new GitContext(), this.getCredentialsProvider(), true, allowPush);
        }
        catch (Throwable e) {
            LOGGER.debug("Error during pull due " + e.getMessage(), e);
            LOGGER.warn("Error during pull due " + e.getMessage() + ". This exception is ignored.");
        }
        finally {
            writeLock.unlock();
        }
    }

    private PullPushPolicy.PullPolicyResult doPullInternal(GitContext context, CredentialsProvider credentialsProvider, boolean allowVersionDelete) {
        return this.doPullInternal(context, credentialsProvider, allowVersionDelete, true);
    }

    private PullPushPolicy.PullPolicyResult doPullInternal(GitContext context, CredentialsProvider credentialsProvider, boolean allowVersionDelete, boolean allowPush) {
        PullPushPolicy.PullPolicyResult pullResult = this.pullPushPolicy.doPull(context, credentialsProvider, allowVersionDelete, allowPush);
        if (pullResult.getLastException() == null) {
            Set<String> pullVersions;
            Map<String, PullPushPolicy.BranchChange> updatedVersions = pullResult.localUpdateVersions();
            if (!updatedVersions.isEmpty()) {
                if (updatedVersions.containsKey("master")) {
                    this.versionCache.invalidateAll();
                } else {
                    for (String version : updatedVersions.keySet()) {
                        this.versionCache.invalidate((Object)version);
                    }
                }
                this.notificationRequired = true;
            }
            if (!(pullVersions = pullResult.getVersions()).isEmpty() && !pullVersions.equals(this.versions)) {
                this.versions.clear();
                for (String v : pullVersions) {
                    if (v.startsWith("patches-") || v.startsWith("patch-") || v.equals(HISTORY_BRANCH) || v.equals(ADMIN_HISTORY_BRANCH)) continue;
                    this.versions.add(v);
                }
            }
            if (pullResult.remoteUpdateRequired()) {
                this.doPushInternal(context, credentialsProvider);
            }
        }
        return pullResult;
    }

    private PullPushPolicy.PushPolicyResult doPushInternal(GitContext context, CredentialsProvider credentialsProvider) {
        return this.pullPushPolicy.doPush(context, credentialsProvider);
    }

    private String doImportProfiles(Git git, GitContext context, List<String> profileZipUrls) throws GitAPIException, IOException {
        File profilesDirectory = GitHelpers.getProfilesDirectory(git);
        for (String url : profileZipUrls) {
            URL zipUrl;
            try {
                zipUrl = new URL(url);
            }
            catch (MalformedURLException e) {
                throw new IOException("Failed to create URL for " + url + ". " + e, e);
            }
            InputStream inputStream = zipUrl.openStream();
            if (inputStream == null) {
                throw new IOException("Could not open zip: " + url);
            }
            try {
                Zips.unzip((InputStream)inputStream, (File)profilesDirectory);
            }
            catch (IOException e) {
                throw new IOException("Failed to unzip " + url + ". " + e, e);
            }
        }
        this.addFiles(git, profilesDirectory);
        context.commitMessage("Added profile zip(s) " + profileZipUrls);
        return null;
    }

    private void addFiles(Git git, File ... files) throws GitAPIException, IOException {
        File rootDir = GitHelpers.getRootGitDirectory(git);
        for (File file : files) {
            String relativePath = this.getFilePattern(rootDir, file);
            git.add().addFilepattern(relativePath).call();
        }
    }

    private String getFilePattern(File rootDir, File file) throws IOException {
        String relativePath = Files.getRelativePath((File)rootDir, (File)file);
        if (relativePath.startsWith(File.separator)) {
            relativePath = relativePath.substring(1);
        }
        return relativePath.replace(File.separatorChar, '/');
    }

    private Map<String, String> getVersionAttributes(Git git, GitContext context, String versionId) throws IOException {
        byte[] content = GitHelpers.getContentOfObject(git, versionId, "version.attributes", false);
        if (content == null) {
            return Collections.emptyMap();
        }
        return DataStoreUtils.toMap(content);
    }

    private void setVersionAttributes(Git git, GitContext context, String versionId, Map<String, String> attributes) throws IOException, GitAPIException {
        File rootDirectory = GitHelpers.getRootGitDirectory(git);
        File file = new File(rootDirectory, "version.attributes");
        Files.writeToFile((File)file, (byte[])DataStoreUtils.toBytes(attributes));
        this.addFiles(git, file);
    }

    private void assertReadLock() {
        boolean locked = this.readWriteLock.getReadHoldCount() > 0 || this.readWriteLock.isWriteLockedByCurrentThread();
        IllegalStateAssertion.assertTrue((Boolean)locked, (String)"No read lock obtained");
        if (!locked) {
            LOGGER.warn("No read lock obtained");
        }
    }

    private void assertWriteLock() {
        boolean locked = this.readWriteLock.isWriteLockedByCurrentThread();
        IllegalStateAssertion.assertTrue((Boolean)locked, (String)"No write lock obtained");
        if (!locked) {
            LOGGER.warn("No write lock obtained");
        }
    }

    private void createOrCheckoutVersion(Git git, String versionId) throws GitAPIException {
        this.assertWriteLock();
        GitHelpers.createOrCheckoutBranch(git, versionId, "origin");
        this.cacheVersionId(versionId);
    }

    private String checkoutProfileBranch(Git git, GitContext context, String versionId, String profileId) throws GitAPIException {
        String branch = GitHelpers.getProfileBranch(versionId, profileId);
        if (branch.equals("master")) {
            context.setCacheKey(null);
        }
        return GitHelpers.checkoutBranch(git, branch) ? branch : null;
    }

    private void checkoutRequiredProfileBranch(Git git, GitContext context, String versionId, String profileId) throws GitAPIException {
        String branch = this.checkoutProfileBranch(git, context, versionId, profileId);
        IllegalStateAssertion.assertNotNull((Object)branch, (String)("Cannot checkout profile branch: " + versionId + "/" + profileId));
    }

    private CredentialsProvider getCredentialsProvider() {
        Map<String, String> properties = this.getDataStoreProperties();
        RuntimeProperties sysprops = (RuntimeProperties)this.runtimeProperties.get();
        String username = ZooKeeperUtils.getContainerLogin((RuntimeProperties)sysprops);
        String password = ZooKeeperUtils.generateContainerToken((RuntimeProperties)sysprops, (CuratorFramework)((CuratorFramework)this.curator.get()));
        if (this.isExternalGitConfigured(properties)) {
            username = this.getExternalUser(properties);
            password = this.getExternalCredential(properties);
        }
        return new UsernamePasswordCredentialsProvider(username, password);
    }

    private boolean isExternalGitConfigured(Map<String, String> properties) {
        return properties != null && properties.containsKey(GIT_REMOTE_USER);
    }

    private String getExternalUser(Map<String, String> properties) {
        return properties.get(GIT_REMOTE_USER);
    }

    private String getExternalCredential(Map<String, String> properties) {
        if (properties.containsKey(GIT_REMOTE_PASSWORD)) {
            return properties.get(GIT_REMOTE_PASSWORD);
        }
        return "";
    }

    private void cacheVersionId(String versionId) {
        if (!"master".equals(versionId)) {
            this.versions.add(versionId);
        }
    }

    private void removeVersionFromCaches(String versionId) {
        this.versionCache.invalidate((Object)versionId);
        this.versions.remove(versionId);
    }

    @VisibleForExternal
    public void bindConfigurer(Configurer service) {
        this.configurer = service;
    }

    void unbindConfigurer(Configurer service) {
        this.configurer = null;
    }

    @VisibleForExternal
    public void bindCurator(CuratorFramework service) {
        this.curator.bind((Object)service);
    }

    void unbindCurator(CuratorFramework service) {
        this.curator.unbind((Object)service);
    }

    @VisibleForExternal
    public void bindDataStore(DataStore service) {
        this.dataStore.bind((Object)service);
    }

    void unbindDataStore(DataStore service) {
        this.dataStore.unbind((Object)service);
    }

    @VisibleForExternal
    public void bindGitProxyService(GitProxyService service) {
        this.gitProxyService.bind((Object)service);
    }

    void unbindGitProxyService(GitProxyService service) {
        this.gitProxyService.unbind((Object)service);
    }

    @VisibleForExternal
    public void bindGitService(GitService service) {
        this.gitService.bind((Object)service);
    }

    void unbindGitService(GitService service) {
        this.gitService.unbind((Object)service);
    }

    @VisibleForExternal
    public void bindProfileBuilders(ProfileBuilders service) {
        this.profileBuilders.bind((Object)service);
    }

    void unbindProfileBuilders(ProfileBuilders service) {
        this.profileBuilders.unbind((Object)service);
    }

    @VisibleForExternal
    public void bindRuntimeProperties(RuntimeProperties service) {
        this.runtimeProperties.bind((Object)service);
    }

    void unbindRuntimeProperties(RuntimeProperties service) {
        this.runtimeProperties.unbind((Object)service);
    }

    class VersionCacheLoader
    extends CacheLoader<String, Version> {
        VersionCacheLoader() {
        }

        public Version load(final String versionId) {
            GitDataStoreImpl.this.assertWriteLock();
            GitOperation<Version> gitop = new GitOperation<Version>(){

                @Override
                public Version call(Git git, GitContext context) throws Exception {
                    String revision = git.getRepository().getRefDatabase().getRef(versionId).getObjectId().getName();
                    return VersionCacheLoader.this.loadVersion(git, context, versionId, revision);
                }
            };
            GitContext context = new GitContext();
            return (Version)GitDataStoreImpl.this.executeInternal(context, null, gitop);
        }

        private Version loadVersion(Git git, GitContext context, String versionId, String revision) throws Exception {
            VersionBuilder vbuilder = VersionBuilder.Factory.create((String)versionId).setRevision(revision);
            vbuilder.setAttributes(GitDataStoreImpl.this.getVersionAttributes(git, context, versionId));
            this.populateVersionBuilder(git, context, vbuilder, "master", versionId);
            this.populateVersionBuilder(git, context, vbuilder, versionId, versionId);
            return vbuilder.getVersion();
        }

        private void populateVersionBuilder(Git git, GitContext context, VersionBuilder builder, String branch, String versionId) throws GitAPIException, IOException {
            String[] files;
            GitDataStoreImpl.this.checkoutRequiredProfileBranch(git, context, branch, null);
            File profilesDir = GitHelpers.getProfilesDirectory(git);
            if (profilesDir.exists() && (files = profilesDir.list()) != null) {
                for (String childName : files) {
                    Path childPath = profilesDir.toPath().resolve(childName);
                    if (!childPath.toFile().isDirectory()) continue;
                    this.populateProfile(git, builder, branch, versionId, childPath.toFile(), "");
                }
            }
        }

        private void populateProfile(Git git, VersionBuilder versionBuilder, String branch, String versionId, File profileFile, String prefix) throws IOException {
            String profileName = profileFile.getName();
            String profileId = profileName;
            if (!profileId.endsWith(".profile")) {
                File[] files = profileFile.listFiles();
                if (files != null) {
                    for (File childFile : files) {
                        if (!childFile.isDirectory()) continue;
                        this.populateProfile(git, versionBuilder, branch, versionId, childFile, prefix + profileFile.getName() + "-");
                    }
                }
                return;
            }
            profileId = prefix + profileId.substring(0, profileId.length() - ".profile".length());
            Map<String, byte[]> fileConfigurations = this.doGetFileConfigurations(git, profileId);
            ProfileBuilder profileBuilder = ProfileBuilder.Factory.create((String)versionId, (String)profileId);
            profileBuilder.setFileConfigurations(fileConfigurations);
            versionBuilder.addProfile(profileBuilder.getProfile());
        }

        private Map<String, byte[]> doGetFileConfigurations(Git git, String profileId) throws IOException {
            HashMap<String, byte[]> configurations = new HashMap<String, byte[]>();
            File profileDirectory = GitHelpers.getProfileDirectory(git, profileId);
            this.populateFileConfigurations(configurations, profileDirectory, profileDirectory);
            return configurations;
        }

        private void populateFileConfigurations(Map<String, byte[]> configurations, File profileDirectory, File directory) throws IOException {
            File[] files = directory.listFiles();
            if (files != null) {
                for (File file : files) {
                    if (file.isFile()) {
                        String relativePath = GitDataStoreImpl.this.getFilePattern(profileDirectory, file);
                        configurations.put(relativePath, this.loadFileConfiguration(file));
                        continue;
                    }
                    if (!file.isDirectory()) continue;
                    this.populateFileConfigurations(configurations, profileDirectory, file);
                }
            }
        }

        private byte[] loadFileConfiguration(File file) throws IOException {
            if (file.isDirectory()) {
                StringBuilder buf = new StringBuilder();
                File[] files = file.listFiles();
                if (files != null) {
                    for (File child : files) {
                        String value = Files.toString((File)child);
                        buf.append(String.format("%s = %s\n", child.getName(), value));
                    }
                }
                return buf.toString().getBytes();
            }
            if (file.exists() && file.isFile()) {
                return Files.readBytes((File)file);
            }
            return null;
        }
    }

    class ImportExportHandler {
        ImportExportHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void importFromFileSystem(Path importPath) {
            LockHandle writeLock = GitDataStoreImpl.this.aquireWriteLock();
            try {
                GitDataStoreImpl.this.assertValid();
                File sourceDir = importPath.toFile();
                IllegalArgumentAssertion.assertTrue((Boolean)sourceDir.isDirectory(), (String)("Not a valid source dir: " + sourceDir));
                File fabricDir = new File(sourceDir, "fabric");
                File configs = new File(fabricDir, "configs");
                String defaultVersion = ((DataStore)GitDataStoreImpl.this.dataStore.get()).getDefaultVersion();
                if (configs.exists()) {
                    File metrics;
                    File[] files;
                    LOGGER.info("Importing the old ZooKeeper layout");
                    File versions = new File(configs, "versions");
                    if (versions.exists() && versions.isDirectory() && (files = versions.listFiles()) != null) {
                        for (File versionFolder : files) {
                            File[] versionFiles;
                            String version = versionFolder.getName();
                            if (!versionFolder.isDirectory() || (versionFiles = versionFolder.listFiles()) == null) continue;
                            for (File versionFile : versionFiles) {
                                LOGGER.info("Importing version configuration " + versionFile + " to branch " + version);
                                this.importFromFileSystem(versionFile, "fabric", version, true);
                            }
                        }
                    }
                    if ((metrics = new File(fabricDir, "metrics")).exists()) {
                        LOGGER.info("Importing metrics from " + metrics + " to branch " + defaultVersion);
                        this.importFromFileSystem(metrics, "fabric", defaultVersion, false);
                    }
                } else {
                    String version = "1.0";
                    LOGGER.info("Importing " + fabricDir + " as version " + version);
                    this.importFromFileSystem(fabricDir, "", version, false);
                }
            }
            finally {
                writeLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void exportProfiles(final String versionId, String outputFileName, final String wildcard) {
            LockHandle readLock = GitDataStoreImpl.this.aquireReadLock();
            try {
                GitDataStoreImpl.this.assertValid();
                final File outputFile = new File(outputFileName);
                outputFile.getParentFile().mkdirs();
                GitOperation<String> gitop = new GitOperation<String>(){

                    @Override
                    public String call(Git git, GitContext context) throws Exception {
                        GitDataStoreImpl.this.checkoutRequiredProfileBranch(git, context, versionId, null);
                        return ImportExportHandler.this.exportProfiles(git, context, outputFile, wildcard);
                    }
                };
                GitDataStoreImpl.this.executeRead(gitop);
            }
            finally {
                readLock.unlock();
            }
        }

        private String exportProfiles(Git git, GitContext context, File outputFile, String wildcard) throws IOException {
            File profilesDirectory = GitHelpers.getProfilesDirectory(git);
            ProfilesVisitor visitor = new ProfilesVisitor(profilesDirectory, wildcard);
            java.nio.file.Files.walkFileTree(profilesDirectory.toPath(), visitor);
            List<File> matchingProfiles = visitor.getProfiles();
            Zips.createZipFile((Logger)LOGGER, (File)profilesDirectory, matchingProfiles, (File)outputFile);
            return null;
        }

        private void importFromFileSystem(final File fabricDir, final String destinationPath, final String versionId, final boolean isProfileDir) {
            GitDataStoreImpl.this.assertWriteLock();
            GitOperation<Void> gitop = new GitOperation<Void>(){

                @Override
                public Void call(Git git, GitContext context) throws Exception {
                    GitHelpers.checkoutTag(git, "root");
                    GitDataStoreImpl.this.createOrCheckoutVersion(git, versionId);
                    File toDir = GitHelpers.getRootGitDirectory(git);
                    if (Strings.isNotBlank((String)destinationPath)) {
                        toDir = new File(toDir, destinationPath);
                    }
                    if (isProfileDir) {
                        ImportExportHandler.this.recursiveAddLegacyProfileDirectoryFiles(git, fabricDir, toDir, destinationPath);
                    } else {
                        ImportExportHandler.this.recursiveCopyAndAdd(git, fabricDir, toDir, destinationPath, false);
                    }
                    context.commitMessage("Imported from " + fabricDir);
                    return null;
                }
            };
            GitDataStoreImpl.this.executeWrite(gitop, versionId);
        }

        private void recursiveAddLegacyProfileDirectoryFiles(Git git, File from, File toDir, String path) throws GitAPIException, IOException {
            if (!from.isDirectory()) {
                throw new IllegalStateException("Should only be invoked on the profiles directory but was given file " + from);
            }
            String name = from.getName();
            String pattern = path + (path.length() > 0 && !path.endsWith(File.separator) ? File.separator : "") + name;
            File[] profiles = from.listFiles();
            File toFile = new File(toDir, name);
            if (profiles != null) {
                for (File profileDir : profiles) {
                    if (this.isProfileDirectory(profileDir)) {
                        String profileId = profileDir.getName();
                        String toProfileDirName = GitHelpers.convertProfileIdToDirectory(profileId);
                        File toProfileDir = new File(toFile, toProfileDirName);
                        toProfileDir.mkdirs();
                        this.recursiveCopyAndAdd(git, profileDir, toProfileDir, pattern, true);
                        continue;
                    }
                    this.recursiveCopyAndAdd(git, profileDir, toFile, pattern, false);
                }
            }
            git.add().addFilepattern(this.fixFilePattern(pattern)).call();
        }

        private void recursiveCopyAndAdd(Git git, File from, File toDir, String path, boolean useToDirAsDestination) throws GitAPIException, IOException {
            String name = from.getName();
            String pattern = path + (path.length() > 0 && !path.endsWith(File.separator) ? File.separator : "") + name;
            File toFile = new File(toDir, name);
            if (from.isDirectory()) {
                if (this.acceptDirectory(from)) {
                    if (useToDirAsDestination) {
                        toFile = toDir;
                    }
                    toFile.mkdirs();
                    File[] files = from.listFiles();
                    if (files != null) {
                        for (File file : files) {
                            this.recursiveCopyAndAdd(git, file, toFile, pattern, false);
                        }
                    }
                } else {
                    LOGGER.debug("Skip importing from directory: {}", (Object)from);
                }
            } else {
                Files.copy((File)from, (File)toFile);
            }
            git.add().addFilepattern(this.fixFilePattern(pattern)).call();
        }

        private boolean acceptDirectory(File dir) {
            String[] files = dir.list();
            if (files != null) {
                for (String name : files) {
                    if (!".skipimport".equals(name)) continue;
                    return false;
                }
            }
            return true;
        }

        void importZipAndArtifacts(Path fromPath) {
            String[] props;
            LOGGER.info("Importing additional profiles from file system directory: {}", (Object)fromPath);
            ArrayList<String> profiles = new ArrayList<String>();
            String[] zips = fromPath.toFile().list(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(".zip");
                }
            });
            int count = zips != null ? zips.length : 0;
            LOGGER.debug("Found {} .zip files to import", (Object)count);
            if (zips != null && zips.length > 0) {
                for (String name : zips) {
                    profiles.add("file:" + fromPath + "/" + name);
                    LOGGER.debug("Adding {} .zip file to import", (Object)name);
                }
            }
            count = (props = fromPath.toFile().list(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(".properties");
                }
            })) != null ? props.length : 0;
            LOGGER.debug("Found {} .properties files to import", (Object)count);
            try {
                if (props != null && props.length > 0) {
                    for (String name : props) {
                        Properties p = new Properties();
                        p.load(new FileInputStream(fromPath.resolve(name).toFile()));
                        Enumeration<?> e = p.propertyNames();
                        while (e.hasMoreElements()) {
                            String key = (String)e.nextElement();
                            String value = p.getProperty(key);
                            if (value == null) continue;
                            profiles.add(value);
                            LOGGER.debug("Adding {} to import", (Object)value);
                        }
                    }
                }
            }
            catch (Exception e) {
                LOGGER.debug("Error importing profiles due " + e.getMessage(), (Throwable)e);
                LOGGER.warn("Error importing profiles due " + e.getMessage() + ". This exception is ignored.");
            }
            String fabricVersion = ((DataStore)GitDataStoreImpl.this.dataStore.get()).getFabricReleaseVersion();
            ArrayList<String> replaced = new ArrayList<String>();
            for (String profileZipUrl : profiles) {
                String[] urls;
                String token = "\\$\\{version:fabric\\}";
                String url = profileZipUrl.replaceFirst(token, fabricVersion);
                String resolved = EnvPlaceholderResolver.resolveExpression((String)(url = EnvPlaceholderResolver.removeTokens((String)url)), null, (boolean)false);
                if (resolved != null) {
                    url = resolved;
                }
                for (String s : urls = url.split(",")) {
                    if ("false".equals(s = s.trim()) || "off".equals(s)) continue;
                    replaced.add(s);
                }
            }
            if (!replaced.isEmpty()) {
                LOGGER.info("Importing additional profiles from {} url locations ...", (Object)replaced.size());
                GitDataStoreImpl.this.importProfiles(((DataStore)GitDataStoreImpl.this.dataStore.get()).getDefaultVersion(), replaced);
                for (String url : replaced) {
                    LOGGER.info("Importing additional profile: {}", (Object)url);
                }
                LOGGER.info("Importing additional profiles done");
            }
        }

        private boolean isProfileDirectory(File profileDir) {
            String[] list;
            if (profileDir.isDirectory() && (list = profileDir.list()) != null) {
                for (String file : list) {
                    if (!file.endsWith(".properties") && !file.endsWith(".mvel")) continue;
                    return true;
                }
            }
            return false;
        }

        private String fixFilePattern(String pattern) {
            return pattern.replace(File.separatorChar, '/');
        }
    }

    static class FabricGitLocalHostProxySelector
    extends ProxySelector {
        static final String GIT_FABRIC_PATH = "/git/fabric/";
        final ProxySelector delegate;
        final GitProxyService proxyService;
        final List<Proxy> noProxy;

        FabricGitLocalHostProxySelector(ProxySelector delegate, GitProxyService proxyService) {
            this.delegate = delegate;
            this.proxyService = proxyService;
            this.noProxy = new ArrayList<Proxy>(1);
            this.noProxy.add(Proxy.NO_PROXY);
        }

        @Override
        public List<Proxy> select(URI uri) {
            List<Proxy> answer;
            String host = uri.getHost();
            String path = uri.getPath();
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("ProxySelector uri: {}", (Object)uri);
                LOGGER.trace("ProxySelector nonProxyHosts {}", (Object)this.proxyService.getNonProxyHosts());
                LOGGER.trace("ProxySelector proxyHost {}", (Object)this.proxyService.getProxyHost());
            }
            if (path != null && path.startsWith(GIT_FABRIC_PATH)) {
                answer = this.doSelect(host, this.proxyService.getNonProxyHosts(), this.proxyService.getProxyHost(), this.proxyService.getProxyPort());
                LOGGER.debug("ProxySelector uri: {} -> {}", (Object)uri, answer);
            } else {
                answer = this.delegate.select(uri);
            }
            return answer;
        }

        private List<Proxy> doSelect(String host, String nonProxy, String proxyHost, int proxyPort) {
            if (nonProxy != null) {
                StringTokenizer st = new StringTokenizer(nonProxy, "|", false);
                while (st.hasMoreTokens()) {
                    String token = st.nextToken();
                    if (host != null) {
                        if (!host.matches(token)) continue;
                        return this.noProxy;
                    }
                    LOGGER.debug("Error: Hostname is invalid");
                }
            }
            if (proxyHost != null) {
                InetSocketAddress adr = InetSocketAddress.createUnresolved(proxyHost, proxyPort);
                ArrayList<Proxy> answer = new ArrayList<Proxy>(1);
                answer.add(new Proxy(Proxy.Type.HTTP, adr));
                return answer;
            }
            return this.noProxy;
        }

        @Override
        public void connectFailed(URI uri, SocketAddress sa, IOException ioe) {
            this.delegate.connectFailed(uri, sa, ioe);
        }
    }

    class GitDataStoreListener
    implements GitListener {
        GitDataStoreListener() {
        }

        @Override
        public void onRemoteUrlChanged(String updatedUrl) {
            final String actualUrl = GitDataStoreImpl.this.gitRemoteUrl != null ? GitDataStoreImpl.this.gitRemoteUrl : updatedUrl;
            LOGGER.debug("GitDataStoreListener detected remote url change to \"" + actualUrl + "\". Submitting task" + " that'll pull from new remote. Using thread pool " + GitDataStoreImpl.this.threadPool);
            GitDataStoreImpl.this.threadPool.submit(new Runnable(){

                @Override
                public void run() {
                    GitDataStoreListener.this.runRemoteUrlChanged(actualUrl);
                }

                public String toString() {
                    return "RemoteUrlChangedTask";
                }
            });
        }

        @Override
        public void onReceivePack() {
            GitDataStoreImpl.this.assertValid();
            GitDataStoreImpl.this.versionCache.invalidateAll();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void runRemoteUrlChanged(final String updateUrl) {
            IllegalArgumentAssertion.assertNotNull((Object)updateUrl, (String)"updateUrl");
            LockHandle writeLock = GitDataStoreImpl.this.aquireWriteLock();
            try {
                if (!GitDataStoreImpl.this.isValid()) {
                    LOGGER.warn("Remote url change on invalid component: " + updateUrl);
                    return;
                }
                GitOperation<Void> gitop = new GitOperation<Void>(){

                    @Override
                    public Void call(Git git, GitContext context) throws Exception {
                        Repository repository = git.getRepository();
                        StoredConfig config = repository.getConfig();
                        String currentUrl = config.getString("remote", "origin", "url");
                        if (!updateUrl.equals(currentUrl)) {
                            LOGGER.info("Remote url change from: {} to: {}", (Object)currentUrl, (Object)updateUrl);
                            GitDataStoreImpl.this.remoteUrl = updateUrl;
                            config.setString("remote", "origin", "url", updateUrl);
                            config.setString("remote", "origin", "fetch", "+refs/heads/*:refs/remotes/origin/*");
                            config.save();
                            GitDataStoreImpl.this.doPullInternal(context, GitDataStoreImpl.this.getCredentialsProvider(), false);
                            if (currentUrl == null) {
                                GitDataStoreImpl.this.initialVersionsAvailable.countDown();
                            }
                        }
                        return null;
                    }
                };
                GitDataStoreImpl.this.executeInternal(new GitContext(), null, gitop);
            }
            finally {
                writeLock.unlock();
            }
        }
    }
}

