/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.git.internal;

import io.fabric8.api.GitContext;
import io.fabric8.api.gravia.IllegalStateAssertion;
import io.fabric8.api.visibility.VisibleForExternal;
import io.fabric8.git.PullPushPolicy;
import io.fabric8.git.internal.GitHelpers;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.eclipse.jgit.api.CreateBranchCommand;
import org.eclipse.jgit.api.FetchCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.ListBranchCommand;
import org.eclipse.jgit.api.LsRemoteCommand;
import org.eclipse.jgit.api.MergeCommand;
import org.eclipse.jgit.api.MergeResult;
import org.eclipse.jgit.api.PushCommand;
import org.eclipse.jgit.api.RebaseCommand;
import org.eclipse.jgit.api.RebaseResult;
import org.eclipse.jgit.api.ResetCommand;
import org.eclipse.jgit.api.errors.InvalidRemoteException;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.FetchResult;
import org.eclipse.jgit.transport.PushResult;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.RemoteRefUpdate;
import org.eclipse.jgit.transport.TagOpt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DefaultPullPushPolicy
implements PullPushPolicy {
    private static final transient Logger LOGGER = LoggerFactory.getLogger(DefaultPullPushPolicy.class);
    private static final int MAX_MERGES_WITHOUT_GC = 100;
    private final Git git;
    private final String remoteRef;
    private final int gitTimeout;
    private final boolean gitAllowRemoteUpdate;
    private int mergesWithoutGC = 100;

    @VisibleForExternal
    public DefaultPullPushPolicy(Git git, String remoteRef, int gitTimeout) {
        this(git, remoteRef, gitTimeout, true);
    }

    @VisibleForExternal
    public DefaultPullPushPolicy(Git git, String remoteRef, int gitTimeout, boolean gitAllowRemoteUpdate) {
        this.git = git;
        this.remoteRef = remoteRef;
        this.gitTimeout = gitTimeout;
        this.gitAllowRemoteUpdate = gitAllowRemoteUpdate;
    }

    @Override
    public synchronized PullPushPolicy.PullPolicyResult doPull(GitContext context, CredentialsProvider credentialsProvider, boolean allowVersionDelete) {
        return this.doPull(context, credentialsProvider, allowVersionDelete, this.gitAllowRemoteUpdate);
    }

    @Override
    public synchronized PullPushPolicy.PullPolicyResult doPull(GitContext context, CredentialsProvider credentialsProvider, boolean allowVersionDelete, boolean allowPush) {
        String name;
        Ref ref;
        Iterator i$;
        Repository repository = this.git.getRepository();
        StoredConfig config = repository.getConfig();
        String remoteUrl = config.getString("remote", this.remoteRef, "url");
        if (remoteUrl == null) {
            LOGGER.info("No remote repository defined, so not doing a pull");
            return new AbstractPullPolicyResult();
        }
        LOGGER.info("Performing a pull on remote URL: {}", (Object)remoteUrl);
        HashMap<String, Ref> localBranches = new HashMap<String, Ref>();
        HashMap<String, Ref> remoteBranches = new HashMap<String, Ref>();
        HashSet<String> allBranches = new HashSet<String>();
        Exception lastException = null;
        try {
            i$ = ((LsRemoteCommand)this.git.lsRemote().setCredentialsProvider(credentialsProvider)).setTags(false).setRemote(this.remoteRef).setHeads(true).call().iterator();
            while (i$.hasNext()) {
                ref = (Ref)i$.next();
                if (!ref.getName().startsWith("refs/heads/")) continue;
                name = ref.getName().substring("refs/heads/".length());
                remoteBranches.put(name, ref);
                allBranches.add(name);
            }
            ((FetchCommand)((FetchCommand)this.git.fetch().setTimeout(this.gitTimeout)).setCredentialsProvider(credentialsProvider)).setTagOpt(TagOpt.FETCH_TAGS).setRemote(this.remoteRef).call();
        }
        catch (Exception ex) {
            lastException = ex;
        }
        if (lastException != null) {
            if (lastException instanceof InvalidRemoteException) {
                LOGGER.warn("Pull failed during fetch because remote repository is not ready yet");
            } else {
                LOGGER.warn("Pull failed during fetch because of: " + lastException.getMessage(), (Throwable)lastException);
            }
            return new AbstractPullPolicyResult(lastException);
        }
        try {
            i$ = this.git.branchList().setListMode(ListBranchCommand.ListMode.ALL).call().iterator();
            while (i$.hasNext()) {
                ref = (Ref)i$.next();
                if (!ref.getName().startsWith("refs/heads/")) continue;
                name = ref.getName().substring("refs/heads/".length());
                localBranches.put(name, ref);
                allBranches.add(name);
            }
            HashMap<String, PullPushPolicy.BranchChange> localUpdate = new HashMap<String, PullPushPolicy.BranchChange>();
            boolean remoteUpdate = false;
            TreeSet<String> versions = new TreeSet<String>();
            if (remoteBranches.isEmpty()) {
                LOGGER.info("Pulled from an empty remote repository");
                return new AbstractPullPolicyResult(versions, localUpdate, !localBranches.isEmpty(), null);
            }
            LOGGER.debug("Processing remote branches: {}", remoteBranches);
            IllegalStateAssertion.assertTrue((Boolean)remoteBranches.containsKey("master"), (String)"Remote repository does not have a master branch");
            for (String branch : allBranches) {
                String remoteCommit;
                boolean allowDelete;
                boolean bl = allowDelete = allowVersionDelete && !"master".equals(branch);
                if (localBranches.containsKey(branch) && !remoteBranches.containsKey(branch)) {
                    if (allowDelete) {
                        String remotebranchRef = String.format("remotes/%s/%s", this.remoteRef, branch);
                        LOGGER.info("Deleting local branch: {} and local reference to remote branch: {}", (Object)branch, (Object)remotebranchRef);
                        if (branch.equals(this.git.getRepository().getBranch())) {
                            this.git.clean().setCleanDirectories(true).call();
                            this.git.reset().setMode(ResetCommand.ResetType.MIXED).call();
                            this.git.reset().setMode(ResetCommand.ResetType.HARD).call();
                            this.git.checkout().setName("master").call();
                        }
                        this.git.branchDelete().setBranchNames(branch, remotebranchRef).setForce(true).call();
                        localUpdate.put(branch, new PullPushPolicy.BranchChange(branch).removed());
                        continue;
                    }
                    remoteUpdate = true;
                    continue;
                }
                if (!localBranches.containsKey(branch) && remoteBranches.containsKey(branch)) {
                    LOGGER.info("Adding new local branch: {}", (Object)branch);
                    this.git.checkout().setCreateBranch(true).setName(branch).setStartPoint(this.remoteRef + "/" + branch).setUpstreamMode(CreateBranchCommand.SetupUpstreamMode.TRACK).setForce(true).call();
                    versions.add(branch);
                    localUpdate.put(branch, new PullPushPolicy.BranchChange(branch).created());
                    continue;
                }
                if (!localBranches.containsKey(branch) || !remoteBranches.containsKey(branch)) continue;
                ObjectId localObjectId = ((Ref)localBranches.get(branch)).getObjectId();
                ObjectId remoteObjectId = ((Ref)remoteBranches.get(branch)).getObjectId();
                String localCommit = localObjectId.getName();
                if (!localCommit.equals(remoteCommit = remoteObjectId.getName())) {
                    this.git.clean().setCleanDirectories(true).call();
                    this.git.checkout().setName(branch).setForce(true).call();
                    MergeResult mergeResult = this.git.merge().setFastForward(MergeCommand.FastForwardMode.FF_ONLY).include(remoteObjectId).call();
                    MergeResult.MergeStatus mergeStatus = mergeResult.getMergeStatus();
                    LOGGER.info("Updating local branch {} with status: {} ({}..{})", new Object[]{branch, mergeStatus, localCommit, remoteCommit});
                    if (mergeStatus == MergeResult.MergeStatus.FAST_FORWARD) {
                        localUpdate.put(branch, new PullPushPolicy.BranchChange(branch).updated(localObjectId, remoteObjectId, "fast forward"));
                    } else if (mergeStatus == MergeResult.MergeStatus.ALREADY_UP_TO_DATE) {
                        if (allowPush) {
                            LOGGER.info("Remote branch {} is behind local version - changes will be pushed", (Object)branch);
                            remoteUpdate = true;
                        } else {
                            LOGGER.info("Remote branch {} is behind local version - changes won't be pushed - restoring remote tracking branch", (Object)branch);
                            GitHelpers.createOrCheckoutBranch(this.git, "master", "origin");
                            this.git.branchDelete().setBranchNames(branch).setForce(true).call();
                            this.git.checkout().setCreateBranch(true).setName(branch).setStartPoint(this.remoteRef + "/" + branch).setUpstreamMode(CreateBranchCommand.SetupUpstreamMode.TRACK).setForce(true).call();
                            localUpdate.put(branch, new PullPushPolicy.BranchChange(branch).updated(localObjectId, remoteObjectId, "reset"));
                        }
                    } else if (mergeStatus == MergeResult.MergeStatus.ABORTED) {
                        RebaseResult.Status rebaseStatus = null;
                        if (allowPush) {
                            LOGGER.info("Cannot fast forward branch {}, attempting rebase", (Object)branch);
                            RebaseResult rebaseResult = this.git.rebase().setUpstream(remoteCommit).call();
                            rebaseStatus = rebaseResult.getStatus();
                        }
                        if (rebaseStatus == RebaseResult.Status.OK) {
                            LOGGER.info("Rebase successful for branch {}", (Object)branch);
                            localUpdate.put(branch, new PullPushPolicy.BranchChange(branch).updated(localObjectId, remoteObjectId, "rebase"));
                            remoteUpdate = true;
                        } else {
                            if (allowPush) {
                                LOGGER.warn("Rebase on branch {} failed, restoring remote tracking branch", (Object)branch);
                                this.git.rebase().setOperation(RebaseCommand.Operation.ABORT).call();
                            } else {
                                LOGGER.info("Restoring remote tracking branch {}", (Object)branch);
                            }
                            GitHelpers.createOrCheckoutBranch(this.git, "master", "origin", remoteCommit);
                            this.git.branchDelete().setBranchNames(branch).setForce(true).call();
                            this.git.checkout().setCreateBranch(true).setName(branch).setStartPoint(this.remoteRef + "/" + branch).setUpstreamMode(CreateBranchCommand.SetupUpstreamMode.TRACK).setForce(true).call();
                            localUpdate.put(branch, new PullPushPolicy.BranchChange(branch).updated(localObjectId, remoteObjectId, "reset"));
                        }
                    }
                } else if (!this.git.status().call().isClean()) {
                    LOGGER.info("Local branch {} is up to date, but not clean. Cleaning working copy now.", (Object)branch);
                    this.git.clean().setCleanDirectories(true).call();
                    this.git.reset().setMode(ResetCommand.ResetType.MIXED).call();
                    this.git.reset().setMode(ResetCommand.ResetType.HARD).call();
                }
                versions.add(branch);
            }
            if (localUpdate.size() > 0 && --this.mergesWithoutGC < 0) {
                this.mergesWithoutGC = 100;
                LOGGER.info("Performing 'git gc' after {} merges", (Object)100);
                try {
                    this.git.gc().setAggressive(true).call();
                }
                catch (Exception e) {
                    LOGGER.warn("Problem invoking 'git gc': {}", (Object)e.getMessage());
                }
            }
            AbstractPullPolicyResult result = new AbstractPullPolicyResult(versions, localUpdate, remoteUpdate, null);
            LOGGER.info("Pull result: {}", (Object)result);
            return result;
        }
        catch (Exception ex) {
            LOGGER.error(ex.getMessage(), (Throwable)ex);
            return new AbstractPullPolicyResult(ex);
        }
    }

    @Override
    public synchronized PullPushPolicy.PushPolicyResult doPush(GitContext context, CredentialsProvider credentialsProvider) {
        StoredConfig config = this.git.getRepository().getConfig();
        String remoteUrl = config.getString("remote", this.remoteRef, "url");
        if (remoteUrl == null) {
            LOGGER.debug("No remote repository defined, so not doing a push");
            return new AbstractPushPolicyResult();
        }
        LOGGER.info("Pushing last change to: {}", (Object)remoteUrl);
        Iterator resit = null;
        Exception lastException = null;
        try {
            this.git.clean().setCleanDirectories(true).call();
            this.git.reset().setMode(ResetCommand.ResetType.MIXED).call();
            this.git.reset().setMode(ResetCommand.ResetType.HARD).call();
            resit = ((PushCommand)((PushCommand)this.git.push().setTimeout(this.gitTimeout)).setCredentialsProvider(credentialsProvider)).setPushTags().setPushAll().call().iterator();
        }
        catch (Exception ex) {
            lastException = ex;
        }
        if (lastException != null) {
            LOGGER.warn("Cannot push because of: " + lastException.toString(), (Throwable)lastException);
            return new AbstractPushPolicyResult(lastException);
        }
        ArrayList<PushResult> pushResults = new ArrayList<PushResult>();
        TreeMap<String, PullPushPolicy.RemoteBranchChange> acceptedUpdates = new TreeMap<String, PullPushPolicy.RemoteBranchChange>();
        TreeMap<String, PullPushPolicy.RemoteBranchChange> rejectedUpdates = new TreeMap<String, PullPushPolicy.RemoteBranchChange>();
        while (resit.hasNext()) {
            PushResult pushResult = (PushResult)resit.next();
            pushResults.add(pushResult);
            block8: for (RemoteRefUpdate refUpdate : pushResult.getRemoteUpdates()) {
                ObjectId to;
                RemoteRefUpdate.Status status = refUpdate.getStatus();
                ObjectId from = refUpdate.getTrackingRefUpdate() == null || refUpdate.getTrackingRefUpdate().getOldObjectId() == null ? refUpdate.getExpectedOldObjectId() : refUpdate.getTrackingRefUpdate().getOldObjectId();
                ObjectId objectId = to = refUpdate.getTrackingRefUpdate() == null || refUpdate.getTrackingRefUpdate().getNewObjectId() == null ? refUpdate.getNewObjectId() : refUpdate.getTrackingRefUpdate().getNewObjectId();
                if (status == RemoteRefUpdate.Status.OK) {
                    acceptedUpdates.put(refUpdate.getSrcRef(), new PullPushPolicy.RemoteBranchChange(refUpdate.getSrcRef(), refUpdate).updated(from, to, "fast-forward"));
                    continue;
                }
                if (status == RemoteRefUpdate.Status.UP_TO_DATE) {
                    acceptedUpdates.put(refUpdate.getSrcRef(), new PullPushPolicy.RemoteBranchChange(refUpdate.getSrcRef(), refUpdate));
                    continue;
                }
                switch (status) {
                    case REJECTED_NONFASTFORWARD: {
                        rejectedUpdates.put(refUpdate.getSrcRef(), new PullPushPolicy.RemoteBranchChange(refUpdate.getSrcRef(), refUpdate).rejected(from, to, "non fast-forward update"));
                        continue block8;
                    }
                }
                rejectedUpdates.put(refUpdate.getSrcRef(), new PullPushPolicy.RemoteBranchChange(refUpdate.getSrcRef(), refUpdate).rejected(from, to, status.toString()));
            }
        }
        for (String rejectedRefName : rejectedUpdates.keySet()) {
            RemoteRefUpdate rejectedRef = ((PullPushPolicy.RemoteBranchChange)rejectedUpdates.get(rejectedRefName)).getRemoteRefUpdate();
            LOGGER.warn("Rejected push: {}. Attempting to recreate local branch.", (Object)rejectedRef);
            String refName = rejectedRef.getRemoteName();
            String branch = refName.substring(refName.lastIndexOf(47) + 1);
            try {
                GitHelpers.checkoutBranch(this.git, branch);
                FetchResult fetchResult = ((FetchCommand)((FetchCommand)this.git.fetch().setTimeout(this.gitTimeout)).setCredentialsProvider(credentialsProvider)).setRemote(this.remoteRef).setRefSpecs(new RefSpec("refs/heads/" + branch)).call();
                Ref fetchRef = fetchResult.getAdvertisedRef("refs/heads/" + branch);
                this.git.branchRename().setOldName(branch).setNewName(branch + "-tmp").call();
                this.git.checkout().setCreateBranch(true).setName(branch).setStartPoint(fetchRef.getObjectId().getName()).call();
                this.git.branchDelete().setBranchNames(branch + "-tmp").setForce(true).call();
                LOGGER.info("Local branch {} recreated from {}", (Object)branch, (Object)fetchRef.toString());
            }
            catch (Exception ex) {
                LOGGER.warn("Cannot recreate branch " + branch + " because of: " + ex.toString(), (Throwable)ex);
            }
        }
        AbstractPushPolicyResult result = new AbstractPushPolicyResult(pushResults, acceptedUpdates, rejectedUpdates, null);
        LOGGER.info("Push result: {}", (Object)result);
        return result;
    }

    static class AbstractPushPolicyResult
    implements PullPushPolicy.PushPolicyResult {
        private final List<PushResult> pushResults = new ArrayList<PushResult>();
        private final Map<String, PullPushPolicy.RemoteBranchChange> acceptedUpdates = new TreeMap<String, PullPushPolicy.RemoteBranchChange>();
        private final Map<String, PullPushPolicy.RemoteBranchChange> rejectedUpdates = new TreeMap<String, PullPushPolicy.RemoteBranchChange>();
        private final Exception lastException;

        AbstractPushPolicyResult() {
            this(Collections.emptyList(), Collections.emptyMap(), Collections.emptyMap(), null);
        }

        AbstractPushPolicyResult(Exception lastException) {
            this(Collections.emptyList(), Collections.emptyMap(), Collections.emptyMap(), lastException);
        }

        AbstractPushPolicyResult(List<PushResult> pushResults, Map<String, PullPushPolicy.RemoteBranchChange> acceptedUpdates, Map<String, PullPushPolicy.RemoteBranchChange> rejectedUpdates, Exception lastException) {
            this.pushResults.addAll(pushResults);
            this.acceptedUpdates.putAll(acceptedUpdates);
            this.rejectedUpdates.putAll(rejectedUpdates);
            this.lastException = lastException;
        }

        @Override
        public List<PushResult> getPushResults() {
            return Collections.unmodifiableList(this.pushResults);
        }

        @Override
        public Map<String, PullPushPolicy.RemoteBranchChange> getAcceptedUpdates() {
            return Collections.unmodifiableMap(this.acceptedUpdates);
        }

        @Override
        public Map<String, PullPushPolicy.RemoteBranchChange> getRejectedUpdates() {
            return Collections.unmodifiableMap(this.rejectedUpdates);
        }

        @Override
        public Exception getLastException() {
            return this.lastException;
        }

        public String toString() {
            return "[accepted=" + this.acceptedUpdates.values() + ",rejected=" + this.rejectedUpdates.values() + ",error=" + this.lastException + "]";
        }
    }

    static class AbstractPullPolicyResult
    implements PullPushPolicy.PullPolicyResult {
        private final Set<String> versions = new TreeSet<String>();
        private final Map<String, PullPushPolicy.BranchChange> localUpdate = new HashMap<String, PullPushPolicy.BranchChange>();
        private final boolean remoteUpdate;
        private final Exception lastException;

        AbstractPullPolicyResult() {
            this(Collections.emptySet(), Collections.emptyMap(), false, null);
        }

        AbstractPullPolicyResult(Exception lastException) {
            this(Collections.emptySet(), Collections.emptyMap(), false, lastException);
        }

        AbstractPullPolicyResult(Set<String> versions, Map<String, PullPushPolicy.BranchChange> localUpdate, boolean remoteUpdate, Exception lastException) {
            this.versions.addAll(versions);
            this.localUpdate.putAll(localUpdate);
            this.remoteUpdate = remoteUpdate;
            this.lastException = lastException;
        }

        @Override
        public Map<String, PullPushPolicy.BranchChange> localUpdateVersions() {
            return Collections.unmodifiableMap(this.localUpdate);
        }

        @Override
        public boolean remoteUpdateRequired() {
            return this.remoteUpdate;
        }

        @Override
        public Set<String> getVersions() {
            return Collections.unmodifiableSet(this.versions);
        }

        @Override
        public Exception getLastException() {
            return this.lastException;
        }

        public String toString() {
            return "[localUpdate=" + this.localUpdate.values() + ",remoteUpdate=" + this.remoteUpdate + ",versions=" + this.versions + ",error=" + this.lastException + "]";
        }
    }
}

