/*
 * Decompiled with CFR 0.152.
 */
package org.gitective.core.filter.commit;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.revwalk.filter.RevFilter;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.gitective.core.filter.commit.CommitFilter;
import org.gitective.core.filter.tree.BaseTreeFilter;

public class CommitPipelineFilter
extends CommitFilter {
    private final List<Pipe> pipes = new ArrayList<Pipe>();

    public CommitPipelineFilter add(CommitPipelineFilter pipeline) {
        if (pipeline != this) {
            this.pipes.add(new NestedPipe(pipeline));
        }
        return this;
    }

    public CommitPipelineFilter add(RevFilter commitFilter, TreeFilter treeFilter) {
        if (commitFilter != null && treeFilter != null) {
            this.pipes.add(new CommitTreePipe(commitFilter, treeFilter));
        } else if (commitFilter != null) {
            this.pipes.add(new CommitPipe(commitFilter));
        } else if (treeFilter != null) {
            this.pipes.add(new TreePipe(treeFilter));
        }
        return this;
    }

    public CommitPipelineFilter add(TreeFilter treeFilter) {
        return this.add(null, treeFilter);
    }

    public CommitPipelineFilter add(RevFilter commitFilter) {
        return this.add(commitFilter, null);
    }

    @Override
    public CommitFilter setRepository(Repository repository) {
        for (Pipe pipe : this.pipes) {
            pipe.setRepository(repository);
        }
        return super.setRepository(repository);
    }

    protected boolean include(RevCommit commit, RevWalk commitWalk, TreeWalk treeWalk) throws IOException {
        for (Pipe pipe : this.pipes) {
            if (pipe.include(commitWalk, treeWalk, commit)) continue;
            return this.include(false);
        }
        return true;
    }

    @Override
    public boolean include(RevWalk commitWalk, RevCommit commit) throws IOException {
        return this.include(commit, commitWalk, new TreeWalk(commitWalk.getObjectReader()));
    }

    private static class NestedPipe
    implements Pipe {
        private final CommitPipelineFilter pipeline;

        public NestedPipe(CommitPipelineFilter pipeline) {
            this.pipeline = pipeline;
        }

        @Override
        public boolean include(RevWalk commitWalk, TreeWalk treeWalk, RevCommit commit) throws IOException {
            return this.pipeline.include(commit, commitWalk, treeWalk);
        }

        @Override
        public Pipe setRepository(Repository repository) {
            this.pipeline.setRepository(repository);
            return this;
        }
    }

    private static class CommitTreePipe
    extends TreePipe {
        private final RevFilter commitFilter;

        public CommitTreePipe(RevFilter commitFilter, TreeFilter treeFilter) {
            super(treeFilter);
            this.commitFilter = commitFilter;
        }

        @Override
        public boolean include(RevWalk commitWalk, TreeWalk treeWalk, RevCommit commit) throws IOException {
            if (!this.commitFilter.include(commitWalk, commit)) {
                return false;
            }
            return super.include(commitWalk, treeWalk, commit);
        }

        @Override
        public Pipe setRepository(Repository repository) {
            if (this.commitFilter instanceof CommitFilter) {
                ((CommitFilter)this.commitFilter).setRepository(repository);
            }
            return super.setRepository(repository);
        }
    }

    private static class TreePipe
    implements Pipe {
        private final TreeFilter filter;

        public TreePipe(TreeFilter filter) {
            this.filter = filter;
        }

        @Override
        public boolean include(RevWalk commitWalk, TreeWalk treeWalk, RevCommit commit) throws IOException {
            treeWalk.reset();
            treeWalk.setFilter(this.filter);
            while (treeWalk.next()) {
                if (!treeWalk.isSubtree()) continue;
                treeWalk.enterSubtree();
            }
            return true;
        }

        @Override
        public Pipe setRepository(Repository repository) {
            if (this.filter instanceof BaseTreeFilter) {
                ((BaseTreeFilter)this.filter).setRepository(repository);
            }
            return this;
        }
    }

    private static class CommitPipe
    implements Pipe {
        private final RevFilter filter;

        public CommitPipe(RevFilter filter) {
            this.filter = filter;
        }

        @Override
        public boolean include(RevWalk commitWalk, TreeWalk treeWalk, RevCommit commit) throws IOException {
            return this.filter.include(commitWalk, commit);
        }

        @Override
        public Pipe setRepository(Repository repository) {
            if (this.filter instanceof CommitFilter) {
                ((CommitFilter)this.filter).setRepository(repository);
            }
            return this;
        }
    }

    private static interface Pipe {
        public boolean include(RevWalk var1, TreeWalk var2, RevCommit var3) throws IOException;

        public Pipe setRepository(Repository var1);
    }
}

