/*
 * Decompiled with CFR 0.152.
 */
package org.gitective.core.filter.commit;

import java.util.Collection;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.gitective.core.filter.commit.CommitDiffEditFilter;
import org.gitective.core.filter.commit.CommitDiffFilter;
import org.gitective.core.filter.commit.CommitFilter;

public class CompositeDiffEditFilter
extends CommitDiffEditFilter {
    protected CommitDiffEditFilter[] filters;

    public CompositeDiffEditFilter(boolean detectRenames, CommitDiffEditFilter ... filters) {
        super(detectRenames);
        if (filters != null && filters.length > 0) {
            this.filters = new CommitDiffEditFilter[filters.length];
            System.arraycopy(filters, 0, this.filters, 0, filters.length);
        } else {
            this.filters = new CommitDiffEditFilter[0];
        }
    }

    public CompositeDiffEditFilter(CommitDiffEditFilter ... filters) {
        this(false, filters);
    }

    public CompositeDiffEditFilter add(CommitDiffFilter ... addedFilters) {
        if (addedFilters == null) {
            return this;
        }
        int added = addedFilters.length;
        if (added == 0) {
            return this;
        }
        int current = this.filters.length;
        CommitDiffEditFilter[] resized = new CommitDiffEditFilter[added + current];
        System.arraycopy(this.filters, 0, resized, 0, current);
        System.arraycopy(addedFilters, 0, resized, current, added);
        this.filters = resized;
        return this;
    }

    @Override
    public CommitFilter setRepository(Repository repository) {
        for (CommitDiffEditFilter filter : this.filters) {
            filter.setRepository(repository);
        }
        return super.setRepository(repository);
    }

    @Override
    public CommitFilter reset() {
        for (CommitDiffEditFilter filter : this.filters) {
            filter.reset();
        }
        return super.reset();
    }

    @Override
    public boolean include(RevWalk walker, RevCommit commit, Collection<DiffEntry> diffs) {
        int length = this.filters.length;
        for (int i = 0; i < length; ++i) {
            this.filters[i].markStart(commit);
        }
        boolean include = super.include(walker, commit, diffs);
        for (int i = 0; i < length; ++i) {
            this.filters[i].markEnd(commit);
        }
        return include;
    }

    protected CommitDiffEditFilter[] cloneFilters() {
        CommitDiffEditFilter[] copy = new CommitDiffEditFilter[this.filters.length];
        System.arraycopy(this.filters, 0, copy, 0, this.filters.length);
        return copy;
    }

    public int getSize() {
        return this.filters.length;
    }
}

