/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.git.internal;

import io.fabric8.api.RuntimeProperties;
import io.fabric8.api.jcip.ThreadSafe;
import io.fabric8.api.scr.AbstractComponent;
import io.fabric8.api.scr.ValidatingReference;
import io.fabric8.api.visibility.VisibleForTesting;
import io.fabric8.git.GitListener;
import io.fabric8.git.GitService;
import io.fabric8.zookeeper.bootstrap.BootstrapConfiguration;
import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.errors.RepositoryNotFoundException;
import org.eclipse.jgit.lib.RepositoryCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
@Component(name="io.fabric8.git.service", immediate=true, metatype=false)
@Service(value={GitService.class})
public final class FabricGitServiceImpl
extends AbstractComponent
implements GitService {
    public static Logger LOG = LoggerFactory.getLogger(FabricGitServiceImpl.class);
    public static final String DEFAULT_GIT_PATH = "git" + File.separator + "local" + File.separator + "fabric";
    @Reference(referenceInterface=RuntimeProperties.class)
    private final ValidatingReference<RuntimeProperties> runtimeProperties = new ValidatingReference();
    @Reference(referenceInterface=BootstrapConfiguration.class)
    private final ValidatingReference<BootstrapConfiguration> bootstrapConfiguration = new ValidatingReference();
    private final List<GitListener> listeners = new CopyOnWriteArrayList<GitListener>();
    private File localRepo;
    private volatile String remoteUrl;
    private volatile Git git;

    @VisibleForTesting
    @Activate
    public void activate() throws IOException {
        RuntimeProperties sysprops = (RuntimeProperties)this.runtimeProperties.get();
        this.localRepo = sysprops.getDataPath().resolve(DEFAULT_GIT_PATH).toFile();
        if (!this.localRepo.exists() && !this.localRepo.mkdirs()) {
            throw new IOException("Failed to create local repository at:" + this.localRepo.getAbsolutePath());
        }
        this.git = this.openOrInit(this.localRepo);
        this.activateComponent();
    }

    @Deactivate
    void deactivate() {
        this.deactivateComponent();
        RepositoryCache.clear();
        this.git.status().getRepository().close();
    }

    private Git openOrInit(File localRepo) throws IOException {
        try {
            return Git.open(localRepo);
        }
        catch (RepositoryNotFoundException e) {
            try {
                return Git.init().setDirectory(localRepo).setGitDir(new File(localRepo, ".git")).call();
            }
            catch (GitAPIException ex) {
                throw new IOException(ex);
            }
        }
    }

    @Override
    public Git getGit() {
        this.assertValid();
        return this.git;
    }

    @Override
    public String getRemoteUrl() {
        this.assertValid();
        return this.remoteUrl;
    }

    @Override
    public void notifyRemoteChanged(String remoteUrl) {
        this.remoteUrl = remoteUrl;
        LinkedList<GitListener> localListeners = new LinkedList<GitListener>(this.listeners);
        if (localListeners.size() == 0) {
            LOG.info("No GitListeners registered yet");
        }
        for (GitListener listener : localListeners) {
            LOG.debug("Calling " + listener.getClass().getName() + ".onRemoteUrlChanged(" + remoteUrl + ")");
            listener.onRemoteUrlChanged(remoteUrl);
        }
    }

    @Override
    public void notifyReceivePacket() {
        for (GitListener listener : this.listeners) {
            listener.onReceivePack();
        }
    }

    @Override
    public void addGitListener(GitListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeGitListener(GitListener listener) {
        this.listeners.remove(listener);
    }

    @VisibleForTesting
    public void setGitForTesting(Git git) {
        this.git = git;
    }

    @VisibleForTesting
    public void bindRuntimeProperties(RuntimeProperties service) {
        this.runtimeProperties.bind((Object)service);
    }

    void unbindRuntimeProperties(RuntimeProperties service) {
        this.runtimeProperties.unbind((Object)service);
    }

    void bindBootstrapConfiguration(BootstrapConfiguration service) {
        this.bootstrapConfiguration.bind((Object)service);
    }

    void unbindBootstrapConfiguration(BootstrapConfiguration service) {
        this.bootstrapConfiguration.unbind((Object)service);
    }
}

