/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.partition.internal;

import io.fabric8.api.jcip.ThreadSafe;
import io.fabric8.api.scr.AbstractComponent;
import io.fabric8.partition.TaskContext;
import io.fabric8.partition.WorkItem;
import io.fabric8.partition.Worker;
import java.util.Set;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
@Component(name="io.fabric8.partition.worker.logging", label="Fabric8 Logging Partition Worker", immediate=true, metatype=false)
@Service(value={Worker.class})
@Properties(value={@Property(name="type", value={"logging"})})
public final class LoggingWorker
extends AbstractComponent
implements Worker {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoggingWorker.class);
    public static final String TYPE = "logging";

    @Activate
    void activate() {
        this.activateComponent();
    }

    @Deactivate
    void deactivate() {
        this.deactivateComponent();
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public void assign(TaskContext context, Set<WorkItem> workItems) {
        this.assertValid();
        for (WorkItem workItem : workItems) {
            LOGGER.info("Start taskId: {}, partition: {}.", (Object)context.getId(), (Object)workItem.getId());
        }
    }

    @Override
    public void release(TaskContext context, Set<WorkItem> workItems) {
        this.assertValid();
        for (WorkItem workItem : workItems) {
            LOGGER.info("Stop taskId: {}, partition: {}.", (Object)context.getId(), (Object)workItem.getId());
        }
    }

    @Override
    public void stop(TaskContext context) {
    }

    @Override
    public void stopAll() {
    }
}

