/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.partition.internal;

import com.google.common.base.Function;
import com.google.common.base.Throwables;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import io.fabric8.api.FabricException;
import io.fabric8.partition.TaskContext;
import io.fabric8.partition.WorkItem;
import io.fabric8.partition.WorkItemRepository;
import io.fabric8.partition.Worker;
import io.fabric8.partition.WorkerNode;
import io.fabric8.zookeeper.ZkPath;
import io.fabric8.zookeeper.utils.ZooKeeperUtils;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.cache.NodeCache;
import org.apache.curator.framework.recipes.cache.NodeCacheListener;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.type.TypeReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskHandler
implements NodeCacheListener {
    private final Logger LOGGER = LoggerFactory.getLogger(TaskHandler.class);
    private final ObjectMapper mapper = new ObjectMapper();
    private final TypeReference<HashMap<String, String>> partitionTypeRef = new TypeReference<HashMap<String, String>>(){};
    private final Set<WorkItem> assignedWorkItems = new LinkedHashSet<WorkItem>();
    private final CuratorFramework curator;
    private final NodeCache cache;
    private final Worker worker;
    private final WorkItemRepository repository;
    private final TaskContext context;
    private final String workerPath;
    private final String name;

    public TaskHandler(String name, TaskContext context, CuratorFramework curator, Worker worker, WorkItemRepository repository) {
        this.name = name;
        this.context = context;
        this.curator = curator;
        this.worker = worker;
        this.repository = repository;
        this.workerPath = ZkPath.TASK_MEMBER_PARTITIONS.getPath(new String[]{name, context.getId()});
        this.cache = new NodeCache(curator, this.workerPath);
    }

    public void start() {
        try {
            ZooKeeperUtils.createDefault((CuratorFramework)this.curator, (String)this.workerPath, null);
            this.cache.getListenable().addListener((Object)this);
            this.cache.start(true);
            this.cache.rebuild();
        }
        catch (Exception e) {
            throw FabricException.launderThrowable((Throwable)e);
        }
    }

    public void stop() {
        this.worker.stop(this.context);
        this.cache.getListenable().removeListener((Object)this);
        try {
            this.cache.close();
        }
        catch (IOException e) {
            throw FabricException.launderThrowable((Throwable)e);
        }
    }

    public synchronized void nodeChanged() throws Exception {
        this.LOGGER.info("Task Handler for {} detected change.", (Object)this.context.getId());
        WorkerNode node = this.readWorkerNode();
        Set<WorkItem> workItems = this.listWorkItemsOfNode(node);
        LinkedHashSet<WorkItem> added = new LinkedHashSet<WorkItem>((Collection<WorkItem>)Sets.difference(workItems, this.assignedWorkItems));
        LinkedHashSet<WorkItem> removed = new LinkedHashSet<WorkItem>((Collection<WorkItem>)Sets.difference(this.assignedWorkItems, workItems));
        this.assignedWorkItems.addAll(added);
        this.assignedWorkItems.removeAll(removed);
        this.LOGGER.info("Releasing work items: {}.", removed.toArray());
        this.worker.release(this.context, removed);
        this.LOGGER.info("Assigning work items: {}.", added.toArray());
        this.worker.assign(this.context, added);
    }

    WorkerNode readWorkerNode() {
        WorkerNode node;
        String fullPath = ZkPath.TASK_MEMBER_PARTITIONS.getPath(new String[]{this.name, this.context.getId()});
        try {
            byte[] bytes = (byte[])this.curator.getData().forPath(fullPath);
            node = bytes != null ? (WorkerNode)((Object)this.mapper.readValue(bytes, WorkerNode.class)) : this.createNode();
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
        return node;
    }

    WorkerNode createNode() {
        WorkerNode state = new WorkerNode(this.context.getId());
        return state;
    }

    private Set<WorkItem> listWorkItemsOfNode(WorkerNode node) {
        HashSet locations = node.getItems() != null ? Sets.newHashSet((Object[])node.getItems()) : Sets.newHashSet();
        return Sets.newHashSet((Iterable)Iterables.transform((Iterable)locations, (Function)new Function<String, WorkItem>(){

            public WorkItem apply(String input) {
                return TaskHandler.this.repository.readWorkItem(input);
            }
        }));
    }
}

