/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.deployer;

import io.fabric8.agent.download.DownloadManager;
import io.fabric8.agent.download.DownloadManagers;
import io.fabric8.agent.utils.AgentUtils;
import io.fabric8.api.Container;
import io.fabric8.api.FabricService;
import io.fabric8.api.Profile;
import io.fabric8.api.ProfileService;
import io.fabric8.common.util.MultiException;
import io.fabric8.common.util.Objects;
import io.fabric8.common.util.Strings;
import io.fabric8.deployer.dto.DependencyDTO;
import io.fabric8.deployer.dto.DtoHelper;
import io.fabric8.deployer.dto.ProjectRequirements;
import io.fabric8.maven.util.Parser;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ScheduledExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaContainers {
    private static final transient Logger LOGGER = LoggerFactory.getLogger(JavaContainers.class);

    public static Map<String, Parser> getJavaContainerArtifacts(FabricService fabric, List<Profile> profileList, ScheduledExecutorService downloadExecutor) throws Exception {
        DownloadManager downloadManager = DownloadManagers.createDownloadManager((FabricService)fabric, (ScheduledExecutorService)downloadExecutor);
        return JavaContainers.getJavaContainerArtifacts(fabric, profileList, downloadManager);
    }

    public static Map<String, Parser> getJavaContainerArtifacts(FabricService fabric, List<Profile> profileList, DownloadManager downloadManager) throws Exception {
        TreeMap<String, Parser> artifacts = new TreeMap<String, Parser>();
        for (Profile profile : profileList) {
            Map profileArtifacts = AgentUtils.getProfileArtifacts((FabricService)fabric, (DownloadManager)downloadManager, (Profile)profile);
            artifacts.putAll(profileArtifacts);
            JavaContainers.appendMavenDependencies(artifacts, profile);
        }
        return artifacts;
    }

    public static Map<String, File> getJavaContainerArtifactsFiles(FabricService fabricService, List<Profile> profileList, ScheduledExecutorService downloadExecutor) throws Exception {
        DownloadManager downloadManager = DownloadManagers.createDownloadManager((FabricService)fabricService, (ScheduledExecutorService)downloadExecutor);
        return JavaContainers.getJavaContainerArtifactsFiles(fabricService, profileList, downloadManager);
    }

    public static Map<String, File> getJavaContainerArtifactsFiles(FabricService fabricService, List<Profile> profileList, DownloadManager downloadManager) throws Exception {
        HashMap<String, File> answer = new HashMap<String, File>();
        ProfileService profileService = (ProfileService)fabricService.adapt(ProfileService.class);
        for (Profile profile : profileList) {
            Profile overlay = profileService.getOverlayProfile(profile);
            Map profileArtifacts = AgentUtils.getProfileArtifacts((FabricService)fabricService, (DownloadManager)downloadManager, (Profile)overlay);
            JavaContainers.appendMavenDependencies(profileArtifacts, profile);
            Set<String> rawUrls = profileArtifacts.keySet();
            JavaContainers.downloadArtifactUrls(downloadManager, rawUrls, answer);
        }
        return answer;
    }

    public static void downloadArtifactUrls(DownloadManager downloadManager, Set<String> rawUrls, Map<String, File> answer) throws MalformedURLException, InterruptedException, MultiException {
        ArrayList<String> cleanUrlsToDownload = new ArrayList<String>();
        for (String rawUrl : rawUrls) {
            String mvnUrl = JavaContainers.removeUriPrefixBeforeMaven(rawUrl);
            cleanUrlsToDownload.add(mvnUrl);
        }
        Map profileFiles = AgentUtils.downloadLocations((DownloadManager)downloadManager, cleanUrlsToDownload);
        if (profileFiles != null) {
            answer.putAll(profileFiles);
        }
    }

    public static String removeUriPrefixBeforeMaven(String rawUrl) {
        String answer = rawUrl;
        int idx = answer.indexOf(":mvn:");
        if (idx > 0) {
            answer = answer.substring(idx + 1);
        }
        return answer;
    }

    protected static void appendMavenDependencies(Map<String, Parser> artifacts, Profile profile) {
        Set configurationFileNames = profile.getConfigurationFileNames();
        for (String configurationFileName : configurationFileNames) {
            if (!configurationFileName.startsWith("dependencies/") || !configurationFileName.endsWith("-requirements.json")) continue;
            byte[] data = profile.getFileConfiguration(configurationFileName);
            try {
                DependencyDTO rootDependency;
                ProjectRequirements requirements = (ProjectRequirements)DtoHelper.getMapper().readValue(data, ProjectRequirements.class);
                if (requirements == null || (rootDependency = requirements.getRootDependency()) == null) continue;
                JavaContainers.addMavenDependencies(artifacts, rootDependency);
            }
            catch (IOException e) {
                LOGGER.error("Failed to parse project requirements from " + configurationFileName + ". " + e, (Throwable)e);
            }
        }
    }

    protected static void addMavenDependencies(Map<String, Parser> artifacts, DependencyDTO dependency) throws MalformedURLException {
        List<DependencyDTO> children;
        String url = dependency.toBundleUrlWithType();
        Parser parser = Parser.parsePathWithSchemePrefix((String)url);
        String scope = dependency.getScope();
        if (!(artifacts.containsKey(url) || artifacts.containsValue(parser) || Objects.equal((Object)"test", (Object)scope))) {
            LOGGER.debug("Adding url: " + url + " parser: " + parser);
            artifacts.put(url, parser);
        }
        if ((children = dependency.getChildren()) != null) {
            for (DependencyDTO child : children) {
                JavaContainers.addMavenDependencies(artifacts, child);
            }
        }
    }

    public static void registerJolokiaUrl(Container container, String jolokiaUrl) {
        String currentUrl;
        if (Strings.isNotBlank((String)jolokiaUrl) && !Objects.equal((Object)jolokiaUrl, (Object)(currentUrl = container.getJolokiaUrl()))) {
            container.setJolokiaUrl(jolokiaUrl);
        }
    }
}

