/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.features.command;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.apache.karaf.features.FeaturesService;
import org.apache.karaf.features.command.FeaturesCommandSupport;
import org.apache.karaf.shell.console.MultiException;

@Command(scope="features", name="addUrl", description="Adds a list of repository URLs to the features service")
public class AddUrlCommand
extends FeaturesCommandSupport {
    @Argument(index=0, name="urls", description="One or more repository URLs separated by whitespaces", required=true, multiValued=true)
    List<String> urls;
    @Option(name="-i", aliases={"--install-all"}, description="Install all features contained in the repository URLs", required=false, multiValued=false)
    boolean install;

    @Override
    protected void doExecute(FeaturesService admin) throws Exception {
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        for (String url : this.urls) {
            try {
                admin.addRepository(new URI(url), this.install);
            }
            catch (Exception e) {
                exceptions.add(e);
            }
        }
        MultiException.throwIf((String)"Unable to add repositories", exceptions);
    }
}

