/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.features.command;

import java.util.EnumSet;
import java.util.List;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.apache.karaf.features.FeaturesService;
import org.apache.karaf.features.command.FeaturesCommandSupport;

@Command(scope="features", name="uninstall", description="Uninstalls a feature with the specified name and version.")
public class UninstallFeatureCommand
extends FeaturesCommandSupport {
    @Argument(index=0, name="features", description="The name and version of the features to uninstall. A feature id looks like name/version. The version is optional.", required=true, multiValued=true)
    List<String> features;
    @Option(name="-r", aliases={"--no-auto-refresh"}, description="Do not automatically refresh bundles", required=false, multiValued=false)
    boolean noRefresh;
    @Option(name="-v", aliases={"--verbose"}, description="Explain what is being done", required=false, multiValued=false)
    boolean verbose;

    @Override
    protected void doExecute(FeaturesService admin) throws Exception {
        EnumSet<FeaturesService.Option> options = EnumSet.noneOf(FeaturesService.Option.class);
        if (this.noRefresh) {
            options.add(FeaturesService.Option.NoAutoRefreshBundles);
        }
        if (this.verbose) {
            options.add(FeaturesService.Option.Verbose);
        }
        for (String feature : this.features) {
            String[] split = feature.split("/");
            String name = split[0];
            String version = null;
            if (split.length == 2) {
                version = split[1];
            }
            if (version != null && version.length() > 0) {
                admin.uninstallFeature(name, version, options);
                continue;
            }
            admin.uninstallFeature(name, options);
        }
    }
}

