/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.util.properties;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;
import org.apache.felix.utils.properties.Properties;

public final class FileLockUtils {
    private FileLockUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void execute(File file, Runnable callback) throws IOException {
        try (RandomAccessFile raf = new RandomAccessFile(file, "rw");){
            FileLock lock = raf.getChannel().lock();
            try {
                callback.run(raf);
            }
            finally {
                lock.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T execute(File file, Callable<T> callback) throws IOException {
        try (RandomAccessFile raf = new RandomAccessFile(file, "rw");){
            T t;
            FileLock lock = raf.getChannel().lock();
            try {
                t = callback.call(raf);
            }
            catch (Throwable throwable) {
                lock.release();
                throw throwable;
            }
            lock.release();
            return t;
        }
    }

    public static void execute(File file, final RunnableWithProperties callback, final boolean writeToFile) throws IOException {
        FileLockUtils.execute(file, new Runnable(){

            @Override
            public void run(RandomAccessFile file) throws IOException {
                byte[] buffer = new byte[(int)file.length()];
                file.readFully(buffer);
                Properties props = new Properties();
                props.load(new ByteArrayInputStream(buffer));
                callback.run(props);
                if (writeToFile) {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    props.store(baos, null);
                    file.setLength(0L);
                    file.write(baos.toByteArray());
                }
            }
        });
    }

    public static <T> T execute(File file, final CallableWithProperties<T> callback, final boolean writeToFile) throws IOException {
        return FileLockUtils.execute(file, new Callable<T>(){

            @Override
            public T call(RandomAccessFile file) throws IOException {
                byte[] buffer = new byte[(int)file.length()];
                file.readFully(buffer);
                Properties props = new Properties();
                props.load(new ByteArrayInputStream(buffer));
                Object result = callback.call(props);
                if (writeToFile) {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    props.store(baos, null);
                    file.setLength(0L);
                    file.write(baos.toByteArray());
                }
                return result;
            }
        });
    }

    public static interface CallableWithProperties<T> {
        public T call(Properties var1) throws IOException;
    }

    public static interface RunnableWithProperties {
        public void run(Properties var1) throws IOException;
    }

    public static interface Callable<T> {
        public T call(RandomAccessFile var1) throws IOException;
    }

    public static interface Runnable {
        public void run(RandomAccessFile var1) throws IOException;
    }
}

