/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.deployer.dto;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import io.fabric8.common.util.Strings;
import io.fabric8.deployer.dto.ProjectRequirements;

public class DtoHelper {
    private static ObjectMapper mapper = new ObjectMapper();

    public static ObjectMapper getMapper() {
        return mapper;
    }

    public static String getRequirementsConfigFileName(ProjectRequirements requirements) {
        String artifactId;
        StringBuilder builder = new StringBuilder("dependencies/");
        String groupId = requirements.getGroupId();
        if (!Strings.isEmpty((String)groupId)) {
            builder.append(groupId);
            builder.append("/");
        }
        if (!Strings.isEmpty((String)(artifactId = requirements.getArtifactId()))) {
            builder.append(artifactId);
            builder.append("-");
        }
        builder.append("requirements.json");
        return builder.toString();
    }

    static {
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.configure(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY, true);
        mapper.configure(SerializationFeature.INDENT_OUTPUT, true);
        mapper.configure(SerializationFeature.WRITE_NULL_MAP_VALUES, false);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
    }
}

