/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.ssl;

import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public class SSLContextBundleActivator
implements BundleActivator {
    SSLContext original;

    public void start(BundleContext bundleContext) throws Exception {
        String trustStore = System.getProperty("javax.net.ssl.trustStore");
        boolean trustAll = Boolean.getBoolean("javax.net.ssl.trustAll");
        boolean enabled = false;
        if (trustStore == null && trustAll) {
            this.original = SSLContext.getDefault();
            SSLContext ctx = SSLContext.getInstance("TLS");
            ctx.init(this.createKeyManagers(), this.trustAllCerts(), new SecureRandom());
            SSLContext.setDefault(ctx);
        } else if (trustStore != null && trustAll) {
            System.err.println();
            System.err.println("Invalid system property configuration:  The javax.net.ssl.trustStore and javax.net.ssl.trustAll cannot both be set.  Ignoring the javax.net.ssl.trustAll property");
            System.err.println();
        }
    }

    public void stop(BundleContext bundleContext) throws Exception {
        if (this.original != null) {
            SSLContext.setDefault(this.original);
            this.original = null;
        }
    }

    private KeyManager[] createKeyManagers() throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException, UnrecoverableKeyException {
        String keystore = System.getProperty("javax.net.ssl.keyStore");
        KeyManager[] keyManagers = null;
        if (keystore != null) {
            char[] password = System.getProperty("javax.net.ssl.keyStorePassword", "").toCharArray();
            String type = System.getProperty("javax.net.ssl.keyStoreType", "jks");
            KeyStore store = KeyStore.getInstance(type);
            store.load(new FileInputStream(keystore), password);
            KeyManagerFactory factory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            factory.init(store, password);
            keyManagers = factory.getKeyManagers();
        }
        return keyManagers;
    }

    private TrustManager[] trustAllCerts() {
        return new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
    }
}

