/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.protocols;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import org.osgi.framework.BundleContext;
import org.osgi.service.url.AbstractURLStreamHandlerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ProfileSafeUrlHandler
extends AbstractURLStreamHandlerService {
    private static final String SYNTAX = "profile:<resource name>";
    public static final Logger LOGGER = LoggerFactory.getLogger(ProfileSafeUrlHandler.class);
    private BundleContext context;
    static int[] SLEEPS = new int[]{1000, 1000, 2000, 2000, 2000, 4000, 4000, 4000};

    public URLConnection openConnection(URL url) throws IOException {
        return new Connection(url);
    }

    private class Connection
    extends URLConnection {
        public Connection(URL url) throws MalformedURLException {
            super(url);
            if (url.getPath() == null || url.getPath().trim().length() == 0) {
                throw new MalformedURLException("Path can not be null or empty. Syntax: profile:<resource name>");
            }
            if (url.getHost() != null && url.getHost().length() > 0 || url.getPort() != -1) {
                throw new MalformedURLException("Unsupported host/port in profile url");
            }
            if (url.getQuery() != null && url.getQuery().length() > 0) {
                throw new MalformedURLException("Unsupported query in profile url");
            }
        }

        @Override
        public void connect() throws IOException {
        }

        @Override
        public InputStream getInputStream() throws IOException {
            int count = 0;
            IOException lastException = null;
            while (count < SLEEPS.length) {
                try {
                    if (count == 0) {
                        LOGGER.debug("Resolving {}", (Object)this.url);
                    } else {
                        LOGGER.debug("Resolving {}, attempt {}", (Object)this.url, (Object)(count + 1));
                    }
                    return new URL("profile2:" + this.url.getPath()).openStream();
                }
                catch (MalformedURLException e) {
                    lastException = e;
                }
                catch (IllegalStateException e) {
                    if (e.getMessage() != null && e.getMessage().equals("Unknown protocol: profile2")) {
                        lastException = new IOException(e);
                    }
                }
                catch (IOException e) {
                    if (e.getMessage() != null && e.getMessage().startsWith("URL [profile2:")) {
                        lastException = e;
                    }
                    throw e;
                }
                try {
                    Thread.sleep(SLEEPS[count++]);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new IOException("Thread interrupted while trying to resolve " + this.url);
                }
            }
            if (lastException != null) {
                throw lastException;
            }
            throw new MalformedURLException("Can't resolve " + this.url + " after " + SLEEPS.length + " attempts");
        }
    }
}

