/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.zookeeper.commands;

import io.fabric8.zookeeper.commands.ZooKeeperCommandSupport;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.framework.api.BackgroundPathAndBytesable;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooDefs;

@Command(name="create", scope="zk", description="Create a znode", detailedDescription="classpath:create.txt")
public class Create
extends ZooKeeperCommandSupport {
    @Option(name="-e", aliases={"--ephemeral"}, description="Make the new znode epehemeral, so that it is automatically deleted after the current ZooKeeper client session closes.")
    boolean ephemeral;
    @Option(name="-s", aliases={"--sequential"}, description="Make the new znode sequential, so that a unique 10-digit suffix is appended to the znode name.")
    boolean sequential;
    @Option(name="-r", aliases={"--recursive"}, description="Automatically create any missing parent znodes in the specified path.")
    boolean recursive;
    @Option(name="-i", aliases={"--import"}, description="Interpret the data argument as a URL that locates a resource containing the initial data for the new znode.")
    boolean importUrl;
    @Option(name="-a", aliases={"--acl"}, description="Specifies the znode's ACL as a comma-separated list, where each entry in the list has the format, <Scheme>:<ID>:<Permissions>. The <Permissions> string consists of the following characters, concatenated in any order: r (read), w (write), c (create), d (delete), and a (admin).")
    String acl;
    @Option(name="-o", aliases={"--overwrite"}, description="Overwrite the existing znode at this location, if there is one.")
    boolean overwrite;
    @Argument(index=0, required=true, description="Path of the node to create")
    String path;
    @Argument(index=1, required=false, description="Initial data for the node or, if --import is specified, a URL pointing at a location that contains the initial data.")
    String data;

    @Override
    protected void doExecute(CuratorFramework curator) throws Exception {
        ArrayList acls;
        List<Object> list = acls = this.acl == null ? ZooDefs.Ids.OPEN_ACL_UNSAFE : Create.parseACLs(this.acl);
        CreateMode mode = this.ephemeral && this.sequential ? CreateMode.EPHEMERAL_SEQUENTIAL : (this.ephemeral ? CreateMode.EPHEMERAL : (this.sequential ? CreateMode.PERSISTENT_SEQUENTIAL : CreateMode.PERSISTENT));
        String nodeData = this.data;
        if (this.importUrl) {
            nodeData = this.loadUrl(new URL(this.data));
        }
        try {
            if (this.recursive) {
                ((BackgroundPathAndBytesable)((ACLBackgroundPathAndBytesable)curator.create().creatingParentsIfNeeded().withMode(mode)).withACL((List)acls)).forPath(this.path, nodeData.getBytes());
            } else {
                ((BackgroundPathAndBytesable)((ACLBackgroundPathAndBytesable)curator.create().withMode(mode)).withACL((List)acls)).forPath(this.path, nodeData.getBytes());
            }
        }
        catch (KeeperException.NodeExistsException e) {
            if (this.overwrite) {
                curator.setData().forPath(this.path, nodeData.getBytes());
            }
            throw e;
        }
    }
}

