/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.boot.commands;

import io.fabric8.api.Container;
import io.fabric8.api.FabricService;
import io.fabric8.api.RuntimeProperties;
import org.apache.felix.gogo.commands.Command;
import org.apache.karaf.shell.console.AbstractAction;
import org.osgi.framework.BundleContext;
import org.osgi.service.cm.ConfigurationAdmin;

@Command(name="welcome", scope="fabric", description="Prints the Fabric welcome message")
final class WelcomeAction
extends AbstractAction {
    private final FabricService fabricService;
    private final ConfigurationAdmin configAdmin;
    private final BundleContext bundleContext;
    private final RuntimeProperties runtimeProperties;

    WelcomeAction(BundleContext bundleContext, FabricService fabricService, ConfigurationAdmin configAdmin, RuntimeProperties runtimeProperties) {
        this.bundleContext = bundleContext;
        this.fabricService = fabricService;
        this.configAdmin = configAdmin;
        this.runtimeProperties = runtimeProperties;
    }

    protected Object doExecute() throws Exception {
        String name = this.runtimeProperties.getRuntimeIdentity();
        String appName = this.runtimeProperties.getProperty("karaf.app.name");
        System.out.println("Welcome to " + appName);
        System.out.println("");
        if (this.fabricService != null) {
            Container container = this.fabricService.getCurrentContainer();
            if (container != null) {
                boolean ensemble = container.isEnsembleServer();
                if (ensemble) {
                    System.out.println("This container \u001b[1m" + container.getId() + "\u001b[0m is a Fabric ensemble server.");
                } else {
                    System.out.println("This container \u001b[1m" + container.getId() + "\u001b[0m is joined to an existing Fabric.");
                }
            } else {
                System.out.println("This container \u001b[1m" + name + "\u001b[0m is a standalone container.");
            }
            String url = this.fabricService.getWebConsoleUrl();
            if (url != null) {
                System.out.println("Web management console available at: \u001b[1m" + url + "\u001b[0m");
            }
            System.out.println("");
        } else {
            System.out.println("This container \u001b[1m" + name + "\u001b[0m is a standalone container.");
            System.out.println("");
            System.out.println("Create a new Fabric via '\u001b[1mfabric:create\u001b[0m'");
            System.out.println("or join an existing Fabric via '\u001b[1mfabric:join [someUrls]\u001b[0m'");
            System.out.println("");
        }
        return null;
    }
}

