/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.zookeeper.commands;

import io.fabric8.zookeeper.commands.ZooKeeperCommandSupport;
import java.net.URL;
import org.apache.curator.framework.CuratorFramework;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;

@Command(name="set", scope="zk", description="Set a znode's data", detailedDescription="classpath:set.txt")
public class SetAction
extends ZooKeeperCommandSupport {
    @Option(name="-i", aliases={"--import"}, description="Import data from a URL")
    boolean importUrl;
    @Argument(description="Path of the znode to set", index=0)
    String path;
    @Argument(description="The new data or URL, if the '--import' option is specified", index=1)
    String data;

    SetAction(CuratorFramework curator) {
        this.setCurator(curator);
    }

    @Override
    protected void doExecute(CuratorFramework curator) throws Exception {
        String nodeData = this.data;
        if (this.importUrl) {
            nodeData = this.loadUrl(new URL(this.data));
        }
        curator.setData().forPath(this.path, nodeData.getBytes());
    }
}

