/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.zookeeper.commands;

import io.fabric8.zookeeper.commands.ZooKeeperCommandSupport;
import io.fabric8.zookeeper.utils.RegexSupport;
import io.fabric8.zookeeper.utils.ZooKeeperUtils;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.apache.curator.framework.CuratorFramework;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;

@Command(name="export", scope="zk", description="Export the contents of the fabric registry to the specified directory in the filesystem", detailedDescription="classpath:export.txt")
public class ExportAction
extends ZooKeeperCommandSupport {
    @Argument(description="Path of the directory to export to")
    String target = System.getProperty("runtime.home") + File.separator + "fabric" + File.separator + "export";
    @Option(name="-f", aliases={"--regex"}, description="Specifies a regular expression that matches the znode paths you want to include in the export. For multiple include expressions, use this option multiple times. The regular expression syntax is defined by the java.util.regex package.", multiValued=true)
    String[] regex;
    @Option(name="-rf", aliases={"--reverse-regex"}, description="Specifies a regular expression that matches the znode paths you want to exclude from the export. For multiple exclude expressions, use this option multiple times. The regular expression syntax is defined by the java.util.regex package.", multiValued=true)
    String[] nregex;
    @Option(name="-p", aliases={"--path"}, description="Top level znode to export")
    String topLevel = "/";
    @Option(name="-d", aliases={"--delete"}, description="Delete the existing contents of the target directory before exporting. CAUTION: Performs a recursive delete! ")
    boolean delete;
    @Option(name="-t", aliases={"--trim"}, description="Trims the first timestamp comment line in properties files starting with the '#' character")
    boolean trimHeader;
    @Option(name="--dry-run", description="Log the actions that would be performed during an export, but do not actually perform the export.")
    boolean dryRun = false;
    File ignore = new File(".fabricignore");
    File include = new File(".fabricinclude");
    private final CuratorFramework curator;

    ExportAction(CuratorFramework curator) {
        this.curator = curator;
    }

    @Override
    public CuratorFramework getCurator() {
        return this.curator;
    }

    @Override
    protected void doExecute(CuratorFramework curator) throws Exception {
        this.nregex = RegexSupport.merge((File)this.ignore, (String[])this.nregex);
        this.regex = RegexSupport.merge((File)this.include, (String[])this.regex);
        this.export(curator, this.topLevel);
    }

    private void delete(File parent) throws Exception {
        if (!parent.exists()) {
            return;
        }
        if (parent.isDirectory()) {
            for (File f : parent.listFiles()) {
                this.delete(f);
            }
        }
        parent.delete();
    }

    protected void export(CuratorFramework curator, String path) throws Exception {
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        List include = RegexSupport.getPatterns((String[])this.regex);
        List exclude = RegexSupport.getPatterns((String[])this.nregex);
        List paths = ZooKeeperUtils.getAllChildren((CuratorFramework)curator, (String)path);
        TreeSet<File> directories = new TreeSet<File>();
        HashMap<File, String> settings = new HashMap<File, String>();
        boolean founMatch = false;
        for (String p : paths) {
            if (!RegexSupport.matches((List)include, (String)p, (boolean)true) || RegexSupport.matches((List)exclude, (String)p, (boolean)false)) continue;
            founMatch = true;
            byte[] data = (byte[])curator.getData().forPath(p);
            String name = p;
            if (name.contains("/*")) {
                name = name.replaceAll(Pattern.quote("/*"), "/__asterisk__");
            }
            if (data != null && data.length > 0) {
                int idx;
                if (!p.contains(".") || p.endsWith("fabric-ensemble")) {
                    name = name + ".cfg";
                }
                String value = new String(data);
                if (this.trimHeader && value.startsWith("#") && (idx = value.indexOf("\n")) > 0) {
                    value = value.substring(idx + 1);
                }
                settings.put(new File(this.target + File.separator + name), value);
                continue;
            }
            directories.add(new File(this.target + File.separator + name));
        }
        if (!founMatch) {
            System.out.println("No entry matched the criteria.");
            return;
        }
        if (this.delete) {
            if (!this.dryRun) {
                this.delete(new File(this.target));
            } else {
                System.out.printf("Deleting %s and everything under it\n", new File(this.target));
            }
        }
        for (File d : directories) {
            if (d.exists() && !d.isDirectory()) {
                throw new IllegalArgumentException("Directory " + d + " exists but is not a directory");
            }
            if (d.exists()) continue;
            if (!this.dryRun) {
                if (d.mkdirs()) continue;
                throw new RuntimeException("Failed to create directory " + d);
            }
            System.out.printf("Creating directory path : %s\n", d);
        }
        for (File f : settings.keySet()) {
            if (f.exists() && !f.isFile()) {
                throw new IllegalArgumentException("File " + f + " exists but is not a file");
            }
            if (!f.getParentFile().exists()) {
                if (!this.dryRun) {
                    if (!f.getParentFile().mkdirs()) {
                        throw new RuntimeException("Failed to create directory " + f.getParentFile());
                    }
                } else {
                    System.out.printf("Creating directory path : %s\n", f);
                }
            }
            if (!f.exists()) {
                try {
                    if (!this.dryRun) {
                        if (!f.createNewFile()) {
                            throw new RuntimeException("Failed to create file " + f);
                        }
                    } else {
                        System.out.printf("Creating file : %s\n", f);
                    }
                }
                catch (IOException io) {
                    throw new RuntimeException("Failed to create file " + f + " : " + io);
                }
            }
            if (!this.dryRun) {
                FileWriter writer = new FileWriter(f, false);
                writer.write((String)settings.get(f));
                writer.close();
                continue;
            }
            System.out.printf("Writing value \"%s\" to file : %s\n", settings.get(f), f);
        }
        System.out.printf("Export to %s completed successfully\n", this.target);
    }

    @Override
    protected Object doExecute() throws Exception {
        this.doExecute(this.getCurator());
        return null;
    }
}

