/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.zookeeper.commands;

import io.fabric8.commands.support.ZookeeperContentManager;
import io.fabric8.zookeeper.commands.ZooKeeperCommandSupport;
import io.fabric8.zookeeper.utils.ZooKeeperUtils;
import java.util.List;
import jline.Terminal;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.BackgroundPathAndBytesable;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.zookeeper.ZooDefs;
import org.jledit.ConsoleEditor;
import org.jledit.ContentManager;
import org.jledit.EditorFactory;

@Command(name="edit", scope="zk", description="Edits a znode's data", detailedDescription="classpath:edit.txt")
public class EditAction
extends ZooKeeperCommandSupport {
    @Argument(description="Path of the znode to get")
    String path;
    private EditorFactory editorFactory;

    EditAction(CuratorFramework curator, EditorFactory editorFactory) {
        this.setCurator(curator);
        this.setEditorFactory(editorFactory);
    }

    @Override
    protected void doExecute(CuratorFramework curator) throws Exception {
        if (ZooKeeperUtils.exists((CuratorFramework)curator, (String)this.path) == null) {
            ((BackgroundPathAndBytesable)curator.create().creatingParentsIfNeeded().withACL((List)ZooDefs.Ids.OPEN_ACL_UNSAFE)).forPath(this.path);
        }
        ConsoleEditor editor = this.editorFactory.create("simple", this.getTerminal(), System.in, System.out);
        editor.setTitle("Znode");
        editor.setContentManager((ContentManager)new ZookeeperContentManager(curator));
        editor.open(this.path);
        editor.setOpenEnabled(false);
        editor.start();
    }

    private Terminal getTerminal() throws Exception {
        Object terminalObject = this.session.get(".jline.terminal");
        if (terminalObject instanceof Terminal) {
            return (Terminal)terminalObject;
        }
        throw new IllegalStateException("Could not get Terminal from CommandSession.");
    }

    public EditorFactory getEditorFactory() {
        return this.editorFactory;
    }

    public void setEditorFactory(EditorFactory editorFactory) {
        this.editorFactory = editorFactory;
    }
}

