/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.zookeeper.commands;

import io.fabric8.zookeeper.commands.ZooKeeperCommandSupport;
import io.fabric8.zookeeper.utils.ZooKeeperUtils;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.BackgroundPathable;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;

@Command(name="delete", scope="zk", description="Delete the specified znode", detailedDescription="classpath:delete.txt")
public class DeleteAction
extends ZooKeeperCommandSupport {
    @Option(name="-v", aliases={"--version "}, description="The ZooKeeper version to delete. By default, delete all versions.")
    int version = -1;
    @Option(name="-r", aliases={"--recursive"}, description="Recursively delete children.")
    boolean recursive;
    @Argument(description="Path of the znode to delete")
    String path;

    DeleteAction(CuratorFramework curator) {
        this.setCurator(curator);
    }

    @Override
    protected void doExecute(CuratorFramework curator) throws Exception {
        if (this.recursive) {
            if (this.version >= 0) {
                throw new UnsupportedOperationException("Unable to delete a version recursively");
            }
            ZooKeeperUtils.deleteSafe((CuratorFramework)curator, (String)this.path);
        } else {
            ((BackgroundPathable)curator.delete().withVersion(this.version)).forPath(this.path);
        }
    }
}

