/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.zookeeper.bootstrap;

import io.fabric8.api.ContainerOptions;
import io.fabric8.api.CreateEnsembleOptions;
import io.fabric8.api.DataStoreTemplate;
import io.fabric8.api.RuntimeProperties;
import io.fabric8.api.jcip.ThreadSafe;
import io.fabric8.api.scr.AbstractComponent;
import io.fabric8.api.scr.Configurer;
import io.fabric8.api.scr.ValidatingReference;
import io.fabric8.common.util.Strings;
import io.fabric8.utils.HostUtils;
import io.fabric8.utils.PasswordEncoder;
import io.fabric8.utils.Ports;
import io.fabric8.zookeeper.bootstrap.DataStoreBootstrapTemplate;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Modified;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.felix.utils.properties.Properties;
import org.osgi.framework.BundleContext;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
@Component(name="io.fabric8.bootstrap.configuration", configurationPid="io.fabric8.bootstrap.configuration", policy=ConfigurationPolicy.OPTIONAL, label="Fabric8 Bootstrap Configuration", immediate=true, metatype=false)
@Service(value={BootstrapConfiguration.class})
public class BootstrapConfiguration
extends AbstractComponent {
    static final Logger LOGGER = LoggerFactory.getLogger(BootstrapConfiguration.class);
    public static final String ENSEMBLE_MARKER = "ensemble-created.properties";
    public static final String COMPONENT_PID = "io.fabric8.bootstrap.configuration";
    public static final String COMPONENT_NAME = "io.fabric8.bootstrap.configuration";
    public static final String DEFAULT_ADMIN_USER = "admin";
    public static final String DEFAULT_ADMIN_ROLE = "admin,manager,viewer";
    public static final String ROLE_DELIMITER = ",";
    @Reference
    private Configurer configurer;
    @Reference(referenceInterface=ConfigurationAdmin.class)
    private final ValidatingReference<ConfigurationAdmin> configAdmin = new ValidatingReference();
    @Reference(referenceInterface=RuntimeProperties.class, bind="bindRuntimeProperties", unbind="unbindRuntimeProperties")
    private final ValidatingReference<RuntimeProperties> runtimeProperties = new ValidatingReference();
    private CreateEnsembleOptions options;
    @Property(name="ensemble.auto.start", label="Ensemble Auto Start", description="Flag to automatically start a zookeeper ensemble", value={"${ensemble.auto.start}"})
    private boolean ensembleAutoStart;
    @Property(name="agent.auto.start", label="Agent Auto Start", description="Flag to automatically start the provisioning agent", value={"${agent.auto.start}"})
    private boolean agentAutoStart = true;
    @Property(name="bind.address", label="Bind Address", description="The Bind Address", value={"${bind.address}"})
    private String bindAddress = "0.0.0.0";
    @Property(name="zookeeper.password", label="ZooKeeper Password", description="The zookeeper password", value={"${zookeeper.password}"})
    private String zookeeperPassword = null;
    @Property(name="zookeeper.server.port", label="ZooKeeper Server Port", description="The zookeeper server binding port", value={"${zookeeper.server.port}"})
    private int zookeeperServerPort = 2181;
    @Property(name="zookeeper.server.connection.port", label="ZooKeeper Client Port", description="The zookeeper server connection port", value={"${zookeeper.server.connection.port}"})
    private int zookeeperServerConnectionPort = 2181;
    @Property(name="profiles.auto.import", label="Auto Import Enabled", description="Flag to automatically import the default profiles", value={"${profiles.auto.import}"})
    private boolean profilesAutoImport = true;
    @Property(name="profiles.auto.import.path", label="Auto Import Enabled", description="Flag to automatically import the default profiles", value={"${profiles.auto.import.path}"})
    private String profilesAutoImportPath = "fabric/import";
    @Property(name="profiles", value={"${profiles}"})
    private Set<String> profiles = Collections.emptySet();
    @Property(name="version", value={"${version}"})
    private String version = ContainerOptions.DEFAULT_VERSION;
    @Property(name="local.resolver", label="Resolver", description="The container resolver", value={"${local.resolver}"})
    private String localResolver;
    @Property(name="global.resolver", label="Global Resolver", description="The global resolver", value={"${global.resolver}"})
    private String globalResolver = "localhostname";
    @Property(name="manualip", label="Global Resolver", description="The manally set ip", value={"${manualip}"})
    private String manualip;
    @Property(name="publichostname", label="Public Hostname", description="The public hostname", value={"${publichostname}"})
    private String publichostname;
    @Property(name="runtime.id", label="Container Name", description="The name of the container", value={"${runtime.id}"}, propertyPrivate=true)
    private String runtimeId;
    @Property(name="homeDir", label="Container Home", description="The homeDir directory of the container", value={"${runtime.home}"}, propertyPrivate=true)
    private File homeDir;
    @Property(name="confDir", label="Container Conf", description="The configuration directory of the container", value={"${runtime.conf}"}, propertyPrivate=true)
    private File confDir;
    @Property(name="dataDir", label="Container Data Dir", description="The data directory of the container", value={"${runtime.data}"}, propertyPrivate=true)
    private File dataDir;
    @Property(name="zookeeper.url", label="ZooKeeper URL", description="The url to an existing zookeeper ensemble", value={"${zookeeper.url}"}, propertyPrivate=true)
    private String zookeeperUrl;
    @Property(name="minport", label="Min port", description="The smallest port to chose for services", value={"${minimum.port}"}, propertyPrivate=true)
    private int minport = 0;
    @Property(name="maxport", label="Max port", description="The largest port to chose for services", value={"${maximum.port}"}, propertyPrivate=true)
    private int maxport = 65535;
    private ComponentContext componentContext;
    private Map<String, ?> configuration;

    @Activate
    void activate(ComponentContext componentContext, Map<String, ?> conf) throws Exception {
        this.componentContext = componentContext;
        this.configureInternal(conf);
        this.bootIfNeeded();
        this.activateComponent();
    }

    @Modified
    void modified(Map<String, ?> conf) throws Exception {
        this.configureInternal(conf);
    }

    @Deactivate
    void deactivate() {
        this.deactivateComponent();
    }

    void configureInternal(Map<String, ?> conf) throws Exception {
        String maximumPort;
        String minimumPort;
        Configuration zkConfugiration;
        this.configuration = this.configurer.configure(conf, (Object)this, new String[0]);
        if (Strings.isNullOrBlank((String)this.runtimeId)) {
            throw new IllegalArgumentException("Runtime id must not be null or empty.");
        }
        if (Strings.isNullOrBlank((String)this.localResolver)) {
            this.localResolver = this.globalResolver;
        }
        String decodedZookeeperPassword = null;
        Properties userProps = new Properties();
        try {
            userProps.load(new File(this.confDir, "users.properties"));
        }
        catch (IOException e) {
            LOGGER.warn("Failed to load users from etc/users.properties. No users will be imported.", (Throwable)e);
        }
        if (Strings.isNotBlank((String)this.zookeeperPassword)) {
            decodedZookeeperPassword = PasswordEncoder.decode(this.zookeeperPassword);
        } else if (userProps.containsKey(DEFAULT_ADMIN_USER)) {
            String passwordAndRole = userProps.getProperty(DEFAULT_ADMIN_USER).trim();
            decodedZookeeperPassword = passwordAndRole.substring(0, passwordAndRole.indexOf(ROLE_DELIMITER));
        } else {
            decodedZookeeperPassword = PasswordEncoder.encode(CreateEnsembleOptions.generatePassword());
        }
        if (!Boolean.getBoolean("karaf.restart") && this.zookeeperUrl != null && this.zookeeperPassword != null && (zkConfugiration = ((ConfigurationAdmin)this.configAdmin.get()).getConfiguration("io.fabric8.zookeeper")).getProperties() == null) {
            Hashtable<String, String> zkProperties = new Hashtable<String, String>();
            zkProperties.put("zookeeper.url", this.zookeeperUrl);
            zkProperties.put("zookeeper.password", PasswordEncoder.encode(decodedZookeeperPassword));
            zkConfugiration.update(zkProperties);
        }
        if (userProps.isEmpty()) {
            userProps.put(DEFAULT_ADMIN_USER, decodedZookeeperPassword + ROLE_DELIMITER + DEFAULT_ADMIN_ROLE);
        }
        if (!Strings.isNullOrBlank((String)(minimumPort = (String)this.configuration.get("minimum.port")))) {
            this.minport = Integer.valueOf(minimumPort);
        }
        if (!Strings.isNullOrBlank((String)(maximumPort = (String)this.configuration.get("maximum.port")))) {
            this.maxport = Integer.valueOf(maximumPort);
        }
        this.options = ((CreateEnsembleOptions.Builder)((CreateEnsembleOptions.Builder)((CreateEnsembleOptions.Builder)((CreateEnsembleOptions.Builder)((CreateEnsembleOptions.Builder)((CreateEnsembleOptions.Builder)((CreateEnsembleOptions.Builder)CreateEnsembleOptions.builder().bindAddress(this.bindAddress)).agentEnabled(this.agentAutoStart).ensembleStart(this.ensembleAutoStart).zookeeperPassword(decodedZookeeperPassword).zooKeeperServerPort(this.zookeeperServerPort).zooKeeperServerConnectionPort(this.zookeeperServerConnectionPort).autoImportEnabled(this.profilesAutoImport).importPath(this.profilesAutoImportPath).resolver(this.localResolver)).globalResolver(this.globalResolver)).users((Map)userProps).minimumPort(this.minport)).maximumPort(this.maxport)).profiles(this.profiles)).version(this.version)).build();
    }

    void bootIfNeeded() throws IOException {
        BundleContext bundleContext = this.componentContext.getBundleContext();
        boolean isCreated = this.checkCreated(bundleContext);
        if (!Strings.isNotBlank((String)this.zookeeperUrl) && !isCreated && this.options.isEnsembleStart()) {
            String connectionUrl = this.getConnectionUrl(this.options);
            DataStoreOptions bootOptions = new DataStoreOptions(this.runtimeId, this.homeDir, connectionUrl, this.options);
            ((RuntimeProperties)this.runtimeProperties.get()).putRuntimeAttribute(DataStoreTemplate.class, (Object)new DataStoreBootstrapTemplate(bootOptions));
            this.createOrUpdateDataStoreConfig(this.options);
            this.createZooKeeeperServerConfig(this.options);
            this.createZooKeeeperClientConfig(connectionUrl, this.options);
            this.markCreated(bundleContext);
        }
    }

    public ComponentContext getComponentContext() {
        return this.componentContext;
    }

    private boolean checkCreated(BundleContext bundleContext) throws IOException {
        Properties props = new Properties(new File(this.dataDir, ENSEMBLE_MARKER));
        return props.containsKey("created");
    }

    private void markCreated(BundleContext bundleContext) throws IOException {
        File marker = new File(this.dataDir, ENSEMBLE_MARKER);
        if (!(marker.exists() || marker.getParentFile().exists() || marker.getParentFile().mkdirs())) {
            throw new IOException("Cannot create marker file");
        }
        Properties props = new Properties(marker);
        props.put("created", "true");
        props.save();
    }

    public CreateEnsembleOptions getBootstrapOptions() {
        this.assertValid();
        return this.options;
    }

    public String getConnectionUrl(CreateEnsembleOptions options) throws UnknownHostException {
        int zooKeeperServerConnectionPort = options.getZooKeeperServerConnectionPort();
        String connectionUrl = this.getConnectionAddress(options) + ":" + zooKeeperServerConnectionPort;
        return connectionUrl;
    }

    public void createOrUpdateDataStoreConfig(CreateEnsembleOptions options) throws IOException {
        Configuration config = ((ConfigurationAdmin)this.configAdmin.get()).getConfiguration("io.fabric8.datastore", null);
        Hashtable<String, String> properties = new Hashtable<String, String>();
        boolean updateConfig = false;
        Map dataStoreProperties = options.getDataStoreProperties();
        for (Map.Entry entry : dataStoreProperties.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            String oldval = ((Dictionary)properties).put(key, value);
            updateConfig = updateConfig || !value.equals(oldval);
        }
        if (updateConfig) {
            config.update(properties);
        }
        if (updateConfig) {
            config.update(properties);
        }
    }

    public void createZooKeeeperServerConfig(CreateEnsembleOptions options) throws IOException {
        int serverPort = Ports.mapPortToRange(options.getZooKeeperServerPort(), options.getMinimumPort(), options.getMaximumPort());
        String serverHost = options.getBindAddress();
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        if (options.isAutoImportEnabled()) {
            this.loadPropertiesFrom(properties, options.getImportPath() + "/fabric/profiles/default.profile/io.fabric8.zookeeper.server.properties");
        }
        ((Dictionary)properties).put("tickTime", String.valueOf(options.getZooKeeperServerTickTime()));
        ((Dictionary)properties).put("initLimit", String.valueOf(options.getZooKeeperServerInitLimit()));
        ((Dictionary)properties).put("syncLimit", String.valueOf(options.getZooKeeperServerSyncLimit()));
        ((Dictionary)properties).put("dataDir", options.getZooKeeperServerDataDir() + File.separator + "0000");
        ((Dictionary)properties).put("clientPort", Integer.toString(serverPort));
        ((Dictionary)properties).put("clientPortAddress", serverHost);
        ((Dictionary)properties).put("fabric.zookeeper.pid", "io.fabric8.zookeeper.server-0000");
        Configuration config = ((ConfigurationAdmin)this.configAdmin.get()).createFactoryConfiguration("io.fabric8.zookeeper.server", null);
        config.update(properties);
    }

    public void createZooKeeeperClientConfig(String connectionUrl, CreateEnsembleOptions options) throws IOException {
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        if (options.isAutoImportEnabled()) {
            this.loadPropertiesFrom(properties, options.getImportPath() + "/fabric/profiles/default.profile/io.fabric8.zookeeper.properties");
        }
        ((Dictionary)properties).put("zookeeper.url", connectionUrl);
        ((Dictionary)properties).put("zookeeper.timeout", System.getProperties().containsKey("zookeeper.timeout") ? System.getProperties().getProperty("zookeeper.timeout") : "30000");
        ((Dictionary)properties).put("fabric.zookeeper.pid", "io.fabric8.zookeeper");
        ((Dictionary)properties).put("zookeeper.password", PasswordEncoder.encode(options.getZookeeperPassword()));
        Configuration config = ((ConfigurationAdmin)this.configAdmin.get()).getConfiguration("io.fabric8.zookeeper", null);
        config.update(properties);
    }

    private String getConnectionAddress(CreateEnsembleOptions options) throws UnknownHostException {
        String oManualIp;
        String oResolver = Strings.isNotBlank((String)options.getResolver()) ? options.getResolver() : this.localResolver;
        String string = oManualIp = Strings.isNotBlank((String)options.getManualIp()) ? options.getManualIp() : this.manualip;
        if (oResolver.equals("localhostname")) {
            return HostUtils.getLocalHostName();
        }
        if (oResolver.equals("localip")) {
            return HostUtils.getLocalIp();
        }
        if (oResolver.equals("publichostname") && this.publichostname != null && !this.publichostname.isEmpty()) {
            return this.publichostname;
        }
        if (oResolver.equals("manualip") && oManualIp != null && !oManualIp.isEmpty()) {
            return oManualIp;
        }
        return HostUtils.getLocalHostName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadPropertiesFrom(Dictionary<String, Object> dictionary, String from) {
        FileInputStream is = null;
        Properties properties = new Properties();
        try {
            is = new FileInputStream(from);
            properties.load(is);
            for (String key : properties.keySet()) {
                dictionary.put(key, properties.get(key));
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (is != null) {
                try {
                    ((InputStream)is).close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public String getLocalResolver() {
        return this.localResolver;
    }

    public String getGlobalResolver() {
        return this.globalResolver;
    }

    public String getManualip() {
        return this.manualip;
    }

    public String getVersion() {
        return this.version;
    }

    public Set<String> getProfiles() {
        return Collections.unmodifiableSet(this.profiles);
    }

    public String getBindAddress() {
        return this.bindAddress;
    }

    public Map<String, ?> getConfiguration() {
        return Collections.unmodifiableMap(this.configuration);
    }

    void bindConfigAdmin(ConfigurationAdmin service) {
        this.configAdmin.bind((Object)service);
    }

    void unbindConfigAdmin(ConfigurationAdmin service) {
        this.configAdmin.unbind((Object)service);
    }

    void bindRuntimeProperties(RuntimeProperties service) {
        this.runtimeProperties.bind((Object)service);
    }

    void unbindRuntimeProperties(RuntimeProperties service) {
        this.runtimeProperties.unbind((Object)service);
    }

    protected void bindConfigurer(Configurer configurer) {
        this.configurer = configurer;
    }

    protected void unbindConfigurer(Configurer configurer) {
        if (this.configurer == configurer) {
            this.configurer = null;
        }
    }

    public static class DataStoreOptions {
        private final String containerId;
        private final File homeDir;
        private final String connectionUrl;
        private final CreateEnsembleOptions options;

        public DataStoreOptions(String containerId, File homeDir, String connectionUrl, CreateEnsembleOptions options) {
            this.connectionUrl = connectionUrl;
            this.containerId = containerId;
            this.homeDir = homeDir;
            this.options = options;
        }

        public String getContainerId() {
            return this.containerId;
        }

        public File getHomeDir() {
            return this.homeDir;
        }

        public String getConnectionUrl() {
            return this.connectionUrl;
        }

        public CreateEnsembleOptions getCreateOptions() {
            return this.options;
        }
    }
}

