/*
 * Decompiled with CFR 0.152.
 */
package org.apache.curator.retry;

import com.google.common.annotations.VisibleForTesting;
import org.apache.curator.retry.ExponentialBackoffRetry;

public class BoundedExponentialBackoffRetry
extends ExponentialBackoffRetry {
    private final int maxSleepTimeMs;

    public BoundedExponentialBackoffRetry(int baseSleepTimeMs, int maxSleepTimeMs, int maxRetries) {
        super(baseSleepTimeMs, maxRetries);
        this.maxSleepTimeMs = maxSleepTimeMs;
    }

    @VisibleForTesting
    public int getMaxSleepTimeMs() {
        return this.maxSleepTimeMs;
    }

    @Override
    protected long getSleepTimeMs(int retryCount, long elapsedTimeMs) {
        return Math.min((long)this.maxSleepTimeMs, super.getSleepTimeMs(retryCount, elapsedTimeMs));
    }
}

