/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.zookeeper.utils;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Map;
import org.osgi.framework.BundleContext;

public class InterpolationHelper {
    public static final String MARKER = "$__";
    private static final char ESCAPE_CHAR = '\\';
    private static final String DELIM_START = "${";
    private static final String DELIM_STOP = "}";

    private InterpolationHelper() {
    }

    public static void performSubstitution(Map<String, String> properties) {
        InterpolationHelper.performSubstitution(properties, (BundleContext)null);
    }

    public static void performSubstitution(Map<String, String> properties, final BundleContext context) {
        InterpolationHelper.performSubstitution(properties, new SubstitutionCallback(){

            @Override
            public String getValue(String key) {
                String value = null;
                if (context != null) {
                    value = context.getProperty(key);
                }
                if (value == null) {
                    value = System.getProperty(value, "");
                }
                return value;
            }
        });
    }

    public static void performSubstitution(Map<String, String> properties, SubstitutionCallback callback) {
        for (String name : properties.keySet()) {
            String value = properties.get(name);
            properties.put(name, InterpolationHelper.substVars(value, name, null, properties, callback));
        }
    }

    public static String substVars(String val, String currentKey, Map<String, String> cycleMap, Map<String, String> configProps, SubstitutionCallback callback, boolean defaultsToEmptyString) throws IllegalArgumentException {
        String substValue;
        int idx;
        if (cycleMap == null) {
            cycleMap = new HashMap<String, String>();
        }
        cycleMap.put(currentKey, currentKey);
        int stopDelim = val.indexOf(DELIM_STOP);
        while (stopDelim > 0 && val.charAt(stopDelim - 1) == '\\') {
            stopDelim = val.indexOf(DELIM_STOP, stopDelim + 1);
        }
        int startDelim = val.indexOf(DELIM_START);
        while (stopDelim >= 0 && (idx = val.indexOf(DELIM_START, startDelim + DELIM_START.length())) >= 0 && idx <= stopDelim) {
            if (idx >= stopDelim) continue;
            startDelim = idx;
        }
        if (startDelim < 0 || stopDelim < 0) {
            return InterpolationHelper.unescape(val);
        }
        if (startDelim >= stopDelim) {
            return InterpolationHelper.unescape(val);
        }
        String variable = val.substring(startDelim + DELIM_START.length(), stopDelim);
        if (cycleMap.get(variable) != null) {
            throw new IllegalArgumentException("recursive variable reference: " + variable);
        }
        String string = substValue = configProps != null ? configProps.get(variable) : null;
        if (substValue == null) {
            if (variable.length() <= 0) {
                substValue = "";
            } else {
                if (callback != null) {
                    substValue = callback.getValue(variable);
                }
                if (substValue == null) {
                    substValue = defaultsToEmptyString ? System.getProperty(variable, "") : System.getProperty(variable, "$__{" + variable + DELIM_STOP);
                }
            }
        }
        cycleMap.remove(variable);
        val = val.substring(0, startDelim) + substValue + val.substring(stopDelim + DELIM_STOP.length(), val.length());
        val = defaultsToEmptyString ? InterpolationHelper.substVars(val, currentKey, cycleMap, configProps, callback, defaultsToEmptyString) : InterpolationHelper.substVarsPreserveUnresolved(val, currentKey, cycleMap, configProps, callback);
        val = InterpolationHelper.unescape(val);
        return val;
    }

    public static String substVars(String val, String currentKey, Map<String, String> cycleMap, Map<String, String> configProps, SubstitutionCallback callback) throws IllegalArgumentException {
        return InterpolationHelper.substVars(val, currentKey, cycleMap, configProps, callback, true);
    }

    public static String substVarsPreserveUnresolved(String val, String currentKey, Map<String, String> cycleMap, Map<String, String> configProps, SubstitutionCallback callback) throws IllegalArgumentException {
        String result = InterpolationHelper.substVars(val, currentKey, cycleMap, configProps, callback, false);
        String subs = result != null ? result.replaceAll("\\$__", "\\$") : result;
        return subs;
    }

    private static String unescape(String val) {
        int escape = val.indexOf(92);
        while (escape >= 0 && escape < val.length() - 1) {
            char c = val.charAt(escape + 1);
            if (c == '{' || c == '}' || c == '\\') {
                val = val.substring(0, escape) + val.substring(escape + 1);
            }
            escape = val.indexOf(92, escape + 1);
        }
        return val;
    }

    public static boolean escapePropertyPlaceholders(Hashtable<String, Object> configuration) {
        boolean anyEscape = false;
        for (Map.Entry<String, Object> entry : configuration.entrySet()) {
            if (!(entry.getValue() instanceof String) || !((String)entry.getValue()).contains(DELIM_START)) continue;
            String v = (String)entry.getValue();
            StringBuilder sb = new StringBuilder();
            char[] charArray = v.toCharArray();
            LinkedList<Boolean> stack = new LinkedList<Boolean>();
            int charArrayLength = charArray.length;
            block6: for (int i = 0; i < charArrayLength; ++i) {
                char c = charArray[i];
                switch (c) {
                    case '$': {
                        if (i >= charArrayLength - 1 || charArray[i + 1] != '{') continue block6;
                        sb.append("$\\");
                        anyEscape = true;
                        continue block6;
                    }
                    case '{': {
                        stack.push(i > 0 && charArray[i - 1] == '$');
                        sb.append("{");
                        continue block6;
                    }
                    case '}': {
                        if (stack.peek() != null && ((Boolean)stack.peek()).booleanValue()) {
                            sb.append("\\");
                        }
                        stack.pop();
                        sb.append(DELIM_STOP);
                        continue block6;
                    }
                    default: {
                        sb.append(c);
                    }
                }
            }
            configuration.put(entry.getKey(), sb.toString());
        }
        return anyEscape;
    }

    public static interface SubstitutionCallback {
        public String getValue(String var1);
    }
}

