/*
 * Decompiled with CFR 0.152.
 */
package org.apache.curator.framework.recipes.cache;

import java.util.Arrays;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.curator.framework.recipes.cache.ChildData;
import org.apache.zookeeper.data.Stat;

public class ChildDataExtended
extends ChildData {
    private final AtomicReference<byte[]> data;

    public ChildDataExtended(String path, Stat stat, byte[] data) {
        super(path, stat, null);
        this.data = new AtomicReference<byte[]>(data);
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        ChildDataExtended childData = (ChildDataExtended)o;
        return Arrays.equals(this.data.get(), childData.data.get());
    }

    @Override
    public int hashCode() {
        int result = this.getPath() != null ? this.getPath().hashCode() : 0;
        result = 31 * result + (this.getStat() != null ? this.getStat().hashCode() : 0);
        result = 31 * result + (this.data != null ? Arrays.hashCode(this.data.get()) : 0);
        return result;
    }

    @Override
    public byte[] getData() {
        return this.data.get();
    }

    void clearData() {
        this.data.set(null);
    }

    @Override
    public String toString() {
        return "ChildDataExtended{path='" + this.getPath() + '\'' + ", stat=" + this.getStat() + ", data=" + Arrays.toString(this.data.get()) + '}';
    }
}

