/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.zookeeper.utils;

import io.fabric8.api.FabricException;
import io.fabric8.api.RuntimeProperties;
import io.fabric8.zookeeper.ZkPath;
import io.fabric8.zookeeper.utils.InterpolationHelper;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.framework.api.BackgroundPathable;
import org.apache.curator.framework.recipes.cache.ChildData;
import org.apache.curator.framework.recipes.cache.TreeCacheExtended;
import org.apache.curator.framework.recipes.cache.TreeData;
import org.apache.curator.utils.ZKPaths;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ZooKeeperUtils {
    public static Logger LOG = LoggerFactory.getLogger(ZooKeeperUtils.class);
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private static final String CONTAINERS_NODE = "/fabric/authentication/containers";
    private static final char[] DIGITS_LOWER = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static volatile long lastTokenGenerationTime = 0L;

    private ZooKeeperUtils() {
    }

    public static void copy(CuratorFramework source, CuratorFramework dest, String path) throws Exception {
        for (String child : (List)source.getChildren().forPath(path)) {
            child = ZKPaths.makePath(path, child);
            Stat stat = (Stat)source.checkExists().forPath(child);
            if (stat == null || stat.getEphemeralOwner() != 0L || dest.checkExists().forPath(child) != null) continue;
            byte[] data = (byte[])source.getData().forPath(child);
            ZooKeeperUtils.setData(dest, child, data);
            ZooKeeperUtils.copy(source, dest, child);
        }
    }

    public static void copy(CuratorFramework curator, String from, String to) throws Exception {
        for (String child : (List)curator.getChildren().forPath(from)) {
            String fromChild = from + "/" + child;
            String toChild = to + "/" + child;
            if (curator.checkExists().forPath(toChild) != null) continue;
            byte[] data = (byte[])curator.getData().forPath(fromChild);
            ZooKeeperUtils.setData(curator, toChild, data);
            ZooKeeperUtils.copy(curator, fromChild, toChild);
        }
    }

    public static void add(CuratorFramework curator, String path, String value) throws Exception {
        if (curator.checkExists().forPath(path) == null) {
            curator.setData().forPath(path, value != null ? value.getBytes(UTF_8) : null);
        } else {
            String data = ZooKeeperUtils.getStringData(curator, path);
            if (data == null) {
                data = "";
            }
            if (data.length() > 0) {
                data = data + " ";
            }
            data = data + value;
            curator.setData().forPath(path, data.getBytes(UTF_8));
        }
    }

    public static void remove(CuratorFramework curator, String path, String value) throws Exception {
        if (curator.checkExists().forPath(path) != null) {
            AbstractList parts = new LinkedList();
            String data = ZooKeeperUtils.getStringData(curator, path);
            if (data != null) {
                parts = new ArrayList<String>(Arrays.asList(data.trim().split(" +")));
            }
            boolean changed = false;
            StringBuilder sb = new StringBuilder();
            Iterator it = parts.iterator();
            while (it.hasNext()) {
                String v = (String)it.next();
                if (!v.matches(value)) continue;
                it.remove();
                changed = true;
            }
            if (changed) {
                sb.delete(0, sb.length());
                for (String part : parts) {
                    if (sb.length() > 0) {
                        sb.append(" ");
                    }
                    sb.append(part);
                }
                ZooKeeperUtils.setData(curator, path, sb.toString());
            }
        }
    }

    public static List<String> getChildren(CuratorFramework curator, String path) throws Exception {
        return (List)curator.getChildren().forPath(path);
    }

    public static List<String> getChildrenSafe(CuratorFramework curator, String path) throws Exception {
        boolean pathExists = curator.checkExists().forPath(path) != null;
        return pathExists ? (List)curator.getChildren().forPath(path) : Collections.emptyList();
    }

    public static List<String> getChildren(TreeCacheExtended cache, String path) throws Exception {
        return cache.getChildrenNames(path);
    }

    public static List<String> getAllChildren(CuratorFramework curator, String path) throws Exception {
        List<String> children = ZooKeeperUtils.getChildren(curator, path);
        ArrayList<String> allChildren = new ArrayList<String>();
        for (String child : children) {
            String fullPath = ZKPaths.makePath(path, child);
            allChildren.add(fullPath);
            allChildren.addAll(ZooKeeperUtils.getAllChildren(curator, fullPath));
        }
        return allChildren;
    }

    public static List<String> getAllChildren(TreeCacheExtended cache, String path) throws Exception {
        List<String> children = ZooKeeperUtils.getChildren(cache, path);
        ArrayList<String> allChildren = new ArrayList<String>();
        for (String child : children) {
            String fullPath = ZKPaths.makePath(path, child);
            allChildren.add(fullPath);
            allChildren.addAll(ZooKeeperUtils.getAllChildren(cache, fullPath));
        }
        return allChildren;
    }

    public static byte[] getByteData(TreeCacheExtended cache, String path) throws Exception {
        TreeData cacheData = cache.getCurrentData(path);
        if (cacheData != null) {
            return ((ChildData)cacheData).getData();
        }
        return null;
    }

    public static String getStringData(TreeCacheExtended cache, String path) throws Exception {
        byte[] data = ZooKeeperUtils.getByteData(cache, path);
        if (data == null) {
            return null;
        }
        return new String(data, UTF_8);
    }

    public static String getStringData(CuratorFramework curator, String path) throws Exception {
        return ZooKeeperUtils.getStringData(curator, path, null);
    }

    public static String getStringData(CuratorFramework curator, String path, Watcher watcher) throws Exception {
        byte[] bytes;
        byte[] byArray = bytes = watcher != null ? (byte[])((BackgroundPathable)curator.getData().usingWatcher(watcher)).forPath(path) : (byte[])curator.getData().forPath(path);
        if (bytes == null) {
            return null;
        }
        return new String(bytes, UTF_8);
    }

    public static String getStringDataSafe(CuratorFramework curator, String path) throws Exception {
        byte[] bytes = ZooKeeperUtils.getData(curator, path);
        if (bytes == null) {
            return null;
        }
        return new String(bytes, UTF_8);
    }

    public static byte[] getData(CuratorFramework curator, String path) throws Exception {
        if (curator.checkExists().forPath(path) != null) {
            return (byte[])curator.getData().forPath(path);
        }
        return null;
    }

    public static void setData(CuratorFramework curator, String path, String value) throws Exception {
        ZooKeeperUtils.setData(curator, path, value != null ? value.getBytes(UTF_8) : null);
    }

    public static void setData(CuratorFramework curator, String path, byte[] value) throws Exception {
        if (curator.checkExists().forPath(path) == null) {
            curator.create().creatingParentsIfNeeded().forPath(path, (byte[])(value != null ? value : null));
        }
        curator.setData().forPath(path, (byte[])(value != null ? value : null));
    }

    public static void setData(CuratorFramework curator, String path, String value, CreateMode createMode) throws Exception {
        ZooKeeperUtils.setData(curator, path, value != null ? value.getBytes(UTF_8) : null, createMode);
    }

    public static void setData(CuratorFramework curator, String path, byte[] value, CreateMode createMode) throws Exception {
        if (curator.checkExists().forPath(path) == null) {
            try {
                ((ACLBackgroundPathAndBytesable)curator.create().creatingParentsIfNeeded().withMode(createMode)).forPath(path, (byte[])(value != null ? value : null));
            }
            catch (KeeperException.NodeExistsException nodeExistsException) {
                // empty catch block
            }
        }
        curator.setData().forPath(path, (byte[])(value != null ? value : null));
    }

    public static void create(CuratorFramework curator, String path) throws Exception {
        ZooKeeperUtils.create(curator, path, CreateMode.PERSISTENT);
    }

    public static String create(CuratorFramework curator, String path, CreateMode createMode) throws Exception {
        return ZooKeeperUtils.create(curator, path, (byte[])null, createMode);
    }

    public static String create(CuratorFramework curator, String path, String data, CreateMode createMode) throws Exception {
        return ZooKeeperUtils.create(curator, path, data != null ? data.getBytes(UTF_8) : null, createMode);
    }

    public static String create(CuratorFramework curator, String path, byte[] data, CreateMode createMode) throws Exception {
        return (String)((ACLBackgroundPathAndBytesable)curator.create().creatingParentsIfNeeded().withMode(createMode)).forPath(path, data);
    }

    public static void createDefault(CuratorFramework curator, String path, String value) throws Exception {
        if (curator.checkExists().forPath(path) == null) {
            curator.create().creatingParentsIfNeeded().forPath(path, value != null ? value.getBytes(UTF_8) : null);
        }
    }

    public static void deleteSafe(CuratorFramework curator, String path) throws Exception {
        if (curator.checkExists().forPath(path) != null) {
            for (String child : (List)curator.getChildren().forPath(path)) {
                ZooKeeperUtils.deleteSafe(curator, path + "/" + child);
            }
            try {
                curator.delete().forPath(path);
            }
            catch (KeeperException.NotEmptyException ex) {
                ZooKeeperUtils.deleteSafe(curator, path);
            }
        }
    }

    public static void deleteSafeUpTo(CuratorFramework curator, String path, String ... parent) throws Exception {
        if (curator.checkExists().forPath(path) != null) {
            for (String child : (List)curator.getChildren().forPath(path)) {
                ZooKeeperUtils.deleteSafe(curator, path + "/" + child);
            }
            try {
                curator.delete().forPath(path);
                String parentPath = ZooKeeperUtils.getParent(path);
                while (true) {
                    List children;
                    boolean end = false;
                    for (String p : parent) {
                        if (!parentPath.equals(p)) continue;
                        end = true;
                    }
                    if (!(end || (children = (List)curator.getChildren().forPath(parentPath)) != null && children.size() > 0)) {
                        curator.delete().forPath(parentPath);
                        parentPath = ZooKeeperUtils.getParent(parentPath);
                        continue;
                    }
                    break;
                }
            }
            catch (KeeperException.NotEmptyException ex) {
                ZooKeeperUtils.deleteSafe(curator, path);
            }
        }
    }

    public static String getParent(String path) {
        if (path == null || !path.startsWith("/")) {
            throw new IllegalArgumentException("Path is not valid: " + path);
        }
        String[] segments = path.split("/");
        StringBuilder sb = new StringBuilder();
        if (segments.length <= 2) {
            return "/";
        }
        for (int i = 1; i < segments.length - 1; ++i) {
            sb.append("/").append(segments[i]);
        }
        return sb.toString();
    }

    public static void delete(CuratorFramework curator, String path) throws Exception {
        curator.delete().forPath(path);
    }

    public static void deleteIfExists(CuratorFramework curator, String path) throws Exception {
        try {
            curator.delete().forPath(path);
        }
        catch (KeeperException.NoNodeException noNodeException) {
            // empty catch block
        }
    }

    public static Stat exists(CuratorFramework curator, String path) throws Exception {
        return (Stat)curator.checkExists().forPath(path);
    }

    public static Properties getProperties(CuratorFramework curator, String path, Watcher watcher) throws Exception {
        String value = ZooKeeperUtils.getStringData(curator, path, watcher);
        Properties properties = new Properties();
        if (value != null) {
            try {
                properties.load(new StringReader(value));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return properties;
    }

    public static Map<String, String> getPropertiesAsMap(CuratorFramework curator, String path) throws Exception {
        Properties properties = ZooKeeperUtils.getProperties(curator, path);
        HashMap<String, String> map = new HashMap<String, String>();
        for (String key : properties.stringPropertyNames()) {
            map.put(key, properties.getProperty(key));
        }
        return map;
    }

    public static Map<String, String> getPropertiesAsMap(TreeCacheExtended cache, String path) throws Exception {
        Properties properties = ZooKeeperUtils.getProperties(cache, path);
        HashMap<String, String> map = new HashMap<String, String>();
        for (String key : properties.stringPropertyNames()) {
            map.put(key, properties.getProperty(key));
        }
        return map;
    }

    public static Properties getProperties(CuratorFramework curator, String path) throws Exception {
        String value = ZooKeeperUtils.getStringDataSafe(curator, path);
        Properties properties = new Properties();
        if (value != null) {
            try {
                properties.load(new StringReader(value));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return properties;
    }

    public static Properties getProperties(TreeCacheExtended cace, String path) throws Exception {
        String value = ZooKeeperUtils.getStringData(cace, path);
        Properties properties = new Properties();
        if (value != null) {
            try {
                properties.load(new StringReader(value));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return properties;
    }

    public static void setPropertiesAsMap(CuratorFramework curator, String path, Map<String, String> map) throws Exception {
        Properties properties = new Properties();
        for (String key : map.keySet()) {
            properties.put(key, map.get(key));
        }
        ZooKeeperUtils.setProperties(curator, path, properties);
    }

    public static void setProperties(CuratorFramework curator, String path, Properties properties) throws Exception {
        try {
            String org;
            org.apache.felix.utils.properties.Properties p = new org.apache.felix.utils.properties.Properties();
            if (curator.checkExists().forPath(path) == null) {
                ZooKeeperUtils.create(curator, path);
            }
            if ((org = ZooKeeperUtils.getStringData(curator, path)) != null) {
                p.load(new StringReader(org));
            }
            ArrayList<String> keys = new ArrayList<String>();
            for (String key : properties.stringPropertyNames()) {
                p.put(key, properties.getProperty(key));
                keys.add(key);
            }
            ArrayList deleted = new ArrayList(p.keySet());
            deleted.removeAll(keys);
            for (String key : deleted) {
                p.remove(key);
            }
            StringWriter writer = new StringWriter();
            p.save(writer);
            ZooKeeperUtils.setData(curator, path, writer.toString());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static String getSubstitutedPath(CuratorFramework curator, String path) throws Exception {
        byte[] data;
        String normalized;
        String string = normalized = path != null && path.contains("#") ? path.substring(0, path.lastIndexOf(35)) : path;
        if (normalized != null && ZooKeeperUtils.exists(curator, normalized) != null && (data = ZkPath.loadURL(curator, path)) != null && data.length > 0) {
            String str = new String(ZkPath.loadURL(curator, path), "UTF-8");
            return ZooKeeperUtils.getSubstitutedData(curator, str);
        }
        return null;
    }

    public static String getSubstitutedData(final CuratorFramework curator, String data) throws URISyntaxException {
        if (data == null) {
            return null;
        }
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("data", data);
        InterpolationHelper.performSubstitution(props, new InterpolationHelper.SubstitutionCallback(){

            @Override
            public String getValue(String key) {
                if (key.startsWith("zk:")) {
                    try {
                        return new String(ZkPath.loadURL(curator, key), "UTF-8");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return null;
            }
        });
        return (String)props.get("data");
    }

    public static String generatePassword() {
        StringBuilder password = new StringBuilder();
        for (int i = 0; i < 16; ++i) {
            long l = Math.round(Math.floor(Math.random() * 62.0));
            if (l < 10L) {
                password.append((char)(48L + l));
                continue;
            }
            if (l < 36L) {
                password.append((char)(65L + l - 10L));
                continue;
            }
            password.append((char)(97L + l - 36L));
        }
        return password.toString();
    }

    public static long lastModified(CuratorFramework curator, String path) throws Exception {
        long lastModified = 0L;
        List<String> children = ZooKeeperUtils.getChildren(curator, path);
        if (children.isEmpty()) {
            return ZooKeeperUtils.exists(curator, path).getMtime();
        }
        for (String child : children) {
            lastModified = Math.max(ZooKeeperUtils.lastModified(curator, path + "/" + child), lastModified);
        }
        return lastModified;
    }

    public static String getContainerLogin(RuntimeProperties sysprops) {
        String container = sysprops.getRuntimeIdentity();
        return "container#" + container;
    }

    public static boolean isContainerLogin(String login) {
        return login.startsWith("container#");
    }

    public static Properties getContainerTokens(CuratorFramework curator) throws Exception {
        Properties props = new Properties();
        if (ZooKeeperUtils.exists(curator, CONTAINERS_NODE) != null) {
            for (String key : ZooKeeperUtils.getChildren(curator, CONTAINERS_NODE)) {
                props.setProperty("container#" + key, ZooKeeperUtils.getStringData(curator, "/fabric/authentication/containers/" + key));
            }
        }
        return props;
    }

    public static String generateContainerToken(RuntimeProperties sysprops, CuratorFramework curator) {
        String container = sysprops.getRuntimeIdentity();
        long time = System.currentTimeMillis();
        String password = null;
        try {
            if (time - lastTokenGenerationTime < 60000L) {
                try {
                    password = ZooKeeperUtils.getStringData(curator, "/fabric/authentication/containers/" + container);
                }
                catch (KeeperException.NoNodeException noNodeException) {
                    // empty catch block
                }
            }
            if (password == null) {
                password = ZooKeeperUtils.generatePassword();
                ZooKeeperUtils.setData(curator, "/fabric/authentication/containers/" + container, password);
                lastTokenGenerationTime = time;
            }
        }
        catch (KeeperException.NotReadOnlyException e) {
            throw new FabricException("ZooKeeper server is partitioned. Currently working in read-only mode!");
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception ex) {
            throw new IllegalStateException("Cannot generate container token", ex);
        }
        return password;
    }

    public static String derivePeerPassword(Properties props, int serverId) throws GeneralSecurityException {
        TreeMap<String, String> c14n = new TreeMap<String, String>();
        for (String property : props.stringPropertyNames()) {
            String v;
            if (property.startsWith("clientPort") || property.equals("component.id") || property.equals("server.id") || property.equals("dataDir") || property.equals("service.pid") || property.equals("felix.fileinstall.filename") || (v = props.getProperty(property)) == null) continue;
            c14n.put(property, v.trim());
        }
        MessageDigest sha = MessageDigest.getInstance("SHA");
        LOG.info(String.format("== Deriving password for peer %d", serverId));
        for (Map.Entry entry : c14n.entrySet()) {
            sha.update(((String)entry.getKey()).getBytes(StandardCharsets.UTF_8));
            sha.update(((String)entry.getValue()).getBytes(StandardCharsets.UTF_8));
        }
        sha.update("server.id".getBytes(StandardCharsets.UTF_8));
        sha.update(Integer.toString(serverId).getBytes(StandardCharsets.UTF_8));
        byte[] digest = sha.digest();
        return new String(ZooKeeperUtils.encodeHex(digest, DIGITS_LOWER));
    }

    protected static char[] encodeHex(byte[] data, char[] toDigits) {
        int l = data.length;
        char[] out = new char[l << 1];
        int j = 0;
        for (int i = 0; i < l; ++i) {
            out[j++] = toDigits[(0xF0 & data[i]) >>> 4];
            out[j++] = toDigits[0xF & data[i]];
        }
        return out;
    }
}

