/*
 * Decompiled with CFR 0.152.
 */
package org.apache.curator.framework.recipes.cache;

import com.google.common.base.Preconditions;
import org.apache.curator.framework.recipes.cache.Operation;
import org.apache.curator.framework.recipes.cache.TreeCacheExtended;

class TreeRefreshOperation
implements Operation {
    private final TreeCacheExtended cache;
    private final String path;
    private final TreeCacheExtended.RefreshMode mode;

    TreeRefreshOperation(TreeCacheExtended cache, String path, TreeCacheExtended.RefreshMode mode) {
        this.cache = (TreeCacheExtended)Preconditions.checkNotNull((Object)cache, (Object)"cache");
        this.path = (String)Preconditions.checkNotNull((Object)path, (Object)"path");
        this.mode = (TreeCacheExtended.RefreshMode)((Object)Preconditions.checkNotNull((Object)((Object)mode), (Object)"mode"));
    }

    @Override
    public void invoke() throws Exception {
        this.cache.refresh(this.path, this.mode);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TreeRefreshOperation that = (TreeRefreshOperation)o;
        if (this.mode != that.mode) {
            return false;
        }
        return !(this.path != null ? !this.path.equals(that.path) : that.path != null);
    }

    public int hashCode() {
        int result = this.path != null ? this.path.hashCode() : 0;
        result = 31 * result + (this.mode != null ? this.mode.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "RefreshOperation(" + this.path + "," + (Object)((Object)this.mode) + "){}";
    }
}

